/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.OptionalValueParser;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/ui/grid/editors/ValueParserWrapper;", "T", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "parser", "Lcom/intellij/database/run/ui/grid/editors/OptionalValueParser;", "nullable", "", "emptyValue", "Lcom/intellij/database/run/ReservedCellValue;", "unparsedValueCreator", "Lkotlin/Function1;", "", "Lcom/intellij/database/run/ui/grid/editors/UnparsedValue;", "(Lcom/intellij/database/run/ui/grid/editors/OptionalValueParser;ZLcom/intellij/database/run/ReservedCellValue;Lkotlin/jvm/functions/Function1;)V", "parse", "", "text", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.database.impl"})
public final class ValueParserWrapper<T>
implements GridCellEditorFactory.ValueParser {
    private final OptionalValueParser<T> parser;
    private final boolean nullable;
    private final ReservedCellValue emptyValue;
    private final Function1<String, UnparsedValue> unparsedValueCreator;

    @Override
    @NotNull
    public Object parse(@NotNull String text2, @Nullable Document document) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this.emptyValue != null && StringUtil.isEmptyOrSpaces((String)text2)) {
            return this.emptyValue;
        }
        if (this.nullable && StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"null") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"<null>")) {
            return ReservedCellValue.NULL;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"default") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"<default>")) {
            return ReservedCellValue.DEFAULT;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"generated") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"<generated>")) {
            return ReservedCellValue.GENERATED;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"computed") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"<computed>")) {
            return ReservedCellValue.COMPUTED;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"unset") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"<unset>")) {
            return ReservedCellValue.COMPUTED;
        }
        Object object = this.parser.parse(text2);
        if (object == null) {
            object = this.unparsedValueCreator.invoke((Object)text2);
        }
        return object;
    }

    public ValueParserWrapper(@NotNull OptionalValueParser<T> parser2, boolean nullable, @Nullable ReservedCellValue emptyValue, @NotNull Function1<? super String, ? extends UnparsedValue> unparsedValueCreator) {
        Intrinsics.checkNotNullParameter(parser2, (String)"parser");
        Intrinsics.checkNotNullParameter(unparsedValueCreator, (String)"unparsedValueCreator");
        this.parser = parser2;
        this.nullable = nullable;
        this.emptyValue = emptyValue;
        this.unparsedValueCreator = unparsedValueCreator;
    }
}

