/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.OptionalValueParser;
import com.intellij.database.run.ui.grid.editors.UniversalFormatter;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class MongoUUIDEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    public static final Pattern UUID_PATTERN = Pattern.compile("(?>new\\s+)?(?>UUID\\(\")?([0-9a-fA-F-]+)(\"\\))?");
    private final OptionalValueParser<UUID> myParser = text2 -> {
        Matcher matcher = UUID_PATTERN.matcher(text2 = text2.trim());
        if (!matcher.matches()) {
            return null;
        }
        try {
            return UUID.fromString(matcher.group(1));
        }
        catch (Exception e) {
            return null;
        }
    };

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(2);
        }
        if (!DataGridUtil.getDbms(grid).is(Dbms.MONGO)) {
            return 0;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Object value2 = model.getValueAt(row, column2);
        if (value2 instanceof UUID) {
            return 10;
        }
        DataConsumer.Column c2 = model.getColumn(column2);
        return (value2 == null || value2 instanceof ReservedCellValue) && c2 != null && "UUID".equals(c2.getTypeName()) ? 10 : 0;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(4);
        }
        return domain.simpleName().equals("UUID") ? 10 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(5);
        }
        if (domain == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(6);
        }
        return new ValueParserWrapper<UUID>(this.myParser, true, DataGridUtil.getDefaultNullValue(grid, null), (Function1<? super String, ? extends UnparsedValue>)((Function1)text2 -> new UnparsedValue((String)text2, domain)));
    }

    @Override
    @NotNull
    protected Formatter getFormatInner(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, final @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            MongoUUIDEditorFactory.$$$reportNull$$$0(9);
        }
        final GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        return new UniversalFormatter(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(grid.getObjectFormatter().objectToString(obj, (DataConsumer.Column)model.getColumn(columnIdx), DataGridUtil.getDbms(grid), ObjectFormatter.Mode.DISPLAY));
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                UUID parsed = MongoUUIDEditorFactory.this.myParser.parse(source);
                if (parsed != null) {
                    pos.setIndex(source.length());
                    return parsed;
                }
                pos.setErrorIndex(0);
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/MongoUUIDEditorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitability";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

