/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static boolean isBooleanCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        boolean isBooleanColumn;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(2);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = model.getColumn(column2);
        Object value2 = model.getValueAt(row, column2);
        boolean bl = isBooleanColumn = c2 != null && ObjectFormatter.isBooleanColumn(c2, value2, DataGridUtil.getDbms(grid));
        if (DataGridUtil.getDbms(grid).is(Dbms.MONGO)) {
            return value2 instanceof Boolean || isBooleanColumn && (value2 == null || value2 instanceof ReservedCellValue);
        }
        if (!isBooleanColumn) {
            return false;
        }
        return value2 == null || value2 == ReservedCellValue.NULL || value2 == ReservedCellValue.DEFAULT || ObjectFormatter.getBooleanValue(value2) != null;
    }

    public static boolean isNumericCell(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(3);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(5);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        DataConsumer.Column c2 = model.getColumn(column2);
        Object value2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        return c2 != null && ObjectFormatter.isNumericValue(value2, c2, DataGridUtil.getDbms(grid));
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup2 = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup2.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
            }
        });
        popup2.show(component, x, y);
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, final @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(6);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(7);
        }
        if (!GridCellEditorsUtil.canComplete(c2 = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column2), null, DataGridUtil.getDbms(grid))) {
            return null;
        }
        return new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List<String> items2 = GridCellEditorsUtil.getPossibleValues(grid, column2);
                if (!items2.isEmpty()) {
                    List<String> list = items2;
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List rows = model.getRows();
                HashSet<String> objects2 = new HashSet<String>(rows.size());
                Dbms dbms = DataGridUtil.getDbms(grid);
                for (DataConsumer.Row r : rows) {
                    Object v = c2.getValue(r);
                    if (v == null) continue;
                    objects2.add(grid.getObjectFormatter().getPlainValue(c2, r, dbms, ObjectFormatter.Mode.DISPLAY));
                }
                HashSet<String> hashSet = objects2;
                if (hashSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$2", "getItems"));
            }
        };
    }

    private static boolean canComplete(@Nullable DataConsumer.Column c2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (dbms == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(8);
        }
        return c2 != null && !DbImplUtil.canInsertBlob(c2, value2, dbms) && (JdbcUtil.isNumberType((int)c2.type) || !c2.clazz.equals("java.lang.Integer") || JdbcUtil.isStringType((int)c2.type));
    }

    @NotNull
    private static List<String> getPossibleValues(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        ModelHelper modelHelper;
        DataType dataType;
        List values2;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(10);
        }
        List list = values2 = (dataType = (modelHelper = DbImplUtil.getModelHelper(DataGridUtil.getDbms(grid))).getDataTypeForGridCompletion(grid, column2)) != null ? dataType.enumValues : null;
        List list2 = values2 != null ? ContainerUtil.map((Collection)values2, modelHelper::unquoteEnumValue) : ContainerUtil.emptyList();
        if (list2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanCell";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNumericCell";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canComplete";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleValues";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

