/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridCellEditor
extends Disposable {
    @NotNull
    public JComponent getComponent();

    default public boolean shouldMoveFocus() {
        return true;
    }

    @Nullable
    public Object getValue();

    @NotNull
    public String getText();

    public boolean stop();

    public void cancel();

    public boolean isColumnSpanAllowed();

    public void setEditingListener(@NotNull Consumer<Object> var1);

    public static interface EditorBased {
        public Editor getEditor();
    }

    public static abstract class Adapter
    implements GridCellEditor {
        private Consumer<Object> myEditingListener;

        @Override
        public boolean stop() {
            return true;
        }

        @Override
        public void cancel() {
        }

        public void dispose() {
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return true;
        }

        @Override
        public void setEditingListener(@NotNull Consumer<Object> listener2) {
            if (listener2 == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            this.myEditingListener = listener2;
        }

        protected final void fireEditing(@Nullable Object object) {
            if (this.myEditingListener != null) {
                this.myEditingListener.consume(object);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/run/ui/grid/editors/GridCellEditor$Adapter", "setEditingListener"));
        }
    }
}

