/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultTextEditorFactory
implements GridCellEditorFactory,
FactoryWithDomainSupport {
    private static final Set<String> PG_EDITABLE = ContainerUtil.set((Object[])new String[]{"uuid", "inet", "cidr", "macaddr", "interval", "money", "citext"});
    private static final Set<String> CASS_EDITABLE = ContainerUtil.set((Object[])new String[]{"set", "map", "list", "tuple", "udt", "uuid", "timeuuid", "inet"});

    DefaultTextEditorFactory() {
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(2);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = Objects.requireNonNull(model.getColumn(column2));
        int suitability = 0;
        Dbms dbms = DataGridUtil.getDbms(grid);
        if (dbms.in(Dbms.POSTGRES_LIKE)) {
            suitability = DefaultTextEditorFactory.getPostgresSuitability(c2);
        } else if (dbms.is(Dbms.CASSANDRA)) {
            suitability = DefaultTextEditorFactory.getCassandraSuitability(c2);
        } else if (dbms.is(Dbms.H2)) {
            suitability = DefaultTextEditorFactory.getH2Suitability(c2);
        } else if (dbms.is(Dbms.MONGO)) {
            suitability = DefaultTextEditorFactory.getMongoSuitability(model.getValueAt(row, column2));
        }
        if (suitability == 0) {
            suitability = DefaultTextEditorFactory.getCommonSuitability(c2, model.getValueAt(row, column2), dbms);
        }
        return suitability;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(4);
        }
        return domain.getLogicType() == LogicalType.TEXT ? 1 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(5);
        }
        if (domain == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(6);
        }
        GridCellEditorFactory.ValueParser valueParser = (text2, document) -> text2;
        if (valueParser == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(7);
        }
        return valueParser;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(8);
        }
        if (rowIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(9);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(10);
        }
        GridCellEditorFactory.ValueFormatter valueFormatter = DefaultTextEditorFactory.getValueFormatter(grid, columnIdx, value2);
        if (valueFormatter == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(11);
        }
        return valueFormatter;
    }

    private static GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(12);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(13);
        }
        return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value2);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object initialValue) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(14);
        }
        if (rowIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(15);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(16);
        }
        String initialText = this.getValueFormatter((DataGrid)grid, rowIdx, columnIdx, (Object)initialValue).format().text;
        GridCellEditorFactory.ValueParser valueParser = (text2, document) -> {
            boolean valueChanged = !initialText.equals(text2);
            return valueChanged ? text2 : ObjectUtils.notNull((Object)initialValue, (Object)((Object)ReservedCellValue.NULL));
        };
        if (valueParser == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(17);
        }
        return valueParser;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (dbms, value2) -> {
            if (value2 == null || value2 instanceof String || value2 instanceof ReservedCellValue || value2 instanceof LobInfo && !((LobInfo)value2).isTruncated() && (value2 instanceof LobInfo.ClobInfo || ((LobInfo)value2).length == 0L)) {
                return true;
            }
            if (dbms.in(Dbms.POSTGRES_LIKE)) {
                return value2 instanceof Object[];
            }
            if (dbms.is(Dbms.CASSANDRA)) {
                return value2 instanceof Map || value2 instanceof Set || value2 instanceof List;
            }
            if (dbms.is(Dbms.MONGO)) {
                return value2 instanceof Map || value2 instanceof List;
            }
            return false;
        };
        if (isEditableChecker == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(18);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(19);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(20);
        }
        if (column2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(21);
        }
        GridCellEditorFactory.ValueParser parser2 = this.getValueParser(grid, row, column2, object);
        GridCellEditorFactory.ValueFormatter formatter = this.getValueFormatter(grid, row, column2, object);
        return new GridTextCellEditor(grid, row, column2, object, initiator, this.getIsEditableChecker(), parser2, formatter);
    }

    private static int getCommonSuitability(DataConsumer.Column c2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (dbms == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(22);
        }
        switch (ExtractorsUtil.guessJdbcType(c2, value2, dbms)) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 239: 
            case 2005: 
            case 2009: 
            case 2011: {
                return 1;
            }
        }
        return 0;
    }

    private static int getPostgresSuitability(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(23);
        }
        switch (c2.type) {
            case 0: 
            case 1111: {
                if (!PG_EDITABLE.contains(c2.typeName) && !PgBaseJdbcHelper.isEditableType((String)c2.typeName, (int)c2.type)) break;
                return 1;
            }
            case 2002: 
            case 2003: {
                return 1;
            }
        }
        return 0;
    }

    private static int getCassandraSuitability(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(24);
        }
        return CASS_EDITABLE.contains(StringUtil.toLowerCase((String)c2.typeName)) ? 1 : 0;
    }

    private static int getH2Suitability(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(25);
        }
        return "enum".equals(StringUtil.toLowerCase((String)c2.typeName)) ? 1 : 0;
    }

    private static int getMongoSuitability(@Nullable Object value2) {
        return value2 instanceof Map || value2 instanceof List ? 1 : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory";
                break;
            }
            case 7: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueFormatter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSuitability";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPostgresSuitability";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCassandraSuitability";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getH2Suitability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private final ModelIndex<DataConsumer.Column> myColumnIdx;
        private final GridCellEditorFactory.ValueParser myValueParser;

        private GridTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object value2, EventObject initiator, @NotNull GridCellEditorFactory.IsEditableChecker editableChecker, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                GridTextCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                GridTextCellEditor.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                GridTextCellEditor.$$$reportNull$$$0(2);
            }
            if (editableChecker == null) {
                GridTextCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                GridTextCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                GridTextCellEditor.$$$reportNull$$$0(5);
            }
            super(grid, row, column2, value2, initiator, editableChecker, valueFormatter);
            this.myColumnIdx = column2;
            this.myValueParser = valueParser;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.isValueEditable() ? this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument()) : this.myValue;
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                GridTextCellEditor.$$$reportNull$$$0(6);
            }
            if (LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                GridTextCellEditor.$$$reportNull$$$0(7);
            }
            this.myValue = GridTextCellEditor.loadValueFromFile(file);
            if (this.myValue == null || this.myValue instanceof LobInfo.FileClobInfo) {
                this.myGrid.stopEditing();
            } else {
                GridCellEditorFactory.ValueFormatterResult result = DefaultTextEditorFactory.getValueFormatter(this.myGrid, this.myColumnIdx, this.myValue).format();
                this.myTextField.setText(result.text);
            }
        }

        @Nullable
        private static Object loadValueFromFile(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                GridTextCellEditor.$$$reportNull$$$0(8);
            }
            if (virtualFile.getLength() > (long)DatabaseSettings.getSettings().getBytesLimitPerValue()) {
                return DbImplUtil.clobFromFile(virtualFile);
            }
            try {
                return VfsUtilCore.loadText((VirtualFile)virtualFile);
            }
            catch (IOException e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataGridUtil.LOG).replace("\n", "<br>\n");
                String title = DatabaseBundle.message((String)"notification.title.cannot.read.file", (Object[])new Object[]{virtualFile.getName()});
                Notifications.Bus.notify((Notification)new Notification("Update Table", title, trace, NotificationType.ERROR));
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editableChecker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValueFromFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

