/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultNumericEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    DefaultNumericEditorFactory() {
    }

    @Override
    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Formatter format;
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(2);
        }
        if ((format = DefaultNumericEditorFactory.getFormat(grid, row, column2)) != null) {
            Formatter formatter = format;
            if (formatter == null) {
                DefaultNumericEditorFactory.$$$reportNull$$$0(3);
            }
            return formatter;
        }
        DataConsumer.Column c2 = Objects.requireNonNull(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2));
        NumberFormatter numberFormatter = grid.getObjectFormatter().getDecimalFormat(c2, DataGridUtil.getDbms(grid));
        if (numberFormatter == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(4);
        }
        return numberFormatter;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(5);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(6);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(7);
        }
        return GridCellEditorsUtil.isNumericCell(grid, row, column2) && DefaultNumericEditorFactory.getFormat(grid, row, column2) != null ? 1 : 0;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(8);
        }
        if (domain == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(9);
        }
        return DefaultNumericEditorFactory.getFormat(grid, domain) != null ? 1 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        Formatter format;
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(10);
        }
        if (domain == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(11);
        }
        format = (format = DefaultNumericEditorFactory.getFormat(grid, domain)) != null ? format : grid.getObjectFormatter().getNumberFormat();
        GridCellEditorFactory.ValueParser valueParser = DefaultNumericEditorFactory.getValueParser(format, grid, null, null, null, domain);
        if (valueParser == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(12);
        }
        return valueParser;
    }

    @Nullable
    private static Formatter getFormat(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(13);
        }
        if (domain == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(14);
        }
        ObjectFormatter formatter = grid.getObjectFormatter();
        return domain.getPoint() == ConversionPoint.NUMBER || domain.getPoint() == ConversionPoint.UNSIGNED_NUMBER ? formatter.getNumberFormat() : formatter.getDecimalFormat(domain);
    }

    @Nullable
    private static Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(15);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(16);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(17);
        }
        ObjectFormatter formatter = grid.getObjectFormatter();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Column c2 = Objects.requireNonNull(model.getColumn(column2));
        switch (ExtractorsUtil.guessJdbcType(c2, model.getValueAt(row, column2), DataGridUtil.getDbms(grid))) {
            case -6: 
            case 4: 
            case 5: {
                return formatter.getNumberFormat();
            }
            case -5: {
                return DataGridUtil.getDbms(grid).is(Dbms.BIGQUERY) ? formatter.getNumberFormat() : formatter.getBigIntFormat();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return formatter.getDecimalFormat(c2, DataGridUtil.getDbms(grid));
            }
        }
        if (ObjectFormatter.isFloatingPoint(c2) || ObjectFormatter.isBigDecimal(c2)) {
            return formatter.getDecimalFormat(c2, DataGridUtil.getDbms(grid));
        }
        return null;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(18);
        }
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(19);
        }
        if (format == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(20);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(21);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(22);
        }
        if (valueParser == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(23);
        }
        if (valueFormatter == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(24);
        }
        return new NumericEditor(project, grid, format, row, column2, nullValue, initiator, provider, valueParser, valueFormatter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 6: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 7: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatInner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFormatInner";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NumericEditor
    extends FormatBasedGridCellEditor {
        NumericEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (project == null) {
                NumericEditor.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                NumericEditor.$$$reportNull$$$0(1);
            }
            if (format == null) {
                NumericEditor.$$$reportNull$$$0(2);
            }
            if (row == null) {
                NumericEditor.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                NumericEditor.$$$reportNull$$$0(4);
            }
            if (valueParser == null) {
                NumericEditor.$$$reportNull$$$0(5);
            }
            if (valueFormatter == null) {
                NumericEditor.$$$reportNull$$$0(6);
            }
            super(project, grid, format, column2, row, nullValue, initiator, provider, valueParser, valueFormatter, false);
            this.getTextField().addSettingsProvider(editor -> DataGridUtil.configureNumericEditor(grid, (Editor)editor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "format";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueParser";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueFormatter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory$NumericEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

