/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.OptionalValueParser;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanEditorFactory
implements GridCellEditorFactory,
FactoryWithDomainSupport {
    private static final OptionalValueParser<Boolean> myParser = text2 -> StringUtil.equalsIgnoreCase((CharSequence)(text2 = StringUtil.trim((String)text2)), (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"1") ? Boolean.TRUE : (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"false") || StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"0") ? Boolean.FALSE : null);

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(2);
        }
        return GridCellEditorsUtil.isBooleanCell(grid, row, column2) ? 2 : 0;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(4);
        }
        return domain.getLogicType() == LogicalType.BOOLEAN ? 2 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(5);
        }
        if (domain == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(6);
        }
        return new ValueParserWrapper<Boolean>(myParser, true, ReservedCellValue.NULL, (Function1<? super String, ? extends UnparsedValue>)((Function1)text2 -> new UnparsedValue((String)text2, domain)));
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (dbms, value2) -> true;
        if (isEditableChecker == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(7);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(8);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(10);
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
        EnumSet<ReservedCellValue> opts = DbImplUtil.getSpecialValues(dasColumn, DataGridUtil.getDbms(grid));
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)initiator, KeyEvent.class);
        Boolean typedValue = null;
        if (keyEvent != null) {
            int code = keyEvent.getKeyCode();
            Object object2 = 84 == code ? Boolean.valueOf(true) : (70 == code ? Boolean.valueOf(false) : (78 == code && opts.contains((Object)ReservedCellValue.NULL) ? ReservedCellValue.NULL : (68 == code && opts.contains((Object)ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (67 == code && opts.contains((Object)ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (71 == code && opts.contains((Object)ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (32 == code ? Boolean.valueOf(!Boolean.TRUE.equals(object)) : (typedValue = null)))))));
        }
        return grid.getBooleanMode() == DatabaseSettings.BooleanMode.TEXT ? new TextBooleanCellEditor(grid, row, column2, object == null ? ReservedCellValue.NULL : object, opts, typedValue) : new CheckboxBooleanCellEditor(grid, row, column2, object == null ? ReservedCellValue.NULL : object, typedValue);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object initialValue) {
        DasColumn column2;
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(11);
        }
        if (rowIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(12);
        }
        if (columnIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(13);
        }
        return new ValueParserWrapper<Boolean>(myParser, (column2 = DataGridUtil.getDatabaseColumn(grid, columnIdx)) != null && !column2.isNotNull(), DataGridUtil.getDefaultNullValue(grid, columnIdx), (Function1<? super String, ? extends UnparsedValue>)((Function1)text2 -> new UnparsedValue((String)text2, ExtractorsUtil.guessDomainForEditing(grid, columnIdx, initialValue))));
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(14);
        }
        if (rowIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(15);
        }
        if (columnIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(16);
        }
        return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CheckboxBooleanCellEditor
    extends AbstractBooleanCellEditor {
        CheckboxBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Object value2, @Nullable Object typedValue) {
            if (grid == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(3);
            }
            super(grid, row, column2, value2, typedValue != null ? typedValue : (Boolean.TRUE.equals(value2) ? Boolean.FALSE : Boolean.TRUE));
        }

        @Override
        @NotNull
        protected JComponent createComponent(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Object value2) {
            if (row == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(4);
            }
            if (column2 == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(5);
            }
            if (value2 == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(6);
            }
            DefaultBooleanRendererFactory.CheckboxBooleanRenderer myRenderer = new DefaultBooleanRendererFactory.CheckboxBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this, (Disposable)myRenderer);
            Pair<Integer, Integer> viewRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2View().fun(row.asInteger(), column2.asInteger());
            ViewIndex<DataConsumer.Row> viewRow = ViewIndex.forRow(this.myGrid, (Integer)viewRowAndColumn.first);
            ViewIndex<DataConsumer.Column> viewColumn = ViewIndex.forColumn(this.myGrid, (Integer)viewRowAndColumn.second);
            JComponent component = myRenderer.getComponent(viewRow, viewColumn, value2);
            ResultViewWithCells view2 = (ResultViewWithCells)ObjectUtils.tryCast((Object)this.myGrid.getResultView(), ResultViewWithCells.class);
            if (view2 != null) {
                ResultViewWithCells.prepareComponent(component, this.myGrid, view2, viewRow, viewColumn, true);
            }
            component.setRequestFocusEnabled(true);
            JComponent jComponent = component;
            if (jComponent == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$CheckboxBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$CheckboxBooleanCellEditor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ChooseBooleanAction
    extends AnAction {
        final Object value;
        final TextBooleanCellEditor myEditor;

        private ChooseBooleanAction(@NotNull Object value2, @NotNull TextBooleanCellEditor editor) {
            if (value2 == null) {
                ChooseBooleanAction.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ChooseBooleanAction.$$$reportNull$$$0(1);
            }
            this.value = value2;
            this.myEditor = editor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseBooleanAction.$$$reportNull$$$0(2);
            }
            this.myEditor.setValue(this.value);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseBooleanAction.$$$reportNull$$$0(3);
            }
            e.getPresentation().setText(this.value == ReservedCellValue.UNSET ? DatabaseBundle.message((String)"action.Console.TableResult.ClearCell.text", (Object[])new Object[0]) : StringUtil.toLowerCase((String)this.value.toString()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ChooseBooleanActionGroup
    extends ActionGroup {
        final Object[] myValues;
        final TextBooleanCellEditor myEditor;

        ChooseBooleanActionGroup(Object @NotNull [] values2, @NotNull TextBooleanCellEditor editor) {
            if (editor == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(0);
            }
            if (values2 == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(1);
            }
            this.myValues = values2;
            this.myEditor = editor;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])JBIterable.of((Object[])this.myValues).map(value2 -> new ChooseBooleanAction(value2, this.myEditor)).toArray((Object[])new ChooseBooleanAction[0]);
            if (anActionArray == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TextBooleanCellEditor
    extends AbstractBooleanCellEditor {
        final EnumSet<ReservedCellValue> myAllowedValues;

        private TextBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Object value2, @NotNull EnumSet<ReservedCellValue> allowedValues, @Nullable Object typedValue) {
            if (grid == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(3);
            }
            if (allowedValues == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(4);
            }
            super(grid, row, column2, value2, typedValue);
            this.myAllowedValues = allowedValues;
            if (typedValue == null) {
                final Ref popupShown = new Ref((Object)false);
                this.myComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (!((Boolean)popupShown.get()).booleanValue()) {
                            popupShown.set((Object)true);
                            this.showPopup();
                        } else {
                            this.editingEnded();
                        }
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        private void showPopup() {
            Object[] options = ArrayUtil.mergeArrays((Object[])new Object[]{Boolean.TRUE, Boolean.FALSE}, (Object[])ArrayUtil.toObjectArray(this.myAllowedValues));
            JPopupMenu popup2 = ActionManager.getInstance().createActionPopupMenu("EditorPopup", (ActionGroup)new ChooseBooleanActionGroup(options, this)).getComponent();
            popup2.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    myGrid.getResultView().getComponent().requestFocus();
                }
            });
            JBPopupMenu.showBelow((Component)this.myComponent, (JPopupMenu)popup2);
        }

        @Override
        @NotNull
        protected JComponent createComponent(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Object value2) {
            if (row == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(5);
            }
            if (column2 == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(6);
            }
            if (value2 == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(7);
            }
            DefaultTextRendererFactory.TextRenderer myRenderer = value2 instanceof UnparsedValue ? new DefaultTextRendererFactory.TextRenderer(this.myGrid) : new DefaultBooleanRendererFactory.TextBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this, (Disposable)myRenderer);
            Pair<Integer, Integer> viewRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2View().fun(row.asInteger(), column2.asInteger());
            ViewIndex<DataConsumer.Row> viewRow = ViewIndex.forRow(this.myGrid, (Integer)viewRowAndColumn.first);
            ViewIndex<DataConsumer.Column> viewColumn = ViewIndex.forColumn(this.myGrid, (Integer)viewRowAndColumn.second);
            JComponent component = ((GridCellRenderer)myRenderer).getComponent(viewRow, viewColumn, value2);
            ResultViewWithCells view2 = (ResultViewWithCells)ObjectUtils.tryCast((Object)this.myGrid.getResultView(), ResultViewWithCells.class);
            if (view2 != null) {
                ResultViewWithCells.prepareComponent(component, this.myGrid, view2, viewRow, viewColumn, true);
            }
            component.setRequestFocusEnabled(true);
            JComponent jComponent = component;
            if (jComponent == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allowedValues";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$TextBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$TextBooleanCellEditor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AbstractBooleanCellEditor
    extends GridCellEditor.Adapter {
        final DataGrid myGrid;
        final Object myInitialValue;
        private final boolean shouldMoveFocus;
        final JComponent myComponent;
        Object myValue;

        AbstractBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Object value2, final @Nullable Object typedValue) {
            if (grid == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value2 == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(3);
            }
            this.myGrid = grid;
            this.myInitialValue = value2;
            this.shouldMoveFocus = typedValue == null;
            this.myComponent = this.createComponent(row, column2, value2);
            if (typedValue != null) {
                this.myComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        this.setValue(typedValue);
                        this.editingEnded();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myInitialValue.toString();
            if (string == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(4);
            }
            return string;
        }

        abstract JComponent createComponent(@NotNull ModelIndex<DataConsumer.Row> var1, @NotNull ModelIndex<DataConsumer.Column> var2, @NotNull Object var3);

        void setValue(@NotNull Object value2) {
            if (value2 == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(5);
            }
            this.myValue = value2;
            this.fireEditing(value2);
            this.myGrid.getResultView().getComponent().requestFocus();
        }

        void editingEnded() {
            if (this.myValue == null) {
                this.myGrid.cancelEditing();
            } else if (!this.myGrid.stopEditing()) {
                this.myGrid.cancelEditing();
            }
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.myValue != null ? this.myValue : this.myInitialValue;
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return false;
        }

        @Override
        public boolean shouldMoveFocus() {
            return this.shouldMoveFocus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$AbstractBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$AbstractBooleanCellEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

