/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.run.ui.grid.GridPanelWithEditor;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSortingPanel
extends GridPanelWithEditor {
    private final GridSortingModel<DataConsumer.Row, DataConsumer.Column> mySortingModel;
    private JBPopup myFilterHistoryPopup;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    GridSortingPanel(@NotNull Project project, @NotNull DataGrid grid, @NotNull GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel, @NotNull Document document) {
        if (project == null) {
            GridSortingPanel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridSortingPanel.$$$reportNull$$$0(1);
        }
        if (sortingModel == null) {
            GridSortingPanel.$$$reportNull$$$0(2);
        }
        if (document == null) {
            GridSortingPanel.$$$reportNull$$$0(3);
        }
        super(project, grid, DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).getOrderByPrefix() + " ", DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).getEmptySortingText(), document);
        this.mySortingModel = sortingModel;
        sortingModel.addListener(new GridSortingModel.Listener(){

            @Override
            public void onPsiUpdated() {
                GridSortingPanel.this.setHighlighter();
            }
        }, this.myGrid);
        @NotNull @Nullable Function getPanel = g -> g.getFilterComponent().getSortingPanel();
        new GridPanelWithEditor.ApplyAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getComponent());
        new GridPanelWithEditor.CancelAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.myEditor.getComponent());
        new GridPanelWithEditor.ShowHistoryAction((Function<DataGrid, GridPanelWithEditor>)getPanel).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 512)), this.myEditor.getComponent());
        JBLabel filterHistoryLabel = new JBLabel(DatabaseIcons.SortHistory);
        filterHistoryLabel.setOpaque(false);
        filterHistoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GridSortingPanel.this.showHistoryPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridSortingPanel$2", "mousePressed"));
            }
        });
        this.add((Component)filterHistoryLabel, "West");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, -1);
    }

    @Override
    void clearText() {
        boolean wasApplied = this.mySortingModel != null && !this.mySortingModel.getAppliedOrderingText().isEmpty();
        ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().setText((CharSequence)""));
        if (wasApplied) {
            this.apply();
        }
    }

    @Override
    @NotNull
    @NlsContexts.PopupContent
    String getInvalidTextErrorMessage() {
        String string = DatabaseBundle.message((String)"popup.content.invalid.table.sorting", (Object[])new Object[0]);
        if (string == null) {
            GridSortingPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    void showHistoryPopup() {
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        this.myFilterHistoryPopup = GridSortingPanel.createHistoryPopup(this.mySortingModel.getHistory(), this.myProject, (Editor)this.myEditor, () -> this.myGrid.getFilterComponent().getFilterPanel().apply());
        this.myFilterHistoryPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                GridSortingPanel.this.myFilterHistoryPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridSortingPanel$3", "onClosed"));
            }
        });
        if (this.myGrid.getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridSortingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridSortingPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidTextErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

