/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridSortingPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterComponent
extends EditorHeaderComponent {
    private final GridFilterPanel myFilterPanel;
    private final GridSortingPanel mySortingPanel;
    private final OnePixelSplitter mySplitter;
    private final DataGrid myGrid;

    public GridFilterComponent(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            GridFilterComponent.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridFilterComponent.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.setBorder((Border)JBUI.Borders.empty());
        this.mySplitter = new OnePixelSplitter(1.0E-4f);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFocusTraversalPolicyProvider(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy(this));
        this.add((Component)this.mySplitter, "Center");
        this.myFilterPanel = new GridFilterPanel(project, this.myGrid);
        this.myFilterPanel.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridFilterComponent.this.myFilterPanel.myEditor.getScrollPane().doLayout();
                GridFilterComponent.this.mySplitter.revalidate();
                GridFilterComponent.this.mySplitter.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridFilterComponent$1", "documentChanged"));
            }
        }, (Disposable)this.myGrid);
        this.mySplitter.setFirstComponent((JComponent)this.myFilterPanel);
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myGrid.getDataHookup().getSortingModel();
        Document document = sortingModel == null ? null : sortingModel.getDocument();
        CompoundBorder border = new CompoundBorder((Border)new CustomLineBorder(JBColor.border(), 0, 0, 1, 0), (Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
        this.myFilterPanel.setBorder(border);
        GridSortingPanel gridSortingPanel = this.mySortingPanel = document == null ? null : new GridSortingPanel(project, this.myGrid, sortingModel, document);
        if (this.mySortingPanel != null) {
            this.mySortingPanel.setBorder(border);
            this.mySplitter.setSecondComponent((JComponent)this.mySortingPanel);
        }
    }

    @NotNull
    public GridFilterPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            GridFilterComponent.$$$reportNull$$$0(2);
        }
        return gridFilterPanel;
    }

    @Nullable
    public GridSortingPanel getSortingPanel() {
        return this.mySortingPanel;
    }

    public void toggleSortingPanel(boolean visible) {
        if (this.mySortingPanel == null) {
            return;
        }
        if (visible) {
            this.mySplitter.setSecondComponent((JComponent)this.mySortingPanel);
        } else {
            this.mySplitter.setSecondComponent(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final GridFilterComponent myComponent;

        MyFocusTraversalPolicy(GridFilterComponent component) {
            this.myComponent = component;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return component == this.myComponent.myFilterPanel.myEditor.getContentComponent() ? this.myComponent.mySortingPanel.myEditor.getContentComponent() : this.myComponent.myGrid.getPreferredFocusedComponent();
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return component == this.myComponent.mySortingPanel.myEditor.getContentComponent() ? this.myComponent.myFilterPanel.myEditor.getContentComponent() : null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.myComponent.myFilterPanel.myEditor.getContentComponent();
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.myComponent.mySortingPanel.myEditor.getContentComponent();
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.myComponent.myFilterPanel.myEditor.getContentComponent();
        }
    }
}

