/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.editor.DatabaseStartupActivity;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.GridTableCellEditor;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.MutationSupport;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ResultViewFactory;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridFilterComponent;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridPasteProvider;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.grid.GridSortingPanel;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.json.json5.Json5Language;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
GridModel.Listener<DataConsumer.Row, DataConsumer.Column>,
MutationSupport {
    private static final String XML_LANGUAGE_ID = "XML";
    private static final int RESULT_VIEW_COMPONENT_Z_INDEX = 1;
    private static final int LOAD_DATA_Z_INDEX = 2;
    private final Alarm alarm;
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final JLayeredPane myLayeredPane;
    private ResultView myResultView;
    private final ActionGroup myPopupActionGroup;
    protected final ActionGroup myGutterPopupActions;
    private final ActionGroup myColumnHeaderActions;
    private final ActionGroup myRowHeaderActions;
    private final GridCellEditorFactoryProvider myCellEditorFactoryProvider;
    private final GridColorsScheme myColorsScheme;
    private final ColumnAttributes myColumnAttributes;
    private final Project myProject;
    private final ObjectFormatter myConverter;
    protected final GridFilterComponent myFilterComponent;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    private final GridMarkupModel<DataConsumer.Row, DataConsumer.Column> myMarkupModel;
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myDataHookUp;
    private final MyLoadDataPanel myLoadDataPanel;
    private JComponent myMainResultViewComponent;
    private final HiddenColumnsSelectionHolder myHiddenColumnSelectionHolder;
    private final JBAutoscroller.AutoscrollLocker myAutoscrollLocker;
    private final DatabaseSettings.BooleanMode myBooleanMode;
    private GridColorModel myColorModel;
    private SearchSession mySearchSession;
    private GridPresentationMode myPresentationMode;
    private ResultViewFactory myViewFactory;
    private DataExtractorFactory.Text myExtractorFactory;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(2);
        }
        this(project, dataHookUp, popupActions, popupActions, DataGridUtil.getGridColumnHeaderPopupActions(), ActionGroup.EMPTY_GROUP, null, false);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderActions, @NotNull ActionGroup rowHeaderActions, @Nullable GridCellEditorFactoryProvider cellEditorFactoryProvider, boolean useConsoleFonts) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(3);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(4);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(5);
        }
        if (gutterPopupActions == null) {
            TableResultPanel.$$$reportNull$$$0(6);
        }
        if (columnHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(7);
        }
        if (rowHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(8);
        }
        this.alarm = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myConverter = new ObjectFormatter();
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myPresentationMode = GridPresentationMode.TABLE;
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myGutterPopupActions = gutterPopupActions;
        this.myColumnHeaderActions = columnHeaderActions;
        this.myRowHeaderActions = rowHeaderActions;
        this.myCellEditorFactoryProvider = cellEditorFactoryProvider;
        this.myColorsScheme = useConsoleFonts ? new GridColorsScheme.ForConsole() : new GridColorsScheme();
        this.myMarkupModel = new GridMarkupModelImpl<DataConsumer.Row, DataConsumer.Column>();
        this.myHiddenColumnSelectionHolder = new HiddenColumnsSelectionHolder();
        this.myAutoscrollLocker = new JBAutoscroller.AutoscrollLocker();
        this.myDataHookUp = dataHookUp;
        this.myFilterComponent = new GridFilterComponent(this.myProject, this);
        this.myMainPanel = new GridMainPanel(this);
        this.myBooleanMode = DatabaseSettings.getSettings().getBooleanMode();
        DataManager.registerDataProvider((JComponent)((Object)this.myMainPanel), this::getData);
        this.myMainPanel.setLoadingText("");
        this.myLoadDataPanel = new MyLoadDataPanel(this);
        this.myLayeredPane = new JBLayeredPane(){

            public void doLayout() {
                TableResultPanel.this.myLoadDataPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
                if (TableResultPanel.this.myMainResultViewComponent != null) {
                    TableResultPanel.this.myMainResultViewComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.myMainPanel.setCenterComponent(this.myLayeredPane);
        this.getLoadingPanel().addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){

            public void onLoadingStart() {
                DatabaseStartupActivity.DataEditorConfigurator.disableLoadingDelay(TableResultPanel.this);
            }
        });
        this.myColumnAttributes = new ColumnAttributes();
        this.myExtractorFactory = this.getCurrentExtractorFactory();
        this.myViewFactory = ResultViewFactory.of(this.myPresentationMode);
        this.createResultView();
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    TableResultPanel.this.setOrderingFromModel();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, this);
        }
        this.installDataHookUpListeners();
        this.columnsAdded(this.getDataModel().getColumnIndices());
        MessageBusConnection connection2 = project.getMessageBus().connect((Disposable)this);
        connection2.subscribe(DatabaseSettings.TOPIC, () -> {
            DataExtractorFactory.Text updated = (DataExtractorFactory.Text)ObjectUtils.tryCast((Object)DataExtractorFactories.findById(this.myExtractorFactory.getId()), DataExtractorFactory.Text.class);
            if (updated != null) {
                this.setExtractorFactory(updated);
            }
        });
    }

    @Override
    @NotNull
    public DatabaseSettings.BooleanMode getBooleanMode() {
        DatabaseSettings.BooleanMode booleanMode = this.myBooleanMode;
        if (booleanMode == null) {
            TableResultPanel.$$$reportNull$$$0(9);
        }
        return booleanMode;
    }

    @NotNull
    private DataExtractorFactory.Text getCurrentExtractorFactory() {
        DataExtractorFactory extractorFactory = DataGridUtil.getDbms(this).isDocumentOriented() ? DataExtractorFactories.findById("JSON-Groovy.json.groovy") : DataExtractorProperties.getCurrentExtractorFactory(this.myProject);
        DataExtractorFactory.Text text2 = extractorFactory instanceof DataExtractorFactory.Text ? (DataExtractorFactory.Text)extractorFactory : DataExtractorFactories.getDefault();
        if (text2 == null) {
            TableResultPanel.$$$reportNull$$$0(10);
        }
        return text2;
    }

    @Override
    public void loadingDelayDisabled() {
        this.myLayeredPane.remove(this.myLoadDataPanel);
    }

    @Override
    public void loadingDelayed() {
        this.myLayeredPane.add(this.myLoadDataPanel);
        this.myLayeredPane.setLayer(this.myLoadDataPanel, 2);
    }

    private void createResultView() {
        this.myResultView = this.myViewFactory.createResultView(this);
        this.myColorModel = new GridColorModelImpl(this, (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.getMutator(), DatabaseMutatorImpl.class));
        this.myMainResultViewComponent = this.myViewFactory.wrap(this, this.myResultView);
        this.myLayeredPane.add(this.myMainResultViewComponent);
        this.myLayeredPane.setLayer(this.myMainResultViewComponent, 1);
        this.registerEscapeAction(this.myResultView);
        this.myResultView.addSelectionChangedListener(() -> {
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onSelectionChanged(this);
            DataGridUtil.updateWidgets(this);
        });
        this.myResultView.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        this.myResultView.getComponent().putClientProperty("AuxEditorComponent", Boolean.TRUE);
    }

    public ActionGroup getColumnHeaderActions() {
        return this.myColumnHeaderActions;
    }

    @NotNull
    public ActionGroup getRowHeaderActions() {
        ActionGroup actionGroup = this.myRowHeaderActions;
        if (actionGroup == null) {
            TableResultPanel.$$$reportNull$$$0(11);
        }
        return actionGroup;
    }

    @Nullable
    public GridCellEditorFactoryProvider getCellEditorFactoryProvider() {
        return this.myCellEditorFactoryProvider;
    }

    @NotNull
    public GridColorModel getColorModel() {
        GridColorModel gridColorModel = this.myColorModel;
        if (gridColorModel == null) {
            TableResultPanel.$$$reportNull$$$0(12);
        }
        return gridColorModel;
    }

    public JBAutoscroller.AutoscrollLocker getAutoscrollLocker() {
        return this.myAutoscrollLocker;
    }

    public HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder() {
        return this.myHiddenColumnSelectionHolder;
    }

    public ColumnAttributes getColumnAttributes() {
        return this.myColumnAttributes;
    }

    @NotNull
    public GridRowHeader createRowHeader(@NotNull TableResultView table) {
        if (table == null) {
            TableResultPanel.$$$reportNull$$$0(13);
        }
        return new TableResultRowHeader(this, table, this.myGutterPopupActions);
    }

    public void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable Throwable th) {
                if (source == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (message2 != null) {
                    Throwable throwable = new Throwable(message2);
                    throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
                    th = throwable;
                }
                if (th != null) {
                    TableResultPanel.this.handleError(source, fixes, th);
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).setErrorReported();
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
                if (source == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).addUpdateCount(updateCount2);
                }
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                boolean isNull;
                if (source == null) {
                    5.$$$reportNull$$$0(2);
                }
                this.doRepaint(source);
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
                boolean bl = isNull = requestSource == null;
                if (isNull || !requestSource.isErrorReported()) {
                    TableResultPanel.this.hideErrorPanel();
                    if (isNull) {
                        return;
                    }
                }
                if (!requestSource.isForceSuccess()) {
                    this.countRows(requestSource, success);
                }
                requestSource.requestComplete(success);
            }

            private void countRows(@NotNull DataGridRequestSource requestSource, boolean success) {
                if (requestSource == null) {
                    5.$$$reportNull$$$0(3);
                }
                if (success && !requestSource.isErrorReported() && DataGridUtil.getDataBusHookUp(TableResultPanel.this) != null) {
                    int actualUpdateCount = requestSource.getUpdateCount();
                    if (actualUpdateCount == -2) {
                        return;
                    }
                    int expectedUpdateCount = requestSource.getRows().size();
                    if (expectedUpdateCount != actualUpdateCount) {
                        Exception e = new Exception(actualUpdateCount + " rows updated.");
                        e.setStackTrace(new StackTraceElement[0]);
                        TableResultPanel.this.showError(e, null, requestSource);
                    }
                }
            }

            private void doRepaint(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
                Component rowHeader;
                if (source == null) {
                    5.$$$reportNull$$$0(4);
                }
                if (!(source.source instanceof DataGridRequestSource)) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)source.source);
                if (!requestSource.isForceSuccess()) {
                    return;
                }
                TableResultPanel.this.myResultView.getComponent().repaint(50L);
                JViewport header = TableResultPanel.this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)TableResultPanel.this.myMainResultViewComponent).getRowHeader() : null;
                Component component = rowHeader = header == null ? null : header.getView();
                if (rowHeader != null) {
                    rowHeader.repaint(50L);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "requestSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "countRows";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRepaint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        this.getDataModel().addListener(this, this);
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        this.myColumnAttributes.newColumns(this, this.getDataModel().getColumns());
        this.setOrderingFromModel();
        this.updateSortKeysFromColumnAttributes();
        this.myResultView.columnsAdded(columnIndices);
        this.trueLayout();
        this.restoreColumnsOrder();
    }

    protected void columnAttributesUpdated() {
        this.myResultView.columnAttributesUpdated();
        this.restoreColumnsOrder();
    }

    public void restoreColumnsOrder() {
        LinkedHashMap<Integer, ModelIndex<DataConsumer.Column>> expectedToModel = new LinkedHashMap<Integer, ModelIndex<DataConsumer.Column>>();
        JBIterable modelIndices = this.getDataModel().getColumnIndices().asIterable();
        for (ModelIndex modelIndex : modelIndices) {
            DataConsumer.Column column2 = this.getDataModel().getColumn(modelIndex);
            if (column2 == null) {
                return;
            }
            int initialPosition = this.getInitialPosition(column2);
            if (initialPosition == 0) {
                return;
            }
            initialPosition = initialPosition == -1 ? modelIndex.value : DatabaseTableFileEditor.fromSerializedPosition(initialPosition);
            expectedToModel.put(initialPosition, modelIndex);
        }
        this.myResultView.restoreColumnsOrder(expectedToModel);
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
        this.myResultView.columnsRemoved(columns);
        this.trueLayout();
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.myResultView.rowsAdded(rows);
        this.trueLayout();
    }

    @Override
    public void afterLastRowAdded() {
        this.myResultView.afterLastRowAdded();
    }

    @Override
    public void fireValueEdited(@Nullable Object object) {
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onValueEdited(this, object);
    }

    @Override
    public void changeCellType(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @NotNull Domain newType) {
        GridCellEditorFactoryProvider editorProvider;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(14);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(15);
        }
        if (newType == null) {
            TableResultPanel.$$$reportNull$$$0(16);
        }
        if ((editorProvider = this.myResultView.getEditorFactoryProvider()) == null) {
            return;
        }
        FactoryWithDomainSupport newFactory = (FactoryWithDomainSupport)ObjectUtils.tryCast((Object)editorProvider.getEditorFactory(this, newType), FactoryWithDomainSupport.class);
        if (newFactory == null) {
            return;
        }
        ResultViewWithCells viewWithCells = (ResultViewWithCells)ObjectUtils.tryCast((Object)this.getResultView(), ResultViewWithCells.class);
        GridTableCellEditor editor = viewWithCells == null ? null : (GridTableCellEditor)((Object)ObjectUtils.tryCast((Object)viewWithCells.getCellEditor(), GridTableCellEditor.class));
        ModelIndex<DataConsumer.Row> editedRow = this.getSelectionModel().getLeadSelectionRow();
        ModelIndex<DataConsumer.Column> editedColumn = this.getSelectionModel().getLeadSelectionColumn();
        if (editor != null && rows.asIterable().find(row -> editedRow.equals(row)) != null && columns.asIterable().find(column2 -> editedColumn.equals(column2)) != null) {
            String text2 = StringUtil.notNullize((String)editor.getCellEditorText());
            this.cancelEditing();
            Object parsed = newFactory.getValueParser(this, newType).parse(text2, null);
            this.fireValueEdited(parsed);
            this.myResultView.setValueAt(parsed, editedRow, editedColumn, false, SetValueRequestor.INSTANCE);
        } else {
            for (ModelIndex row2 : rows.asIterable()) {
                for (ModelIndex column3 : columns.asIterable()) {
                    this.changeCellType(row2, column3, newType, newFactory);
                }
            }
        }
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onCellTypeChanged(rows, columns, newType);
    }

    private void changeCellType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull Domain newType, @NotNull FactoryWithDomainSupport newFactory) {
        GridCellEditorFactoryProvider provider;
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(17);
        }
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(18);
        }
        if (newType == null) {
            TableResultPanel.$$$reportNull$$$0(19);
        }
        if (newFactory == null) {
            TableResultPanel.$$$reportNull$$$0(20);
        }
        if ((provider = this.myResultView.getEditorFactoryProvider()) == null) {
            return;
        }
        GridCellEditorFactory factory = provider.getEditorFactory(this, row, column2);
        if (factory == null) {
            return;
        }
        GridCellEditorFactory.ValueFormatter formatter = factory.getValueFormatter(this, row, column2, this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2));
        String text2 = formatter.format().text;
        Object parsed = newFactory.getValueParser(this, newType).parse(text2, null);
        this.myResultView.setValueAt(parsed, row, column2, false, null);
    }

    @Override
    @NotNull
    public ResultView getResultView() {
        ResultView resultView = this.myResultView;
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(21);
        }
        return resultView;
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.myResultView.rowsRemoved(rows);
        this.trueLayout();
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns, @Nullable Object requestor) {
        if (requestor instanceof SetValueRequestor) {
            ApplicationManager.getApplication().invokeLater(() -> this.editSelectedCell());
        }
        this.myResultView.cellsUpdated(rows, columns, requestor);
    }

    private void registerEscapeAction(@NotNull ResultView resultView) {
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(22);
        }
        resultView.registerEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
    }

    public void setOrdering(List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> o : ordering) {
            ModelIndex<DataConsumer.Column> columnIdx = o.getColumn();
            DataConsumer.Column column2 = this.getDataModel().getColumn(columnIdx);
            this.myColumnAttributes.changeSortOrder(column2, o.getOrder());
        }
        this.updateSortKeysFromColumnAttributes();
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(23);
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder(this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            TableResultPanel.$$$reportNull$$$0(24);
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(25);
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder(this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.getResultView().isTransposed() || this.isSortViaOrderBy();
    }

    public int getSortOrder(@Nullable DataConsumer.Column column2) {
        return column2 != null ? this.myColumnAttributes.getSortOrder(column2) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener2, Disposable disposable2) {
        this.myEventDispatcher.addListener((EventListener)listener2, disposable2);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myColorsScheme;
        if (gridColorsScheme == null) {
            TableResultPanel.$$$reportNull$$$0(26);
        }
        return gridColorsScheme;
    }

    @Override
    public void searchSessionStarted(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(27);
        }
        assert (this.mySearchSession == null);
        this.mySearchSession = searchSession;
        this.myResultView.searchSessionStarted(searchSession);
        this.getResultView().searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(28);
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.getResultView().searchSessionUpdated();
    }

    @Override
    @Nullable
    public SearchSession getSearchSession() {
        return this.mySearchSession;
    }

    public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myConverter;
    }

    @Override
    public boolean isEditable() {
        return !this.myDataHookUp.isReadOnly() && GridEditGuard.get(this) == null && !DataGridUtil.getDbms(this).is(Dbms.COUCHBASE_QUERY);
    }

    @Override
    public boolean isCellEditingAllowed() {
        return this.myResultView instanceof ResultViewWithCells && ((ResultViewWithCells)((Object)this.myResultView)).isCellEditingAllowed();
    }

    @Override
    public void setCells(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value2) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(29);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(30);
        }
        if ((mutator = this.myDataHookUp.getMutator()) != null && this.isSafeToUpdate(rows, columns, value2)) {
            DataGridRequestSource source = new DataGridRequestSource(rows, columns);
            mutator.mutate(GridRequestSource.create(this, (Object)source), rows, columns, value2, true);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void insertRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> mutator.insertRow(this.newInsertOrCloneRowRequestSource()));
            return;
        }
        mutator.insertRow(this.newInsertOrCloneRowRequestSource());
    }

    @Override
    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rowToClone == null) {
            TableResultPanel.$$$reportNull$$$0(31);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone));
            return;
        }
        mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
    }

    private GridRequestSource<DataConsumer.Row, DataConsumer.Column> newInsertOrCloneRowRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            if (this.myResultView.isEditing()) {
                return;
            }
            GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
            ModelIndex<DataConsumer.Row> row = mutator != null ? mutator.getLastInsertedRow() : ModelIndex.forRow(this, -1);
            row = row != null && row.isValid(this) ? row : ModelIndex.forRow(this, this.getDataModel().getRowCount() - 1);
            this.scrollToLocally(row.toView(this));
        });
        return GridRequestSource.create(this, (Object)source);
    }

    @Override
    public void insertColumn() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.submit().doWhenDone(() -> mutator.insertColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource())));
    }

    @Override
    public void cloneColumn(@NotNull ModelIndex<DataConsumer.Column> columnToClone) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columnToClone == null) {
            TableResultPanel.$$$reportNull$$$0(32);
        }
        if ((mutator = this.getColumnsMutator()) == null) {
            return;
        }
        this.submit().doWhenDone(() -> mutator.cloneColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource()), columnToClone));
    }

    private DataGridRequestSource newInsertOrCloneColumnRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            ModelIndex<DataConsumer.Column> column2 = ModelIndex.forColumn(this, this.getDataModel().getColumnCount() - 1);
            this.scrollToLocally(ViewIndex.forRow(this, 0), column2.toView(this));
        });
        return source;
    }

    @Override
    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        boolean canDelete;
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(33);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        boolean areRowsInserted = true;
        for (ModelIndex index2 : rows.asIterable()) {
            areRowsInserted &= mutator.isInsertedRow(index2);
        }
        boolean bl = canDelete = !mutator.hasPendingChanges() || !mutator.isUpdateImmediately() || areRowsInserted || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
        if (!canDelete) {
            return;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        DataGridRequestSource source = new DataGridRequestSource(rows, ModelIndexSet.forColumns(this, new int[0]));
        mutator.deleteRows(GridRequestSource.create(this, (Object)source), rows);
        source.doWhenDone(() -> this.myAutoscrollLocker.runWithLock(() -> this.getSelectionModel().restore(this.getSelectionModel().fit(selection))));
    }

    @Override
    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(34);
        }
        if ((mutator = this.getColumnsMutator()) != null) {
            DataGridRequestSource source = new DataGridRequestSource(ModelIndexSet.forRows(this, new int[0]), columns);
            mutator.deleteColumns(GridRequestSource.create(this, (Object)source), columns);
        }
    }

    @Override
    public boolean isColumnsMutationSupported() {
        return this.getColumnsMutator() != null;
    }

    @Override
    @NotNull
    public ActionCallback submit() {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        if (mutator == null || !mutator.hasPendingChanges()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TableResultPanel.$$$reportNull$$$0(35);
            }
            return actionCallback;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        DataGridRequestSource source = new DataGridRequestSource(mutator.getAffectedRows(), ModelIndexSet.forColumns(this, -1));
        mutator.submit(GridRequestSource.create(this, (Object)source), true);
        ActionCallback actionCallback = source.doWhenDone(() -> this.getSelectionModel().restore(this.getSelectionModel().fit(selection)));
        if (actionCallback == null) {
            TableResultPanel.$$$reportNull$$$0(36);
        }
        return actionCallback;
    }

    @NotNull
    public GridMutationModel getMutationModel() {
        return new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myResultView);
    }

    @Override
    @NotNull
    public GridDataSupport getDataSupport() {
        return new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myResultView);
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.ColumnsMutator.class);
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(37);
        }
        return (mutator = this.getRowsMutator()) != null && mutator.isInsertedRow(row);
    }

    @Override
    @NotNull
    public SelectionModel<DataConsumer.Row, DataConsumer.Column> getSelectionModel() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = SelectionModel.get(this, this.myResultView);
        if (selectionModel == null) {
            TableResultPanel.$$$reportNull$$$0(38);
        }
        return selectionModel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(this.getDataHookup(), DataRequest.OwnerEx.class);
        return ownerEx != null ? StringUtil.notNullize((String)ownerEx.getDisplayName()) : "";
    }

    @Override
    @NotNull
    public GridMarkupModel<DataConsumer.Row, DataConsumer.Column> getMarkupModel() {
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            TableResultPanel.$$$reportNull$$$0(39);
        }
        return gridMarkupModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel(@NotNull DataAccessType reason) {
        if (reason == null) {
            TableResultPanel.$$$reportNull$$$0(40);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = reason.getModel(this);
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(41);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel() {
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.myDataHookUp.getModel();
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(42);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getDataHookup() {
        GridDataHookUp<DataConsumer.Row, DataConsumer.Column> gridDataHookUp = this.myDataHookUp;
        if (gridDataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(43);
        }
        return gridDataHookUp;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        RawIndexConverter rawIndexConverter = this.myResultView.getRawIndexConverter();
        if (rawIndexConverter == null) {
            TableResultPanel.$$$reportNull$$$0(44);
        }
        return rawIndexConverter;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myResultView.getPreferredFocusedComponent();
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(45);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getMainResultViewComponent() {
        JComponent jComponent = this.myMainResultViewComponent;
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(46);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(47);
        }
        return gridMainPanel;
    }

    @Override
    @NotNull
    public GridMainPanel getComponent() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(48);
        }
        return gridMainPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component component) {
        this.myMainPanel.setTopComponent(component);
    }

    @Override
    public void setSecondTopComponent(@Nullable Component component) {
        this.myMainPanel.setSecondTopComponent(component);
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return this.myMainPanel.getTopComponent();
    }

    @Override
    @Nullable
    public Component getSecondTopComponent() {
        return this.myMainPanel.getSecondTopComponent();
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myResultView.getVisibleColumns();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(49);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myResultView.getVisibleRows();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(50);
        }
        return modelIndexSet;
    }

    @Override
    public int getVisibleRowsCount() {
        return this.myResultView.getViewRowCount();
    }

    @Override
    public boolean isEditing() {
        return this.myResultView.isEditing();
    }

    @Override
    public boolean stopEditing() {
        return this.myResultView.stopEditing();
    }

    @Override
    public void cancelEditing() {
        this.myResultView.cancelEditing();
    }

    @Override
    public void editSelectedCell() {
        if (this.myResultView instanceof ResultViewWithCells) {
            ((ResultViewWithCells)((Object)this.myResultView)).editSelectedCell();
        }
    }

    @Override
    public boolean isViewModified() {
        for (DataConsumer.Column column2 : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = column2 == null || !DbImplUtil.isRowId(column2);
            boolean shown = this.isColumnEnabled(column2);
            boolean bl = sortOrderChanged = this.getSortOrder(column2) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        return this.myResultView.isViewModified();
    }

    public int getVisibleColumnCount() {
        return this.myResultView.getViewColumnCount();
    }

    private void showError(@NotNull Throwable error2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable DataGridRequestSource source) {
        if (error2 == null) {
            TableResultPanel.$$$reportNull$$$0(51);
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error2, (JComponent)((Object)this.myMainPanel));
        if (fixes != null && !fixes.isEmpty()) {
            for (DatabaseErrorHandler.Fix fix : fixes) {
                builder.addLink(fix.getName(), fix.getName(), () -> DataSourceUiUtil.applyFix(this.myProject, fix, null));
            }
            builder.addSpace();
        } else {
            builder.addDetailsButton();
        }
        if (source != null && source.getRows().size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.getRows().first();
            ModelIndex modelColumnIdx = (ModelIndex)source.getColumns().first();
            ViewIndex viewRowIdx = modelRowIdx.toView(this);
            ViewIndex viewColumnIdx = modelColumnIdx.toView(this);
            int r = viewRowIdx.asInteger() + 1;
            int c2 = viewColumnIdx.asInteger() + 1;
            String title = DatabaseBundle.message((String)"action.row.choice.col.text", (Object[])new Object[]{r, c2, c2 < 1 ? 0 : 1});
            builder.addLink("navigate", title, () -> {
                if (viewRowIdx.isValid(this) && viewColumnIdx.isValid(this)) {
                    this.scrollToLocally(viewRowIdx, viewColumnIdx);
                }
            });
        }
        this.myErrorNotificationPanel = builder.addCloseButton(this::hideErrorPanel).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource, @Nullable List<DatabaseErrorHandler.Fix> fixes, @NotNull Throwable error2) {
        if (requestSource == null) {
            TableResultPanel.$$$reportNull$$$0(52);
        }
        if (error2 == null) {
            TableResultPanel.$$$reportNull$$$0(53);
        }
        Object source = requestSource.source;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (source == this.myFilterComponent.getFilterPanel()) {
                this.myFilterComponent.getFilterPanel().onError(error2);
                return;
            }
            GridSortingPanel sortingPanel = this.myFilterComponent.getSortingPanel();
            if (sortingPanel != null && source == sortingPanel) {
                sortingPanel.onError(error2);
                return;
            }
            this.showError(error2, fixes, (DataGridRequestSource)((Object)((Object)ObjectUtils.tryCast((Object)source, DataGridRequestSource.class))));
        });
    }

    @Nullable
    protected Object getData(@NonNls @NotNull String dataId) {
        if (dataId == null) {
            TableResultPanel.$$$reportNull$$$0(54);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new GridCopyProvider(this);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DeleteRowsAction();
        }
        if (DatabaseDataKeys.DATA_GRID_KEY.is(dataId)) {
            return this;
        }
        if (Session.SESSION_KEY.is(dataId) && this.myDataHookUp instanceof SessionClient) {
            return ((SessionClient)((Object)this.myDataHookUp)).getSession();
        }
        if (SessionClientHolder.CLIENT_KEY.is(dataId) && this.myDataHookUp instanceof SessionClient) {
            return this.myDataHookUp;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DataGridUtil.getPsiElementForSelection(this);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return ContainerUtil.ar((Object[])new PsiElement[]{DataGridUtil.getPsiElementForSelection(this)});
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new GridPasteProvider(this);
        }
        return null;
    }

    public void toggleSortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, boolean additive) {
        boolean forceAscOrder;
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(55);
        }
        if (columns.isEmpty()) {
            return;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.getDataModel(DataAccessType.DATABASE_DATA);
        int oldOrder = this.myColumnAttributes.getSortOrder(model.getColumn(columns.get(0)));
        boolean bl = forceAscOrder = !additive && !DataGridUtil.areOnlySortedColumns(columns, this);
        RowSortOrder.Type order = forceAscOrder || oldOrder == 0 ? RowSortOrder.Type.ASC : (oldOrder < 0 ? RowSortOrder.Type.DESC : RowSortOrder.Type.UNSORTED);
        this.sortColumns(columns, order, additive);
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull RowSortOrder.Type order, boolean additive) {
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(56);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(57);
        }
        if (columns.isEmpty()) {
            return;
        }
        if (this.sortingEquals(columns, order, !additive)) {
            return;
        }
        if (!additive) {
            this.myColumnAttributes.resetOrdering();
        }
        for (ModelIndex<DataConsumer.Column> column2 : columns) {
            this.changeSortOrder(column2, order);
        }
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
    }

    public boolean sortingEquals(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull RowSortOrder.Type order, boolean checkOtherColumns) {
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(58);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(59);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.getDataModel(DataAccessType.DATABASE_DATA);
        Set newColumns = ContainerUtil.map2Set(columns, c2 -> c2.asInteger());
        for (ModelIndex idx : model.getColumnIndices().asIterable()) {
            int oldOrder = this.myColumnAttributes.getSortOrder(model.getColumn(idx));
            if (!(newColumns.contains(idx.asInteger()) ? (order == RowSortOrder.Type.ASC ? oldOrder >= 0 : (order == RowSortOrder.Type.DESC ? oldOrder <= 0 : oldOrder != 0)) : checkOtherColumns && oldOrder != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column2;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(60);
        }
        Language language = (column2 = this.getDataModel().getColumn(columnIdx)) != null ? this.getContentLanguage(column2) : Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(61);
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull DataConsumer.Column column2) {
        Language fromAttributes;
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(62);
        }
        if ((fromAttributes = this.myColumnAttributes.getContentLanguage(column2)) == null) {
            Language language = this.getInitialContentLanguage(column2);
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(63);
            }
            return language;
        }
        if (fromAttributes != Language.ANY) {
            Language language = fromAttributes;
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(64);
            }
            return language;
        }
        Dbms dbms = DataGridUtil.getDbms(this);
        if (ObjectFormatter.isJson(column2, dbms)) {
            Json5Language json5Language = Json5Language.INSTANCE;
            if (json5Language == null) {
                TableResultPanel.$$$reportNull$$$0(65);
            }
            return json5Language;
        }
        if (dbms.isTransactSql() && StringUtil.equalsIgnoreCase((CharSequence)"xml", (CharSequence)column2.typeName)) {
            return TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
        }
        if (column2.type == 2009) {
            return TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
        }
        Language language = Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(66);
        }
        return language;
    }

    public boolean isRowFilteredOut(@NotNull ModelIndex<?> rowIdx) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(67);
        }
        return false;
    }

    @Override
    @NotNull
    public DataExtractorFactory.Text getExtractorFactory() {
        DataExtractorFactory.Text text2 = this.myExtractorFactory;
        if (text2 == null) {
            TableResultPanel.$$$reportNull$$$0(68);
        }
        return text2;
    }

    @Override
    public void setExtractorFactory(@NotNull DataExtractorFactory.Text extractorFactory) {
        if (extractorFactory == null) {
            TableResultPanel.$$$reportNull$$$0(69);
        }
        this.myExtractorFactory = extractorFactory;
        this.myResultView.extractorFactoryChanged();
    }

    @NotNull
    private static Language getLanguageByIdOrAny(@NotNull String languageId) {
        if (languageId == null) {
            TableResultPanel.$$$reportNull$$$0(70);
        }
        Language language = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)languageId), (Object)Language.ANY);
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(71);
        }
        return language;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        DataConsumer.Column column2;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(72);
        }
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(73);
        }
        if ((column2 = this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.setContentLanguage(column2, language);
            this.myResultView.contentLanguageUpdated(columnIdx, language);
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onCellLanguageChanged(columnIdx, language);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myResultView.getContextColumn();
        if (modelIndex == null) {
            TableResultPanel.$$$reportNull$$$0(74);
        }
        return modelIndex;
    }

    @Override
    public void setFilterText(String filter2, int caretPosition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFilteringComponentShown() && !StringUtil.isEmptyOrSpaces((String)filter2)) {
            this.toggleFilteringComponent();
            this.getFilterComponent().getFilterPanel().requestFocusInWindow();
        }
        this.myFilterComponent.getFilterPanel().setText(filter2, caretPosition);
    }

    @NotNull
    public String getFilterText() {
        String string = this.myFilterComponent.getFilterPanel().getText();
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Override
    public boolean isReady() {
        return !this.getDataModel().isUpdatingNow();
    }

    @Override
    public boolean isEmpty() {
        return this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() == 0;
    }

    public void dispose() {
        if (this.myResultView != null) {
            Disposer.dispose((Disposable)this.myResultView);
        }
    }

    @Override
    public void showCell(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(76);
        }
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(77);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            int rawRowIndex = row.asInteger() + 1;
            this.scrollTo(rawRowIndex, column2);
        });
    }

    private void scrollTo(int dataRowIndex, ModelIndex<DataConsumer.Column> columnIdx) {
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = () -> {
            ModelIndex rowIdx = pageModel.findRow(dataRowIndex);
            Pair<Integer, Integer> rowAndColumn = this.getRawIndexConverter().rowAndColumn2View().fun(rowIdx.asInteger(), columnIdx.asInteger());
            ViewIndex<DataConsumer.Row> row = ViewIndex.forRow(this, (Integer)rowAndColumn.first);
            ViewIndex<DataConsumer.Column> column2 = ViewIndex.forColumn(this, (Integer)rowAndColumn.second);
            this.scrollToLocally(row, column2);
        };
        if (pageModel.findRow(dataRowIndex).isValid(this)) {
            localScrollRunnable.run();
        } else {
            GridLoader<DataConsumer.Row, DataConsumer.Column> loader = this.myDataHookUp.getLoader();
            int offset = Math.max(0, dataRowIndex - pageModel.getPageSize() / 2);
            loader.load(GridRequestSource.create(this, new DataGridRequestSource(this).doWhenDone(localScrollRunnable)), offset);
        }
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row) {
        this.getSelectionModel().setRowSelection(row.toModel(this), true);
    }

    public void scrollToLocally(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> column2) {
        Pair<Integer, Integer> rowAndColumn = this.getRawIndexConverter().rowAndColumn2Model().fun(row.asInteger(), column2.asInteger());
        this.getSelectionModel().setSelection(ModelIndex.forRow(this, (int)((Integer)rowAndColumn.first)), ModelIndex.forColumn(this, (int)((Integer)rowAndColumn.second)));
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringComponentShown() {
        return this.myFilterComponent.isVisible();
    }

    @Override
    public void toggleFilteringComponent() {
        this.myFilterComponent.setVisible(!this.myFilterComponent.isVisible());
    }

    @Override
    public void resetLayout() {
        this.myResultView.resetLayout();
    }

    public void fireContentChanged(@Nullable Object requestor) {
        Component rowHeader;
        JViewport header = this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)this.myMainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
            rowHeader.revalidate();
            rowHeader.repaint();
        }
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onContentChanged(this, requestor);
    }

    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(78);
        }
        return DbImplUtil.isRowId(column2);
    }

    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(79);
        }
        return Language.ANY;
    }

    protected int getInitialPosition(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(80);
        }
        return -1;
    }

    private Formatter getDateFormat(@NotNull DataConsumer.Column column2) {
        boolean isPostgresRange;
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(81);
        }
        Dbms dbms = DataGridUtil.getDbms(this);
        int jdbcType = ExtractorsUtil.guessJdbcType(column2, null, dbms);
        ObjectFormatter converter = this.getObjectFormatter();
        boolean bl = isPostgresRange = dbms.isPostgres() && StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"tstzrange", "tsrange"});
        if (isPostgresRange) {
            return RangeFormatResolver.resolveFormatter(converter, column2, dbms);
        }
        if (DbImplUtil.isZonedTimestampColumn(column2, dbms)) {
            return converter.getZonedTimestampFormat(column2, dbms);
        }
        if (DbImplUtil.isZonedTimeColumn(column2, dbms)) {
            return converter.getZonedTimeFormat(column2, dbms);
        }
        return jdbcType == 91 ? converter.getDateFormat(column2, dbms) : (jdbcType == 92 ? converter.getTimeFormat() : (jdbcType == 93 ? converter.getTimestampFormat(column2, dbms) : null));
    }

    public void setValueAt(@NotNull ModelIndexSet<DataConsumer.Row> viewRows, @NotNull ModelIndexSet<DataConsumer.Column> viewColumns, @Nullable Object value2, boolean allowImmediateUpdate, @Nullable Runnable moveToNextCellRunnable, @Nullable Object requestor) {
        ModelIndexSet<DataConsumer.Column> columns;
        if (viewRows == null) {
            TableResultPanel.$$$reportNull$$$0(82);
        }
        if (viewColumns == null) {
            TableResultPanel.$$$reportNull$$$0(83);
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDataHookup().getMutator();
        int[] validRows = this.valid(viewRows);
        int[] validColumns = this.valid(viewColumns);
        ModelIndexSet<DataConsumer.Row> rows = validRows.length > 0 ? ModelIndexSet.forRows(this, validRows) : null;
        ModelIndexSet<DataConsumer.Column> modelIndexSet = columns = validRows.length > 0 ? ModelIndexSet.forColumns(this, validColumns) : null;
        if (mutator == null || rows == null || this.getMutationModel().allValuesEqualTo(rows, columns, value2)) {
            if (moveToNextCellRunnable != null) {
                ApplicationManager.getApplication().invokeLater(moveToNextCellRunnable);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            DataGridRequestSource requestSource = new DataGridRequestSource(rows, columns, requestor);
            if (moveToNextCellRunnable != null) {
                requestSource.doWhenDone(moveToNextCellRunnable);
            }
            mutator.mutate(GridRequestSource.create(this, (Object)requestSource), rows, columns, value2, allowImmediateUpdate);
        });
    }

    private <T> int[] valid(ModelIndexSet<T> set) {
        return set.asList().stream().filter(idx -> idx.isValid(this)).mapToInt(Index::asInteger).toArray();
    }

    public boolean isHeaderSelecting() {
        return false;
    }

    private void setOrderingFromModel() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : this.getOrderingFromModel()) {
            this.changeSortOrder(order.getColumn(), order.getOrder());
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> getOrderingFromModel() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> list = sortingModel != null ? sortingModel.getAppliedOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            TableResultPanel.$$$reportNull$$$0(84);
        }
        return list;
    }

    public void updateSortKeysFromColumnAttributes() {
        this.myResultView.updateSortKeysFromColumnAttributes();
        this.fireContentChanged(null);
    }

    public void changeSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull RowSortOrder.Type targetSortOrder) {
        DataConsumer.Column column2;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(85);
        }
        if (targetSortOrder == null) {
            TableResultPanel.$$$reportNull$$$0(86);
        }
        if ((column2 = this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.changeSortOrder(column2, targetSortOrder);
        }
    }

    private void updateDataOrderingIfNeeded() {
        if (this.isSortViaOrderBy()) {
            this.updateDataOrdering(true);
        }
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List newOrdering;
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.alarm.cancelAllRequests();
            this.alarm.addRequest(() -> this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null)), 300);
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> createOrdering() {
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering = new ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>>(sortOrderMap.size());
        for (DataConsumer.Column column2 : sortOrderMap.values()) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this, column2.columnNum);
            ordering.add(this.getSortOrder(column2) < 0 ? RowSortOrder.asc(columnIdx) : RowSortOrder.desc(columnIdx));
        }
        ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>> arrayList = ordering;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering2) {
        if (ordering1 == null) {
            TableResultPanel.$$$reportNull$$$0(88);
        }
        if (ordering2 == null) {
            TableResultPanel.$$$reportNull$$$0(89);
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < ordering1.size(); ++i2) {
            RowSortOrder<ModelIndex<DataConsumer.Column>> o1 = ordering1.get(i2);
            RowSortOrder<ModelIndex<DataConsumer.Column>> o2 = ordering2.get(i2);
            if (Comparing.equal((Object)((Object)o1.getOrder()), (Object)((Object)o2.getOrder())) && Comparing.equal(o1.getColumn(), o2.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIndex) {
        if (columnIndex == null) {
            TableResultPanel.$$$reportNull$$$0(90);
        }
        if (!columnIndex.isValid(this)) {
            return false;
        }
        return this.isColumnEnabled(this.getDataModel().getColumn(columnIndex));
    }

    public boolean isColumnEnabled(@Nullable DataConsumer.Column column2) {
        if (column2 == null) {
            return false;
        }
        Boolean enabled = this.myColumnAttributes.isEnabled(column2);
        return enabled != null ? enabled : !this.isInitiallyDisabled(column2);
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        DataConsumer.Column column2;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(91);
        }
        if ((column2 = this.getDataModel().getColumn(columnIdx)) == null || this.isColumnEnabled(column2) == state) {
            return;
        }
        this.myColumnAttributes.setEnabled(column2, state);
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        this.storeOrRestoreSelection(columnIdx, state, selection);
        this.myResultView.setColumnEnabled(columnIdx, state);
        this.fireContentChanged(null);
        this.runWithIgnoreSelectionChanges(() -> this.getSelectionModel().restore(selection));
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<DataConsumer.Row> rowIdx, boolean state) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(92);
        }
        this.myResultView.setRowEnabled(rowIdx, state);
    }

    public void storeOrRestoreSelection(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state, @NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        boolean selected;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(93);
        }
        if (selection == null) {
            TableResultPanel.$$$reportNull$$$0(94);
        }
        int modelIndex = columnIdx.asInteger();
        if (state && this.myHiddenColumnSelectionHolder.contains(modelIndex)) {
            selection.addSelectedColumns(this, ModelIndexSet.forColumns(this, columnIdx.value));
            this.myHiddenColumnSelectionHolder.columnShown(modelIndex);
        } else if (!state && (selected = this.getSelectionModel().isSelectedColumn(columnIdx))) {
            this.myHiddenColumnSelectionHolder.columnHidden(modelIndex);
        }
    }

    @Override
    public void setPresentationMode(@NotNull GridPresentationMode presentationMode) {
        if (presentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(95);
        }
        if (this.myPresentationMode == presentationMode) {
            return;
        }
        DataGridUtil.saveAndRestoreSelection(this, () -> {
            boolean requestFocusInSearchField;
            this.myPresentationMode = presentationMode;
            ResultViewFactory newFactory = ResultViewFactory.of(presentationMode);
            boolean bl = requestFocusInSearchField = this.mySearchSession != null && IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner() == this.mySearchSession.getComponent().getSearchTextComponent();
            if (this.myViewFactory != newFactory) {
                boolean wasTransposed = this.myResultView.isTransposed();
                this.myViewFactory = newFactory;
                this.myLayeredPane.remove(this.myMainResultViewComponent);
                Disposer.dispose((Disposable)this.myResultView);
                this.createResultView();
                this.myResultView.setTransposed(wasTransposed);
                this.columnsAdded(this.getDataModel().getColumnIndices());
                if (this.mySearchSession != null) {
                    FindModel findModel = this.mySearchSession.getFindModel();
                    this.mySearchSession.close();
                    this.mySearchSession = this.myResultView.createSearchSession(findModel);
                }
            }
            this.myMainPanel.revalidate();
            this.myMainPanel.repaint();
            if (!DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this)) {
                IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)(requestFocusInSearchField ? this.mySearchSession.getComponent().getSearchTextComponent() : this.getPreferredFocusedComponent()), true));
            }
        });
    }

    @Override
    @NotNull
    public GridPresentationMode getPresentationMode() {
        GridPresentationMode gridPresentationMode = this.myPresentationMode;
        if (gridPresentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(96);
        }
        return gridPresentationMode;
    }

    public void runWithIgnoreSelectionChanges(Runnable runnable) {
        try {
            this.myHiddenColumnSelectionHolder.startAdjusting();
            runnable.run();
        }
        finally {
            this.myHiddenColumnSelectionHolder.endAdjusting();
        }
    }

    @Override
    public boolean isSafeToReload() {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    public boolean isSafeToUpdate(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(97);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(98);
        }
        return (mutator = this.myDataHookUp.getMutator()) == null || mutator.isUpdateSafe(rows, columns, newValue) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public GridFilterComponent getFilterComponent() {
        GridFilterComponent gridFilterComponent = this.myFilterComponent;
        if (gridFilterComponent == null) {
            TableResultPanel.$$$reportNull$$$0(99);
        }
        return gridFilterComponent;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    @Override
    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        HiddenColumnsSelectionHolder copy = this.myHiddenColumnSelectionHolder.copy();
        this.myHiddenColumnSelectionHolder.reset();
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        this.resetOrderingAndVisibility();
        if (this.myResultView instanceof ResultViewWithRows) {
            ((ResultViewWithRows)((Object)this.myResultView)).resetRowHeights();
        }
        if (this.myResultView instanceof ResultViewWithColumns) {
            ((ResultViewWithColumns)((Object)this.myResultView)).createDefaultColumnsFromModel();
        }
        this.myResultView.resetLayout();
        int[] modelIndices = copy.selectedModelIndices(this);
        selection.addSelectedColumns(this, ModelIndexSet.forColumns(this, modelIndices));
        this.getSelectionModel().restore(selection);
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(GridRequestSource.create(this, null));
        }
    }

    public void trueLayout() {
        Container parent2;
        Container container = parent2 = this.myResultView != null ? this.myResultView.getComponent().getParent() : null;
        if (parent2 == null) {
            return;
        }
        Dimension size = parent2.getSize();
        this.myResultView.getComponent().setPreferredSize(this.getDataModel().getColumnCount() == 0 ? size : null);
        this.myMainResultViewComponent.revalidate();
        this.myMainResultViewComponent.repaint(50L);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator<DataConsumer.Row, DataConsumer.Column> getMutator() {
        return this.myDataHookUp.getMutator();
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myResultView.orderingAndVisibilityChanged();
    }

    @NlsContexts.Tooltip
    @NotNull
    public String getColumnTooltipHtml(@Nullable DataConsumer.Column column2) {
        if (column2 == null) {
            return "";
        }
        String type = DataGridUtil.getSqlType(this, column2);
        String string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)this.myColumnAttributes.getName(column2)).bold()).append((String)(StringUtil.isNotEmpty((String)type) ? ": " + type : "")).append(this.getDateFormatSuffix(column2)).append(this.getColumnComment(column2)).wrapWith("html").toString();
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(100);
        }
        return string;
    }

    @Nls
    @NotNull
    private String getDateFormatSuffix(@NotNull DataConsumer.Column column2) {
        Formatter dateFormat;
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(101);
        }
        return (dateFormat = this.getDateFormat(column2)) != null ? " (" + dateFormat + ") " : "";
    }

    @NotNull
    private HtmlChunk getColumnComment(@NotNull DataConsumer.Column column2) {
        DasColumn dasColumn;
        String comment;
        if (column2 == null) {
            TableResultPanel.$$$reportNull$$$0(102);
        }
        String string = comment = (dasColumn = DataGridUtil.getDatabaseColumn((DataGrid)this, column2)) == null ? null : dasColumn.getComment();
        if (StringUtil.isEmptyOrSpaces((String)comment)) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                TableResultPanel.$$$reportNull$$$0(103);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = new HtmlBuilder().br().append((HtmlChunk)HtmlChunk.text((String)DbNodeDescriptor.adjustCommentString(comment)).wrapWith("pre")).toFragment();
        if (htmlChunk == null) {
            TableResultPanel.$$$reportNull$$$0(104);
        }
        return htmlChunk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 26: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 26: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterPopupActions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 26: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 14: 
            case 29: 
            case 33: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 15: 
            case 30: 
            case 34: 
            case 55: 
            case 56: 
            case 58: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 17: 
            case 37: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 18: 
            case 62: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFactory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 23: 
            case 25: 
            case 60: 
            case 72: 
            case 85: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToClone";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnToClone";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestSource";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 67: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractorFactory";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumns";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSortOrder";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering1";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering2";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndex";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowHeaderActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultView";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHookup";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainResultViewComponent";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLanguage";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorFactory";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageByIdOrAny";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderingFromModel";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrdering";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationMode";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterComponent";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnTooltipHtml";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 26: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRowHeader";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeCellType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerEscapeAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getThenBySortOrder";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStopped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setCells";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDataModel";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "toggleSortColumns";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sortColumns";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sortingEquals";
                break;
            }
            case 60: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getContentLanguage";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isRowFilteredOut";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setExtractorFactory";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByIdOrAny";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setContentLanguage";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "showCell";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isInitiallyDisabled";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getInitialContentLanguage";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getInitialPosition";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "changeSortOrder";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrdering";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isColumnEnabled";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "storeOrRestoreSelection";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "setPresentationMode";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToUpdate";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormatSuffix";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getColumnComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 26: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 84: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: 
            case 104: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SetValueRequestor {
        static final SetValueRequestor INSTANCE = new SetValueRequestor();

        private SetValueRequestor() {
        }
    }

    private static class LoadingMouseListener
    extends MouseAdapter {
        final Component myComponent;
        final TableResultPanel myGrid;

        LoadingMouseListener(@NotNull Component component, @NotNull TableResultPanel grid) {
            if (component == null) {
                LoadingMouseListener.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                LoadingMouseListener.$$$reportNull$$$0(1);
            }
            this.myComponent = component;
            this.myGrid = grid;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                this.myGrid.getDataHookup().getLoader().reloadCurrentPage(GridRequestSource.create(this.myGrid, null));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                ResultView view2 = this.myGrid.myResultView;
                if (view2 != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)view2.getComponent(), true));
                }
            } else {
                this.myComponent.removeMouseListener(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/TableResultPanel$LoadingMouseListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLoadDataPanel
    extends JPanel {
        final UIUtil.TextPainter myPainter;
        final TableResultPanel myGrid;

        MyLoadDataPanel(@NotNull TableResultPanel grid) {
            if (grid == null) {
                MyLoadDataPanel.$$$reportNull$$$0(0);
            }
            this.myPainter = EditorEmptyTextPainter.createTextPainter();
            this.myGrid = grid;
            this.setOpaque(true);
            this.myPainter.appendLine(DatabaseBundle.message((String)"DataView.load.data", (Object[])new Object[0]) + " <shortcut>" + KeymapUtil.getFirstKeyboardShortcutText((String)"Refresh") + "</shortcut>");
            this.addMouseListener(new LoadingMouseListener(this, grid));
        }

        @Override
        public Color getBackground() {
            return this.myGrid == null || this.myGrid.myResultView == null ? super.getBackground() : this.myGrid.myColorsScheme.getDefaultBackground();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            UISettings.setupAntialiasing((Graphics)g);
            this.myPainter.draw(g, (width, height) -> Couple.of((Object)((this.getWidth() - width) / 2), (Object)((this.getHeight() - height) / 2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/TableResultPanel$MyLoadDataPanel", "<init>"));
        }
    }

    public static class ColumnAttributes {
        private final Map<DataConsumer.Column, Attributes> myAttributesMap = new HashMap<DataConsumer.Column, Attributes>();
        private List<String> myUnambiguousColumnNames = ContainerUtil.emptyList();

        @NlsSafe
        @NotNull
        public String getName(DataConsumer.Column column2) {
            String name = column2.columnNum < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column2.columnNum) : column2.name;
            return StringUtil.isNotEmpty((String)name) ? name : "<anonymous>";
        }

        @Nullable
        public Language getContentLanguage(DataConsumer.Column column2) {
            Attributes attributes2 = this.myAttributesMap.get(column2);
            return attributes2 == null ? null : attributes2.myContentLanguage;
        }

        public void setContentLanguage(DataConsumer.Column column2, @NotNull Language language) {
            if (language == null) {
                ColumnAttributes.$$$reportNull$$$0(0);
            }
            this.myAttributesMap.get((Object)column2).myContentLanguage = language;
        }

        @Nullable
        public Comparator<DataConsumer.Row> getComparator(DataConsumer.Column column2) {
            Attributes attributes2 = this.myAttributesMap.get(column2);
            return attributes2 == null ? null : attributes2.myComparator;
        }

        @Nullable
        private Boolean isEnabled(DataConsumer.Column column2) {
            Attributes attributes2 = this.myAttributesMap.get(column2);
            return attributes2 == null ? null : attributes2.myEnabled;
        }

        public void setEnabled(DataConsumer.Column column2, boolean enabled) {
            this.myAttributesMap.get((Object)column2).myEnabled = enabled;
        }

        public int getSortOrder(DataConsumer.Column column2) {
            Attributes attributes2 = this.myAttributesMap.get(column2);
            return attributes2 == null || attributes2.mySortOrder == null ? 0 : attributes2.mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (DataConsumer.Column column2 : this.myAttributesMap.keySet()) {
                this.setEnabled(column2, !DbImplUtil.isRowId(column2));
            }
        }

        public void changeSortOrder(DataConsumer.Column targetColumn, @NotNull RowSortOrder.Type targetSortOrder) {
            if (targetSortOrder == null) {
                ColumnAttributes.$$$reportNull$$$0(1);
            }
            if (this.getComparator(targetColumn) == null) {
                return;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            if (prevOrder != 0 && targetSortOrder != RowSortOrder.Type.UNSORTED) {
                int prevOrderAbs = Math.abs(prevOrder);
                this.setSortOrder(targetColumn, targetSortOrder == RowSortOrder.Type.ASC ? -prevOrderAbs : prevOrderAbs);
                return;
            }
            int maxOrder = 0;
            for (DataConsumer.Column column2 : this.myAttributesMap.keySet()) {
                if (Comparing.equal((Object)column2, (Object)targetColumn)) continue;
                int order = this.getSortOrder(column2);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column2, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : 0);
            this.setSortOrder(targetColumn, newOrder);
        }

        public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
            TreeMap<Integer, DataConsumer.Column> sortOrderMap = new TreeMap<Integer, DataConsumer.Column>();
            for (DataConsumer.Column column2 : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column2);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column2);
            }
            return sortOrderMap;
        }

        private void updateColumnNames(TableResultPanel resultPanel) {
            DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
            SqlTableType type = hookup != null ? hookup.getTableType() : null;
            this.myUnambiguousColumnNames = type == null ? ContainerUtil.emptyList() : DbSqlUtil.getUnambiguousColumnNames(resultPanel.getProject(), hookup.getDatabaseDialect(), type, null);
        }

        public void newColumns(TableResultPanel resultPanel, Collection<DataConsumer.Column> columnsToRetain) {
            this.updateColumnNames(resultPanel);
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            columnsToRetain.stream().filter(column2 -> !this.myAttributesMap.containsKey(column2)).forEach(column2 -> this.myAttributesMap.put((DataConsumer.Column)column2, new Attributes(GridRowComparator.create(column2))));
        }

        private void setSortOrder(DataConsumer.Column column2, int sortOrder) {
            this.myAttributesMap.get((Object)column2).mySortOrder = sortOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetSortOrder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContentLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeSortOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class Attributes {
            Language myContentLanguage;
            final Comparator<DataConsumer.Row> myComparator;
            Boolean myEnabled;
            Integer mySortOrder;

            Attributes(@Nullable GridRowComparator comparator2) {
                this.myComparator = comparator2;
            }
        }
    }
}

