/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseLogViewService;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.MessageBusSessionState;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StateWatcher
extends DataAuditor.BusyCounter {
    protected StateWatcher(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            StateWatcher.$$$reportNull$$$0(0);
        }
        bus.addAuditor(this);
    }

    @Override
    protected void update(int current) {
        DbUIUtil.invokeLaterIfNeeded(() -> {
            LogView view2 = this.getView();
            if (view2 == null) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            if (this.getCount() > 0) {
                view2.startLoading();
                return;
            }
            view2.stopLoading();
        });
    }

    public boolean isIdle() {
        return this.getCount() == 0;
    }

    abstract boolean isValid();

    @Nullable
    abstract LogView getView();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/database/run/session/StateWatcher", "<init>"));
    }

    public static class ClientWatcher
    extends StateWatcher {
        private final DatabaseSessionClientWithFile myClient;

        public ClientWatcher(@NotNull DatabaseSessionClientWithFile client) {
            if (client == null) {
                ClientWatcher.$$$reportNull$$$0(0);
            }
            super(client.getMessageBus());
            this.myClient = client;
        }

        @Override
        boolean isValid() {
            return this.myClient.isValid();
        }

        @Override
        @Nullable
        LogView getView() {
            return DatabaseLogViewService.getViewIfAny(this.myClient);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/database/run/session/StateWatcher$ClientWatcher", "<init>"));
        }
    }

    public static class DatabaseSessionWatcher
    extends StateWatcher {
        private final MessageBusSession mySession;

        public DatabaseSessionWatcher(@NotNull MessageBusSession session2) {
            if (session2 == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(0);
            }
            super(session2.getMessageBus());
            this.mySession = session2;
        }

        @Override
        boolean isValid() {
            return this.mySession.isValid();
        }

        @Override
        @Nullable
        LogView getView() {
            return DatabaseLogViewService.getViewIfAny(this.mySession);
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(1);
            }
            if (producer == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(2);
            }
            long time = System.currentTimeMillis();
            super.jobSubmitted(request, producer);
            DbUIUtil.invokeLaterIfNeeded(() -> {
                MessageBusSessionState newState = this.getState().resetIfEmpty();
                this.mySession.setState(DatabaseSessionWatcher.isEnabledFor(request) ? newState.plus(request, time) : newState);
            });
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(3);
            }
            if (producer == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(4);
            }
            long time = System.currentTimeMillis();
            super.jobFinished(request, producer);
            if (!DatabaseSessionWatcher.isEnabledFor(request)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().deactivate(time, request).update()));
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            DataRequest.CoupledWithEditor.ErrorNavigator navigator;
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(5);
            }
            DataRequest.CoupledWithEditor request = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)((Object)context.request), DataRequest.CoupledWithEditor.class);
            List fixes = (List)DatabaseErrorHandler.FIXES.get((UserDataHolder)context);
            DataRequest.CoupledWithEditor.ErrorNavigator errorNavigator = navigator = request == null ? null : DatabaseSessionWatcher.handleError(request, message2, th, fixes);
            if (!DatabaseSessionWatcher.isEnabledFor(context.request)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                MessageBusSessionState state = this.getState();
                MessageBusSessionState newState = th instanceof JdbcEngine.EngineWarningException ? state.warning(context.request, (String)ObjectUtils.notNull((Object)((JdbcEngine.EngineWarningException)th).getLogMessage(), (Object)DatabaseBundle.message((String)"text.unknown.error", (Object[])new Object[0]))) : state.error(context.request, navigator, (String)ObjectUtils.notNull((Object)message2, (Object)DatabaseBundle.message((String)"text.unknown.error", (Object[])new Object[0])));
                this.mySession.setState(newState);
            });
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(6);
            }
            long startTime = System.currentTimeMillis();
            if (!DatabaseSessionWatcher.isEnabledFor(context)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().activate(startTime, context.request)));
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(7);
            }
            long finishTime = System.currentTimeMillis();
            if (!DatabaseSessionWatcher.isEnabledFor(context)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> this.mySession.setState(this.getState().deactivate(finishTime, context.request)));
        }

        private static @Nullable DataRequest.CoupledWithEditor.ErrorNavigator handleError(@NotNull DataRequest.CoupledWithEditor request, @Nullable String message2, @Nullable Throwable th, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(8);
            }
            if (th instanceof JdbcEngine.EngineWarningException) {
                JdbcEngine.EngineWarningException warning = (JdbcEngine.EngineWarningException)th;
                request.onWarning(message2, warning.getSuppressAction(), warning.getConcession());
                return null;
            }
            return request.onError(message2, th, fixes);
        }

        private static boolean isEnabledFor(@NotNull DataRequest.Context context) {
            if (context == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(9);
            }
            return !MeasuringDataAuditor.isSilent(context) && DatabaseSessionWatcher.isEnabledFor(context.request);
        }

        private static boolean isEnabledFor(@NotNull DataRequest request) {
            if (request == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(10);
            }
            return !(request instanceof DataRequest.Cancel) && !(request instanceof DataRequest.Disconnect) && (!(request instanceof DataRequest.SchemaSwitchRequest) || ((DataRequest.SchemaSwitchRequest)request).forced) && !(request instanceof DataRequest.TxRequest);
        }

        @NotNull
        private MessageBusSessionState getState() {
            MessageBusSessionState messageBusSessionState = this.mySession.getState();
            if (messageBusSessionState == null) {
                DatabaseSessionWatcher.$$$reportNull$$$0(11);
            }
            return messageBusSessionState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 3: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/StateWatcher$DatabaseSessionWatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/StateWatcher$DatabaseSessionWatcher";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "jobSubmitted";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "jobFinished";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "requestStarted";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFinished";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleError";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledFor";
                    break;
                }
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SessionWatcher
    extends StateWatcher {
        private final Session mySession;

        public SessionWatcher(@NotNull Session session2) {
            if (session2 == null) {
                SessionWatcher.$$$reportNull$$$0(0);
            }
            super(session2.getMessageBus());
            this.mySession = session2;
        }

        @Override
        @Nullable
        LogView getView() {
            VisibleSession session2 = (VisibleSession)ObjectUtils.tryCast((Object)this.mySession, VisibleSession.class);
            return session2 == null ? null : (LogView)session2.getView();
        }

        @Override
        boolean isValid() {
            return this.mySession.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/run/session/StateWatcher$SessionWatcher", "<init>"));
        }
    }
}

