/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ViewQueryAction
extends AlignedIconWithTextAction
implements DumbAware,
GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ViewQueryAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(DataGridUtil.getQueryText((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null);
        e.getPresentation().setDisabledIcon(EmptyIcon.ICON_0);
        e.getPresentation().setIcon(EmptyIcon.ICON_0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ViewQueryAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        String queryText2 = DataGridUtil.getQueryText(dataGrid);
        if (project == null || queryText2 == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.doWhenComponentIsFocused(project, dataGrid.getPreferredFocusedComponent(), () -> DocumentationManager.getInstance((Project)project).showJavaDocInfo(DataGridPomTarget.wrapDataGrid(project, dataGrid), null)));
    }

    private void doWhenComponentIsFocused(@NotNull Project project, final @NotNull JComponent component, final @NotNull Runnable runnable) {
        if (project == null) {
            ViewQueryAction.$$$reportNull$$$0(2);
        }
        if (component == null) {
            ViewQueryAction.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            ViewQueryAction.$$$reportNull$$$0(4);
        }
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
            if (IdeFocusManager.getInstance((Project)project).getFocusOwner() == component) {
                runnable.run();
                return;
            }
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    runnable.run();
                    component.removeFocusListener(this);
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            component.addFocusListener(focusListener);
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)component, true);
            EdtScheduledExecutorService.getInstance().schedule(() -> component.removeFocusListener(focusListener), ModalityState.defaultModalityState(), 2L, TimeUnit.SECONDS);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/ViewQueryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhenComponentIsFocused";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

