/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.ActionCallback;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SubmitMutations
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(0);
        }
        SubmitMutations.updateAvailability(e);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabled(e.getPresentation().isEnabled() && grid != null && !grid.getDataSupport().hasUnparsedValues());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(1);
        }
        SubmitMutations.submitChangesIfExists(e);
    }

    public static void updateAvailability(@NotNull AnActionEvent e) {
        if (e == null) {
            SubmitMutations.$$$reportNull$$$0(2);
        }
        if (!SubmitMutations.isVisible(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(SubmitMutations.hasChangesToSubmit(e));
    }

    public static boolean hasChangesToSubmit(AnActionEvent e) {
        if (!SubmitMutations.isVisible(e)) {
            return false;
        }
        DataGrid dataGrid = Objects.requireNonNull(DataGridUtil.getDataGrid(e.getDataContext()));
        GridDataSupport support = dataGrid.getDataSupport();
        return support.hasPendingChanges() && !dataGrid.isEditing();
    }

    @NotNull
    public static ActionCallback submitChangesIfExists(AnActionEvent e) {
        if (!SubmitMutations.hasChangesToSubmit(e)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                SubmitMutations.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }
        DataGrid dataGrid = Objects.requireNonNull(DataGridUtil.getDataGrid(e.getDataContext()));
        ActionCallback actionCallback = dataGrid.submit();
        if (actionCallback == null) {
            SubmitMutations.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    public static boolean isVisible(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null || !dataGrid.isEditable() && DataGridUtil.getDatabaseTable(dataGrid) == null) {
            return false;
        }
        GridDataSupport support = dataGrid.getDataSupport();
        return !support.isSubmitImmediately() || support.hasPendingChanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SubmitMutations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SubmitMutations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "submitChangesIfExists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateAvailability";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

