/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DumpSourceNameProvider<T> {
    public static final int MAX_SYMBOLS = 40;

    @Nullable
    public String getName(@NotNull T var1);

    @Nullable
    public String getQueryText(@NotNull T var1);

    public static final class DataGridSourceNameProvider
    implements DumpSourceNameProvider<DataGrid> {
        public static final DataGridSourceNameProvider INSTANCE = new DataGridSourceNameProvider();

        private DataGridSourceNameProvider() {
        }

        @Override
        @Nullable
        public String getName(@NotNull DataGrid source) {
            String tabTitle;
            if (source == null) {
                DataGridSourceNameProvider.$$$reportNull$$$0(0);
            }
            if ((tabTitle = DataGridUtil.getResultSetName(DataGridUtil.getProject(source), source)) != null) {
                return tabTitle;
            }
            DasTable table = DataGridUtil.getDatabaseTable(source);
            if (table != null) {
                return QNameUtil.getQualifiedName((DasObject)table);
            }
            String query = this.getQueryText(source);
            if (query == null) {
                return null;
            }
            return query.substring(0, Math.min(40, query.length()));
        }

        @Override
        @Nullable
        public String getQueryText(@NotNull DataGrid source) {
            if (source == null) {
                DataGridSourceNameProvider.$$$reportNull$$$0(1);
            }
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(source);
            VirtualFile file = DataGridUtil.getVirtualFile(source);
            return hookUp != null ? hookUp.getUnlimitedQueryText(true) : (file != null ? file.getName() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/run/actions/DumpSourceNameProvider$DataGridSourceNameProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getQueryText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DbTablesSourceNameProvider
    implements DumpSourceNameProvider<DbTable> {
        public static final DbTablesSourceNameProvider INSTANCE = new DbTablesSourceNameProvider();

        private DbTablesSourceNameProvider() {
        }

        @Override
        @NotNull
        public String getName(@NotNull DbTable source) {
            if (source == null) {
                DbTablesSourceNameProvider.$$$reportNull$$$0(0);
            }
            String string = QNameUtil.getQualifiedName((DbElement)source);
            if (string == null) {
                DbTablesSourceNameProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getQueryText(@NotNull DbTable source) {
            if (source == null) {
                DbTablesSourceNameProvider.$$$reportNull$$$0(2);
            }
            Dbms dbms = source.getDataSource().getDbms();
            SelectTask task = DmlTaskKt.allColumns((DasTable)source).version(source.getDataSource().getVersion()).build(DbImplUtil.createBuilderForUIExec(dbms, (DasObject)source));
            String string = DmlUtilKt.dmlGenerator(dbms).generate(task).getStatement();
            if (string == null) {
                DbTablesSourceNameProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/DumpSourceNameProvider$DbTablesSourceNameProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/DumpSourceNameProvider$DbTablesSourceNameProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueryText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConsoleSourceNameProvider
    implements DumpSourceNameProvider<String> {
        public static final ConsoleSourceNameProvider INSTANCE = new ConsoleSourceNameProvider();

        private ConsoleSourceNameProvider() {
        }

        @Override
        @NotNull
        public String getName(@NotNull String source) {
            if (source == null) {
                ConsoleSourceNameProvider.$$$reportNull$$$0(0);
            }
            String string = source.substring(0, Math.min(40, source.length()));
            if (string == null) {
                ConsoleSourceNameProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getQueryText(@NotNull String source) {
            if (source == null) {
                ConsoleSourceNameProvider.$$$reportNull$$$0(2);
            }
            String string = source;
            if (string == null) {
                ConsoleSourceNameProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/DumpSourceNameProvider$ConsoleSourceNameProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/DumpSourceNameProvider$ConsoleSourceNameProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueryText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

