/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface DumpSource<T> {
    @NotNull
    public JBIterable<T> getSources();

    @NotNull
    public DumpSourceNameProvider<T> getNameProvider();

    public static class DbTablesSource
    implements DumpSource<DbTable> {
        private final JBIterable<DbTable> myTables;

        public DbTablesSource(JBIterable<DbTable> tables) {
            this.myTables = tables;
        }

        @Override
        @NotNull
        public JBIterable<DbTable> getSources() {
            JBIterable<DbTable> jBIterable = this.myTables;
            if (jBIterable == null) {
                DbTablesSource.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        @NotNull
        public DumpSourceNameProvider.DbTablesSourceNameProvider getNameProvider() {
            DumpSourceNameProvider.DbTablesSourceNameProvider dbTablesSourceNameProvider = DumpSourceNameProvider.DbTablesSourceNameProvider.INSTANCE;
            if (dbTablesSourceNameProvider == null) {
                DbTablesSource.$$$reportNull$$$0(1);
            }
            return dbTablesSourceNameProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/actions/DumpSource$DbTablesSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameProvider";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class DataGridSource
    implements DumpSource<DataGrid> {
        private final DataGrid myGrid;

        public DataGridSource(DataGrid grid) {
            this.myGrid = grid;
        }

        @NotNull
        public DataGrid getGrid() {
            DataGrid dataGrid = this.myGrid;
            if (dataGrid == null) {
                DataGridSource.$$$reportNull$$$0(0);
            }
            return dataGrid;
        }

        @Override
        @NotNull
        public JBIterable<DataGrid> getSources() {
            JBIterable jBIterable = JBIterable.of((Object)this.myGrid);
            if (jBIterable == null) {
                DataGridSource.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @NotNull
        public DumpSourceNameProvider.DataGridSourceNameProvider getNameProvider() {
            DumpSourceNameProvider.DataGridSourceNameProvider dataGridSourceNameProvider = DumpSourceNameProvider.DataGridSourceNameProvider.INSTANCE;
            if (dataGridSourceNameProvider == null) {
                DataGridSource.$$$reportNull$$$0(2);
            }
            return dataGridSourceNameProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/actions/DumpSource$DataGridSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGrid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameProvider";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ConsoleSource
    implements DumpSource<String> {
        private final JdbcConsole console;
        private final ScriptModel<?> model;

        public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
            if (console == null) {
                ConsoleSource.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ConsoleSource.$$$reportNull$$$0(1);
            }
            this.console = console;
            this.model = model;
        }

        @NotNull
        public JdbcConsole getConsole() {
            JdbcConsole jdbcConsole = this.console;
            if (jdbcConsole == null) {
                ConsoleSource.$$$reportNull$$$0(2);
            }
            return jdbcConsole;
        }

        @NotNull
        public ScriptModel<?> getModel() {
            ScriptModel<?> scriptModel = this.model;
            if (scriptModel == null) {
                ConsoleSource.$$$reportNull$$$0(3);
            }
            return scriptModel;
        }

        @Override
        @NotNull
        public JBIterable<String> getSources() {
            FileDocumentManager.getInstance().saveAllDocuments();
            JBIterable jBIterable = JBIterable.from((Iterable)this.model.statements().transform(it2 -> {
                try {
                    return it2.text(this.console.getPStorage(), Conditions.alwaysFalse());
                }
                catch (TranslateException e) {
                    return null;
                }
            }).filter(Objects::nonNull).toList());
            if (jBIterable == null) {
                ConsoleSource.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        public DumpSourceNameProvider.ConsoleSourceNameProvider getNameProvider() {
            DumpSourceNameProvider.ConsoleSourceNameProvider consoleSourceNameProvider = DumpSourceNameProvider.ConsoleSourceNameProvider.INSTANCE;
            if (consoleSourceNameProvider == null) {
                ConsoleSource.$$$reportNull$$$0(5);
            }
            return consoleSourceNameProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/DumpSource$ConsoleSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/DumpSource$ConsoleSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

