/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TextWithRanges;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataGridPreviewDmlAction
extends DumbAwareAction
implements DumbAware {
    private static final int REFORMAT_LIMIT = 10000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(0);
        }
        SubmitMutations.updateAvailability(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(1);
        }
        DataGrid grid = Objects.requireNonNull(DataGridUtil.getDataGrid(e.getDataContext()));
        DatabaseGridDataHookUp hookUp = Objects.requireNonNull(DataGridUtil.getDatabaseHookUp(grid));
        DatabaseMutatorImpl mutator = Objects.requireNonNull(hookUp.getMutator());
        SearchPath searchPath = (SearchPath)ObjectUtils.doIfCast((Object)hookUp, DataRequest.CustomSearchPathOwner.class, o -> o.getSearchPath());
        String statements2 = mutator.getPendingChanges();
        Dbms dbms = hookUp.getDbms();
        DbDataSource dataSource2 = hookUp.getDataSource();
        Project project = Objects.requireNonNull(e.getProject());
        String text2 = statements2.length() > 10000 ? statements2 : DataGridPreviewDmlAction.reformat(statements2, dataSource2, project);
        EditorTextField area = DatabaseDialogsHelper.createLanguageEditorArea(project, dbms, dataSource2, searchPath, text2, true);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)area, "Center");
        DialogBuilder builder = new DialogBuilder();
        builder.setCenterPanel((JComponent)panel2);
        builder.setDimensionServiceKey("data.grid.dml.preview.dialog");
        builder.addOkAction().setText(DatabaseBundle.message((String)"action.Console.TableResult.Submit.text", (Object[])new Object[0]));
        builder.setOkActionEnabled(!grid.getDataSupport().hasUnparsedValues());
        builder.addCancelAction();
        builder.setTitle(DatabaseBundle.message((String)"grid.preview.dml.action.dialog", (Object[])new Object[0]));
        if (builder.showAndGet()) {
            SubmitMutations.submitChangesIfExists(e);
        }
    }

    @NotNull
    private static String reformat(final @NotNull String statements2, @NotNull DbDataSource dataSource2, @NotNull Project project) {
        if (statements2 == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(4);
        }
        String string = SqlPsiFacade.getInstance((Project)project).format(project, DbSqlUtilCore.getSqlDialect(dataSource2.getDbms()), new TextWithRanges(){

            @NotNull
            public List<TextWithRanges.Chunk> getChunks() {
                List<TextWithRanges.Chunk> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            public String toString() {
                return statements2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DataGridPreviewDmlAction$1", "getChunks"));
            }
        }).toString();
        if (string == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DataGridPreviewDmlAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DataGridPreviewDmlAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

