/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.diff.TableDiffTool;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithGroup
extends ActionGroup
implements DumbAware {
    public boolean canBePerformed(@NotNull DataContext context) {
        if (context == null) {
            CompareWithGroup.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareWithGroup.$$$reportNull$$$0(1);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"popup.title.data.grids", (Object[])new Object[0]), (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20);
        DbUIUtil.showPopup((JBPopup)popup2, null, e);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        Pair<@Nls String, GridDataHookUpManager.HookUpHandle> current = CompareWithGroup.getCurrentHookUp(e.getDataContext());
        if (current == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        CompareWithGroup.appendConsoles(result, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        CompareWithGroup.appendEditors(result, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        AnAction[] anActionArray = result.isEmpty() ? EMPTY_ARRAY : result.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CompareWithGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static void appendConsoles(@NotNull List<AnAction> result, @NotNull DataContext ctx, @NotNull @NlsContexts.Label String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result == null) {
            CompareWithGroup.$$$reportNull$$$0(5);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(6);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(7);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(8);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            for (Content content : console.getContents()) {
                GridDataHookUpManager.HookUpHandle handle2;
                DataGrid grid = ScriptingClientDataConsumer.getDataGrid(content);
                if (grid == null || (handle2 = hookUpManager.getHandle(grid.getDataHookup())).equals(curHandle)) continue;
                result.add((AnAction)new MyDiffAction(curName, content.getTabName(), curHandle, handle2));
            }
        }
    }

    private static void appendEditors(@NotNull List<AnAction> result, @NotNull DataContext ctx, @NotNull @NlsContexts.Label String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result == null) {
            CompareWithGroup.$$$reportNull$$$0(9);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(10);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(11);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(12);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (FileEditor editor : editorManager.getAllEditors()) {
            GridDataHookUpManager.HookUpHandle handle2;
            TableEditorBase tableEditor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editor, TableEditorBase.class));
            if (tableEditor == null || (handle2 = hookUpManager.getHandle(tableEditor.getDataGrid().getDataHookup())).equals(curHandle)) continue;
            result.add((AnAction)new MyDiffAction(curName, CompareWithGroup.getEditorTitle(tableEditor), curHandle, handle2));
        }
    }

    private static @Nullable Pair<@Nls String, GridDataHookUpManager.HookUpHandle> getCurrentHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(13);
        }
        return (Pair)ObjectUtils.chooseNotNull(CompareWithGroup.getCurrentConsoleHookUp(ctx), CompareWithGroup.getCurrentEditorHookUp(ctx));
    }

    private static @Nullable Pair<@Nls String, GridDataHookUpManager.HookUpHandle> getCurrentConsoleHookUp(@NotNull DataContext ctx) {
        DataGrid currentGrid;
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(14);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext((DataContext)ctx, (boolean)false);
        if (contentManager == null || project == null) {
            return null;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        Content currentContent = contentManager.getSelectedContent();
        DataGrid dataGrid = currentGrid = currentContent != null ? ScriptingClientDataConsumer.getDataGrid(currentContent) : null;
        if (currentGrid == null) {
            return null;
        }
        return Pair.create((Object)currentContent.getTabName(), (Object)hookUpManager.getHandle(currentGrid.getDataHookup()));
    }

    private static @Nullable Pair<@Nls String, GridDataHookUpManager.HookUpHandle> getCurrentEditorHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(15);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(ctx);
        if (project == null || file == null) {
            return null;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        TableEditorBase editor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editorManager.getSelectedEditor(file), TableEditorBase.class));
        if (editor == null) {
            return null;
        }
        return Pair.create((Object)CompareWithGroup.getEditorTitle(editor), (Object)hookUpManager.getHandle(editor.getDataGrid().getDataHookup()));
    }

    @NlsContexts.Label
    private static String getEditorTitle(@NotNull TableEditorBase editor) {
        if (editor == null) {
            CompareWithGroup.$$$reportNull$$$0(16);
        }
        String name = "";
        if (editor instanceof DatabaseTableFileEditor) {
            name = ((DatabaseTableFileEditor)editor).getFile().getPresentableName();
        } else if (editor instanceof CsvTableFileEditor) {
            name = ((CsvTableFileEditor)editor).getFile().getPresentableName();
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curHandle";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBePerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendEditors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHookUp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentConsoleHookUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorHookUp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DiffTablesAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Couple<DbElement> pair;
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(0);
            }
            if ((pair = DiffTablesAction.getDiffElements(e)) == null) {
                return;
            }
            Project project = ((DbElement)pair.first).getProject();
            DatabaseElementVirtualFileImpl table1 = DatabaseElementVirtualFileImpl.findFile((DbElement)pair.first, false);
            DatabaseElementVirtualFileImpl table2 = DatabaseElementVirtualFileImpl.findFile((DbElement)pair.second, false);
            if (table1 == null || table2 == null) {
                return;
            }
            String name1 = table1.getPresentableName();
            String name2 = table2.getPresentableName();
            SimpleDiffRequest dr = new SimpleDiffRequest(name1 + " vs " + name2, (DiffContent)new TableDiffTool.TableDiffContent((Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>>)((Function)d2 -> DiffTablesAction.createHookup(project, table1, d2))), (DiffContent)new TableDiffTool.TableDiffContent((Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>>)((Function)d2 -> DiffTablesAction.createHookup(project, table2, d2))), name1, name2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }

        @NotNull
        private static DatabaseTableGridDataHookUp createHookup(Project project, DatabaseElementVirtualFileImpl table1, Disposable d2) {
            DatabaseTableGridDataHookUp grid = GridDataHookUpManager.getInstance(project).getOrCreateLightweight(table1, d2, new DGDepartment.DataEditor(JdbcConsole.getTitle(project, table1)));
            grid.getLoader().loadFirstPage(GridRequestSource.create(null, null));
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = grid;
            if (databaseTableGridDataHookUp == null) {
                DiffTablesAction.$$$reportNull$$$0(1);
            }
            return databaseTableGridDataHookUp;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(DiffTablesAction.getDiffElements(e) != null);
        }

        @Nullable
        private static Couple<DbElement> getDiffElements(@NotNull AnActionEvent e) {
            PsiElement[] elements;
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(3);
            }
            if ((elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) == null || elements.length != 2) {
                return null;
            }
            DbElement e1 = (DbElement)ObjectUtils.tryCast((Object)elements[0], DbElement.class);
            if (e1 == null || !DbImplUtilCore.isDataTable(e1.getKind())) {
                return null;
            }
            DbElement e2 = (DbElement)ObjectUtils.tryCast((Object)elements[1], DbElement.class);
            if (e2 == null || !DbImplUtilCore.isDataTable(e2.getKind())) {
                return null;
            }
            return Couple.of((Object)e1, (Object)e2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/CompareWithGroup$DiffTablesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup$DiffTablesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHookup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDiffElements";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDiffAction
    extends DumbAwareAction {
        private final @NlsContexts.Label String myName1;
        private final @NlsContexts.Label String myName2;
        GridDataHookUpManager.HookUpHandle myHandle1;
        GridDataHookUpManager.HookUpHandle myHandle2;

        MyDiffAction(@NotNull @NlsContexts.Label String name1, @NotNull @NlsContexts.Label String name2, @NotNull GridDataHookUpManager.HookUpHandle handle1, @NotNull GridDataHookUpManager.HookUpHandle handle2) {
            if (name1 == null) {
                MyDiffAction.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                MyDiffAction.$$$reportNull$$$0(1);
            }
            if (handle1 == null) {
                MyDiffAction.$$$reportNull$$$0(2);
            }
            if (handle2 == null) {
                MyDiffAction.$$$reportNull$$$0(3);
            }
            super(StringUtil.escapeMnemonics((String)name2));
            this.myName1 = name1;
            this.myName2 = name2;
            this.myHandle1 = handle1;
            this.myHandle2 = handle2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(4);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            SimpleDiffRequest dr = new SimpleDiffRequest(this.myName1 + " vs " + this.myName2, (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle1, project), (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle2, project), this.myName1, this.myName2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handle1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handle2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

