/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompareCellsAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CompareCellsAction.$$$reportNull$$$0(0);
        }
        SelectionModel model = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : grid.getSelectionModel();
        int cells = model == null ? 0 : model.getSelectedColumns().size() * model.getSelectedRows().size();
        e.getPresentation().setEnabledAndVisible(cells > 1 && cells <= 3);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CompareCellsAction.$$$reportNull$$$0(1);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        SelectionModel model = grid.getSelectionModel();
        ModelIndexSet<DataConsumer.Column> columns = model.getSelectedColumns();
        ModelIndexSet<DataConsumer.Row> rows = model.getSelectedRows();
        List<Cell> cells = CompareCellsAction.getCells(rows, columns, grid);
        DiffContentFactory factory = DiffContentFactory.getInstance();
        List contents = ContainerUtil.map(cells, v -> factory.create(v.value, (FileType)v.language.getAssociatedFileType()));
        List titles = ContainerUtil.map(cells, v -> v.title);
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        String tableName = table == null ? null : " (" + table.getName() + ")";
        String title = StringUtil.join((Collection)titles, (String)" vs ") + tableName;
        SimpleDiffRequest request = new SimpleDiffRequest(title, contents, titles);
        DiffManager.getInstance().showDiff(e.getProject(), (DiffRequest)request);
    }

    @NotNull
    private static List<Cell> getCells(@NotNull ModelIndexSet<DataConsumer.Row> rowsIdxs, @NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs, @NotNull DataGrid grid) {
        if (rowsIdxs == null) {
            CompareCellsAction.$$$reportNull$$$0(2);
        }
        if (columnsIdxs == null) {
            CompareCellsAction.$$$reportNull$$$0(3);
        }
        if (grid == null) {
            CompareCellsAction.$$$reportNull$$$0(4);
        }
        GridModel dataModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ObjectFormatter formatter = grid.getObjectFormatter();
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (ModelIndex columnIdx : columnsIdxs.asIterable()) {
            DataConsumer.Column column2 = Objects.requireNonNull((DataConsumer.Column)dataModel.getColumn(columnIdx));
            for (ModelIndex rowIdx : rowsIdxs.asIterable()) {
                DataConsumer.Row row = Objects.requireNonNull((DataConsumer.Row)dataModel.getRow(rowIdx));
                Object value2 = dataModel.getValueAt(rowIdx, columnIdx);
                String stringValue = formatter.getPlainValue(value2, column2, DataGridUtil.getDbms(grid), ObjectFormatter.Mode.DISPLAY);
                String title = column2.name + ":" + row.rowNum;
                Language language = grid.getContentLanguage(columnIdx);
                result.add(new Cell(stringValue, title, language));
            }
        }
        ArrayList<Cell> arrayList = result;
        if (arrayList == null) {
            CompareCellsAction.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsIdxs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CompareCellsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CompareCellsAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCells";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cell {
        private final String value;
        private final String title;
        private final Language language;

        Cell(@NotNull String value2, @NotNull String title, @NotNull Language language) {
            if (value2 == null) {
                Cell.$$$reportNull$$$0(0);
            }
            if (title == null) {
                Cell.$$$reportNull$$$0(1);
            }
            if (language == null) {
                Cell.$$$reportNull$$$0(2);
            }
            this.value = value2;
            this.title = title;
            this.language = language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "language";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/CompareCellsAction$Cell";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

