/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColumnAction
extends DumbAwareAction
implements UserDataHolder {
    final UserDataHolderBase context = new UserDataHolderBase();

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            ColumnAction.$$$reportNull$$$0(0);
        }
        return (T)this.context.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            ColumnAction.$$$reportNull$$$0(1);
        }
        this.context.putUserData(key, value2);
    }

    protected boolean isEnabled(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns, AnActionEvent e) {
        return true;
    }

    protected boolean availableInTable() {
        return false;
    }

    protected abstract void actionPerformed(DataGrid var1, List<ModelIndex<DataConsumer.Column>> var2);

    public void update(@NotNull AnActionEvent e) {
        List<ModelIndex<DataConsumer.Column>> columns;
        if (e == null) {
            ColumnAction.$$$reportNull$$$0(2);
        }
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        boolean enabled = false;
        if (dataGrid != null && !(columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable())).isEmpty()) {
            enabled = this.isEnabled(dataGrid, columns, e);
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ColumnAction.$$$reportNull$$$0(3);
        }
        if ((dataGrid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        List<ModelIndex<DataConsumer.Column>> columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
        if (columns.isEmpty()) {
            return;
        }
        this.actionPerformed(dataGrid, columns);
    }

    private static List<ModelIndex<DataConsumer.Column>> getSelectedColumns(@Nullable DataGrid dataGrid, @NotNull DataContext dataContext, boolean allowInTable) {
        if (dataContext == null) {
            ColumnAction.$$$reportNull$$$0(4);
        }
        PsiElement[] selectedPsi = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (allowInTable && dataGrid != null && dataGrid.getContextColumn().asInteger() != -1) {
            return Collections.singletonList(dataGrid.getContextColumn());
        }
        if (selectedPsi == null) {
            return allowInTable && dataGrid != null ? dataGrid.getSelectionModel().getSelectedColumns().asList() : Collections.emptyList();
        }
        ArrayList<ModelIndex<DataConsumer.Column>> result = new ArrayList<ModelIndex<DataConsumer.Column>>(selectedPsi.length);
        for (PsiElement element2 : selectedPsi) {
            DataGridPomTarget.Cell cell;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(element2);
            if (target != null && target.dataGrid == dataGrid) {
                result.add(target.column);
                continue;
            }
            DataGridPomTarget.Cell cell2 = cell = allowInTable ? DataGridPomTarget.unwrapCell(element2) : null;
            if (cell == null || cell.dataGrid != dataGrid) continue;
            cell.columns.asIterable().addAllTo(result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/ColumnAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedColumns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SortReset
    extends SortAction {
        public SortReset() {
            super(RowSortOrder.Type.UNSORTED, true);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SortReset.$$$reportNull$$$0(0);
            }
            super.update(e);
            DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
            if (dataGrid == null) {
                return;
            }
            List<ModelIndex<DataConsumer.Column>> columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
            boolean sameOrder = ContainerUtil.all(columns, column2 -> dataGrid.getSortOrder((ModelIndex<DataConsumer.Column>)column2) == this.mySortOrder);
            e.getPresentation().setEnabled(!sameOrder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ColumnAction$SortReset", "update"));
        }
    }

    public static class SortAddDesc
    extends SortAction {
        public SortAddDesc() {
            super(RowSortOrder.Type.DESC, true, DatabaseBundle.messagePointer((String)"action.Console.TableResult.ColumnSortDesc.text", (Object[])new Object[0]));
        }
    }

    public static class SortDesc
    extends SortAction {
        public SortDesc() {
            super(RowSortOrder.Type.DESC, false);
        }
    }

    public static class SortAddAsc
    extends SortAction {
        public SortAddAsc() {
            super(RowSortOrder.Type.ASC, true, DatabaseBundle.messagePointer((String)"action.Console.TableResult.ColumnSortAsc.text", (Object[])new Object[0]));
        }
    }

    public static class SortAsc
    extends SortAction {
        public SortAsc() {
            super(RowSortOrder.Type.ASC, false);
        }
    }

    private static abstract class SortAction
    extends ColumnAction {
        protected final RowSortOrder.Type mySortOrder;
        private final boolean myAdditive;
        private final Supplier<@Nls String> myMenuText;

        SortAction(@NotNull RowSortOrder.Type sortOrder, boolean additive) {
            if (sortOrder == null) {
                SortAction.$$$reportNull$$$0(0);
            }
            this(sortOrder, additive, null);
        }

        SortAction(@NotNull RowSortOrder.Type sortOrder, boolean additive, @Nullable Supplier<@Nls String> menuText) {
            if (sortOrder == null) {
                SortAction.$$$reportNull$$$0(1);
            }
            this.mySortOrder = sortOrder;
            this.myAdditive = additive;
            this.myMenuText = menuText;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean otherColumnsSorted;
            if (e == null) {
                SortAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
            if (dataGrid == null) {
                return;
            }
            List<ModelIndex<DataConsumer.Column>> columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
            boolean newOrder = !ContainerUtil.all(columns, column2 -> dataGrid.getSortOrder((ModelIndex<DataConsumer.Column>)column2) == this.mySortOrder);
            boolean bl = otherColumnsSorted = !DataGridUtil.areOnlySortedColumns(columns, dataGrid);
            if (this.myAdditive) {
                e.getPresentation().setEnabled(newOrder && otherColumnsSorted);
            } else {
                e.getPresentation().setEnabled(newOrder || otherColumnsSorted);
            }
            if (e.getPlace() == "popup" && this.myMenuText != null) {
                e.getPresentation().setText(this.myMenuText.get());
            } else {
                e.getPresentation().setText(this.getTemplateText());
            }
            this.updateShortcutText(dataGrid);
        }

        private void updateShortcutText(@NotNull DataGrid grid) {
            if (grid == null) {
                SortAction.$$$reportNull$$$0(3);
            }
            if (!this.myAdditive || this.mySortOrder == RowSortOrder.Type.UNSORTED) {
                return;
            }
            ModelIndex<DataConsumer.Column> contextColumn = grid.getContextColumn();
            if (contextColumn.asInteger() == -1 || grid.getSortOrder(contextColumn) != RowSortOrder.Type.UNSORTED || this.getShortcutSet().getShortcuts().length != 0) {
                this.putUserData(PopupListElementRenderer.CUSTOM_KEY_STROKE_TEXT, null);
                return;
            }
            String modifier = KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"ALT")) + "+";
            String mouseShortcut = this.mySortOrder == RowSortOrder.Type.ASC ? KeyMapBundle.message((String)"mouse.click.shortcut.text", (Object[])new Object[]{modifier, 1}) : KeyMapBundle.message((String)"mouse.double.click.shortcut.text", (Object[])new Object[]{modifier, 1});
            this.putUserData(PopupListElementRenderer.CUSTOM_KEY_STROKE_TEXT, mouseShortcut);
        }

        @Override
        protected boolean availableInTable() {
            return true;
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            dataGrid.sortColumns(columns, this.mySortOrder, this.myAdditive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortOrder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnAction$SortAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateShortcutText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Visibility
    extends ColumnAction {
        @Override
        protected boolean isEnabled(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns, AnActionEvent e) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            boolean single = columns.size() == 1;
            e.getPresentation().setText((toShow ? DatabaseBundle.message((String)"action.ColumnAction.Visibility.show.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ColumnAction.Visibility.hide.text", (Object[])new Object[0])) + " " + (single ? DatabaseBundle.message((String)"action.ColumnAction.Visibility.column.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ColumnAction.Visibility.columns.text", (Object[])new Object[0])));
            return true;
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            for (ModelIndex<DataConsumer.Column> c2 : columns) {
                dataGrid.setColumnEnabled(c2, toShow);
            }
        }

        private static boolean toShow(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            ModelIndex column2 = (ModelIndex)ContainerUtil.getFirstItem(columns);
            return column2 != null && !dataGrid.isColumnEnabled(column2);
        }
    }
}

