/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Comparator;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends AlignedIconWithTextAction.Group
implements GridAction,
DumbAware {
    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            Presentation p2 = e.getPresentation();
            Presentation tp = this.getTemplatePresentation();
            p2.setText(tp.getText());
            p2.setDescription(tp.getDescription());
            return;
        }
        String displayName = DataExtractorFactories.getDisplayName(dataGrid.getExtractorFactory());
        String trimmedName = StringUtil.firstLast((String)displayName, (int)12);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + " (" + trimmedName + ")");
        } else {
            e.getPresentation().setText(StringUtil.escapeMnemonics((String)trimmedName));
            e.getPresentation().setDescription(displayName);
            JComponent c2 = (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
            if (c2 != null) {
                c2.setToolTipText(displayName);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(1);
        }
        JComponent button = (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ChooseExtractor.Group");
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"settings.ChooseExtractorAction.title", (Object[])new Object[0]), actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        popup2.setAdText(this.toHtml(DatabaseBundle.message((String)"settings.extractors.PopupAd", (Object[])new Object[0])), 2);
        if (button != null) {
            popup2.showUnderneathOf((Component)button);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    @Nls
    @NotNull
    protected String toHtml(@Nls @NotNull String text2) {
        if (text2 == null) {
            ChooseExtractorAction.$$$reportNull$$$0(2);
        }
        String string = "<html>" + text2.replaceAll("\n", "<br>") + "</html>";
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GoToScriptsDirectoryAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(project != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToScriptsDirectoryAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            File scriptsDir = ExtractorScripts.getScriptsDirectory();
            if (project == null || scriptsDir == null) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
            if (virtualFile == null) {
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$GoToScriptsDirectoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SelectExtractorAction
    extends ToggleAction
    implements DumbAware {
        final DataExtractorFactory.Text factory;
        final boolean selected;

        SelectExtractorAction(@NotNull DataExtractorFactory.Text factory, boolean selected) {
            if (factory == null) {
                SelectExtractorAction.$$$reportNull$$$0(0);
            }
            super(StringUtil.escapeMnemonics((String)DataExtractorFactories.getDisplayName(factory)));
            this.factory = factory;
            this.selected = selected;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectExtractorAction.$$$reportNull$$$0(1);
            }
            return this.selected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            DataGrid dataGrid;
            if (e == null) {
                SelectExtractorAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            dataGrid.setExtractorFactory(this.factory);
            Project project = DataGridUtil.getProject(dataGrid);
            DataExtractorProperties.setCurrentExportExtractorFactory(project, this.factory);
            DataExtractorProperties.setCurrentExtractorFactory(project, this.factory);
            UIUtil.uiTraverser((Component)((Object)dataGrid.getComponent())).filter(ActionToolbarImpl.class).forEach(ActionToolbarImpl::updateActionsImmediately);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$SelectExtractorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ScriptedGroup
    extends GroupBase {
        @Override
        @NotNull
        JBIterable<AnAction> getChildrenImpl(Function<? super DataExtractorFactory.Text, ? extends AnAction> function2) {
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DatabaseBundle.message((String)"settings.extractors.ScriptExtractors", (Object[])new Object[0]))).append((Iterable)JBIterable.from(DataExtractorFactories.getScripts()).sort(Comparator.comparing(s2 -> StringUtil.toLowerCase((String)s2.getName()))).filter(DataExtractorFactory.Text.class).map(function2));
            if (jBIterable == null) {
                ScriptedGroup.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$ScriptedGroup", "getChildrenImpl"));
        }
    }

    public static final class CsvGroup
    extends GroupBase {
        @Override
        @NotNull
        JBIterable<AnAction> getChildrenImpl(Function<? super DataExtractorFactory.Text, ? extends AnAction> function2) {
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DatabaseBundle.message((String)"settings.extractors.CSV", (Object[])new Object[0]))).append((Iterable)JBIterable.from(DataExtractorFactories.getCsvFormats()).filter(DataExtractorFactory.Text.class).map(function2));
            if (jBIterable == null) {
                CsvGroup.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$CsvGroup", "getChildrenImpl"));
        }
    }

    public static class BuiltInGroup
    extends GroupBase {
        @Override
        @NotNull
        JBIterable<AnAction> getChildrenImpl(Function<? super DataExtractorFactory.Text, ? extends AnAction> function2) {
            JBIterable jBIterable = JBIterable.of((Object)Separator.create((String)DatabaseBundle.message((String)"settings.extractors.BuiltIn", (Object[])new Object[0]))).append((Iterable)JBIterable.from(DataExtractorFactories.getLegacy()).filter(DataExtractorFactory.Text.class).map(function2));
            if (jBIterable == null) {
                BuiltInGroup.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$BuiltInGroup", "getChildrenImpl"));
        }
    }

    private static abstract class GroupBase
    extends ActionGroup
    implements DumbAware {
        private GroupBase() {
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (dataGrid == null) {
                if (EMPTY_ARRAY == null) {
                    GroupBase.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            JBIterable<AnAction> children2 = this.getChildrenImpl((Function<? super DataExtractorFactory.Text, ? extends AnAction>)new Function<DataExtractorFactory.Text, AnAction>(){
                final String selectedId;
                boolean mySelectionIsSet;
                {
                    this.selectedId = dataGrid.getExtractorFactory().getId();
                }

                public AnAction fun(DataExtractorFactory.Text factory) {
                    String id = factory.getId();
                    boolean selected = !this.mySelectionIsSet && id.equals(this.selectedId);
                    this.mySelectionIsSet |= selected;
                    return new SelectExtractorAction(factory, selected);
                }
            });
            if ("EditorPopup".equals(e.getPlace())) {
                AnAction[] anActionArray = (AnAction[])children2.map(o -> o instanceof Separator ? Separator.getInstance() : o).toArray((Object[])EMPTY_ARRAY);
                if (anActionArray == null) {
                    GroupBase.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = (AnAction[])children2.toArray((Object[])EMPTY_ARRAY);
            if (anActionArray == null) {
                GroupBase.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        @NotNull
        abstract JBIterable<AnAction> getChildrenImpl(Function<? super DataExtractorFactory.Text, ? extends AnAction> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseExtractorAction$GroupBase", "getChildren"));
        }
    }
}

