/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.actions.ChangeCellTypeAction;
import com.intellij.database.run.actions.ChangeCellTypeActionGroupKt;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.UtilKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/run/actions/ChangeCellTypeActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "intellij.database.impl"})
public final class ChangeCellTypeActionGroup
extends ActionGroup
implements DumbAware,
CustomComponentAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex row = modelIndex;
        SelectionModel selectionModel2 = grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex column2 = modelIndex2;
        if (row.asInteger() == -1 || column2.asInteger() == -1) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue(gridModel, (String)"grid.getDataModel(DataAc\u2026Type.DATA_WITH_MUTATIONS)");
        GridModel model = gridModel;
        DataConsumer.Column col = (DataConsumer.Column)model.getColumn(column2);
        if (col == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
        Dbms dbms = DataGridUtil.getDbms(grid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
        Dbms dbms2 = dbms;
        GridMainPanel gridMainPanel = grid.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gridMainPanel), (String)"grid.component");
        if (gridMainPanel.getBottomView() instanceof EditMaximizedView) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setText("");
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setIcon(AllIcons.Nodes.Type);
            e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        } else if (Intrinsics.areEqual((Object)"EditorToolbar", (Object)e.getPlace())) {
            String string = ExtractorsUtil.getTypeNameForEditing(col, model.getValueAt(row, column2), dbms2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExtractorsUtil.getTypeNa\u2026lueAt(row, column), dbms)");
            String typeName = string;
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
            presentation4.setText(typeName);
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
            presentation5.setIcon((Icon)null);
            e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)false);
        } else {
            Presentation presentation6 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
            presentation6.setText(this.getTemplateText());
            Presentation presentation7 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation7, (String)"e.presentation");
            presentation7.setIcon((Icon)null);
        }
        this.setPopup(dbms2.eq(Dbms.MONGO));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JComponent jComponent = IconWithTextAction.createCustomComponentImpl((AnAction)((AnAction)this), (Presentation)presentation, (String)place);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"IconWithTextAction.creat\u2026his, presentation, place)");
        return jComponent;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026ionAid.SPEEDSEARCH, true)");
        ListPopup popup2 = listPopup;
        JComponent button = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (button != null) {
            popup2.showUnderneathOf((Component)button);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List list;
        block7: {
            Iterable it2;
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Iterable $this$sortedBy$iv;
            Object object = e;
            if (object == null || (object = (DataGrid)object.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return new AnAction[0];
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e?.getData(DATA_GRID_KEY) ?: return emptyArray()");
            Object grid = object;
            SelectionModel selectionModel = grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
            ModelIndex modelIndex = selectionModel.getLeadSelectionRow();
            Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
            ModelIndex row = modelIndex;
            SelectionModel selectionModel2 = grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
            ModelIndex modelIndex2 = selectionModel2.getLeadSelectionColumn();
            Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
            ModelIndex column2 = modelIndex2;
            Dbms dbms = DataGridUtil.getDbms((DataGrid)grid);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DataGridUtil.getDbms(grid)");
            Dbms dbms2 = dbms;
            if (!(row.isValid((Grid)grid) && column2.isValid((Grid)grid) && dbms2.eq(Dbms.MONGO))) {
                return new AnAction[0];
            }
            DomainRegistry domainRegistry = ChangeCellTypeActionGroupKt.getRegistry((DataGrid)grid);
            if (domainRegistry == null) {
                return new AnAction[0];
            }
            DomainRegistry registry = domainRegistry;
            Collection<Domain> collection = registry.getDomains();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"registry.domains");
            Iterable iterable = collection;
            boolean $i$f$sortedBy22 = false;
            boolean bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a2, T b2) {
                    boolean bl = false;
                    Domain it2 = (Domain)a2;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it2.simpleName());
                    it2 = (Domain)b2;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it2.simpleName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            $i$f$sortedBy22 = false;
            Collection $i$f$sortedBy22 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChangeCellTypeAction changeCellTypeAction;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Domain it3 = (Domain)element$iv;
                boolean bl3 = false;
                ResultView resultView = grid.getResultView();
                Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"grid.resultView");
                GridCellEditorFactoryProvider gridCellEditorFactoryProvider = resultView.getEditorFactoryProvider();
                if ((gridCellEditorFactoryProvider != null ? gridCellEditorFactoryProvider.getEditorFactory((DataGrid)grid, it3) : null) instanceof FactoryWithDomainSupport) {
                    Domain domain = it3;
                    Intrinsics.checkNotNullExpressionValue((Object)domain, (String)"it");
                    changeCellTypeAction = new ChangeCellTypeAction((DataGrid)grid, domain);
                } else {
                    changeCellTypeAction = null;
                }
                if (changeCellTypeAction == null) continue;
                ChangeCellTypeAction changeCellTypeAction2 = changeCellTypeAction;
                boolean bl4 = false;
                boolean bl5 = false;
                ChangeCellTypeAction it$iv = changeCellTypeAction2;
                boolean bl6 = false;
                destination$iv.add(it$iv);
            }
            list = (List)destination$iv;
            AnAction anAction = ActionManager.getInstance().getAction("Console.TableResult.SetNull");
            if (anAction != null) {
                iterable = anAction;
                boolean bl7 = false;
                bl = false;
                it2 = iterable;
                boolean bl8 = false;
                list.add(it2);
            }
            AnAction anAction2 = ActionManager.getInstance().getAction("Console.TableResult.ClearCell");
            if (anAction2 == null) break block7;
            iterable = anAction2;
            boolean bl9 = false;
            bl = false;
            it2 = iterable;
            boolean bl10 = false;
            list.add(it2);
        }
        return (AnAction[])UtilKt.toArray((Collection)list, (Object[])new AnAction[0]);
    }
}

