/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.event.KeyEvent;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRowAction
extends DumbAwareAction
implements GridAction {
    public AddRowAction() {
        super(AllIcons.General.Add);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        DataGrid dataGrid;
        if (e == null) {
            AddRowAction.$$$reportNull$$$0(0);
        }
        boolean visible = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && (dataGrid.isEditable() || DataGridUtil.getDatabaseTable(dataGrid) != null);
        boolean bl = enabled = visible && AddRowAction.canAddRow(dataGrid);
        if (enabled && dataGrid.isEditing()) {
            enabled = !(e.getInputEvent() instanceof KeyEvent);
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            AddRowAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            dataGrid.insertRow();
            DataGridUtil.focusDataGrid(dataGrid);
        }
    }

    public static boolean canAddRow(@Nullable DataGrid dataGrid) {
        boolean canAddRow = dataGrid != null && dataGrid.isEditable() && dataGrid.isReady() && dataGrid.getDataSupport().hasRowMutator() && dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() != 0;
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        if (!canAddRow || table == null) {
            return canAddRow;
        }
        THashMap nameToModelIndex = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        for (ModelIndex columnIdx : gridModel.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = (DataConsumer.Column)gridModel.getColumn(columnIdx);
            if (column2 == null) continue;
            nameToModelIndex.put(column2.name, columnIdx);
        }
        ModelHelper helper = DbImplUtil.getModelHelper(DataGridUtil.getDbms(dataGrid));
        return DasUtil.getColumns((DasObject)table).filter(arg_0 -> AddRowAction.lambda$canAddRow$0((Map)nameToModelIndex, dataGrid, helper, arg_0)).isEmpty();
    }

    private static /* synthetic */ boolean lambda$canAddRow$0(Map nameToModelIndex, DataGrid dataGrid, ModelHelper helper, DasColumn column2) {
        ModelIndex index2 = (ModelIndex)nameToModelIndex.get(column2.getName());
        return (index2 == null || !index2.isValid(dataGrid)) && helper.mustParticipateInInsert(column2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/run/actions/AddRowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

