/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.ScriptingSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.client.VisibleSessionClient;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ScriptingClientDataConsumer
implements DataConsumer {
    private static final String ID_RESULT = "ResultTab";
    private static final String DEFAULT_TITLE = "Result";
    private static final Key<GridInfo> GRID_INFO_KEY = Key.create((String)"GRID_INFO_KEY");
    private static final Key<TableEditorBase> FILE_EDITOR_KEY = Key.create((String)"ResultPanel.MyTableFileEditor");
    private final Alarm myAlarm;
    private final PlaceInGrid myPlace;
    private final Supplier<VirtualFile> myFileSupplier;
    private final ResultsPlaceChooser myChooser;
    private final Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> myHookUpFactory;
    private final Map<DataRequest, ResultsPlace> myResultsPlaces;
    private final Project myProject;
    private final VisibleSessionClient<?, ?> myClient;
    private int myMajorRequestCount;
    private int myMinorRequestCount;
    private int myResultSetsCount;
    private UiContent myCurrentContent;
    private final MultiMap<DataRequest, UiContent> myPreparedContentMap;

    private ScriptingClientDataConsumer(@NotNull Project project, @NotNull VisibleSessionClient<?, ?> client, @NotNull PlaceInGrid place, @NotNull Supplier<VirtualFile> fileSupplier, @NotNull Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> hookUpFactory, @NotNull ResultsPlaceChooser chooser) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(0);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(2);
        }
        if (fileSupplier == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(3);
        }
        if (hookUpFactory == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(4);
        }
        if (chooser == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(5);
        }
        this.myPreparedContentMap = MultiMap.createWeakKey();
        this.myProject = project;
        this.myClient = client;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, client);
        this.myPlace = place;
        this.myChooser = chooser;
        this.myFileSupplier = fileSupplier;
        this.myHookUpFactory = hookUpFactory;
        this.myResultsPlaces = new ConcurrentHashMap<DataRequest, ResultsPlace>();
        client.getMessageBus().addAuditor(new MyAuditor());
    }

    @NotNull
    public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor) {
        if (editor == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(6);
        }
        Collection<? extends DatabaseInEditorResults.Result> collection = this.myChooser.getEmbeddedResults(editor);
        if (collection == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<RunnerLayoutUi> getUis() {
        Collection<RunnerLayoutUi> collection = this.myChooser.getAllUis();
        if (collection == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, @NotNull ScriptingSessionClient client, @NotNull LogView<?> view2) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(9);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(10);
        }
        if (view2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(11);
        }
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vfSupplier = client::getVirtualFile;
        Function huFun = client::createGridDataHookUp;
        ToolWindowAlways chooser = new ToolWindowAlways(view2);
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, client, place, vfSupplier, (Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>>)huFun, chooser);
        client.getMessageBus().addConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(12);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull JdbcConsole client, @NotNull ResultsPlaceChooser chooser) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(13);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(14);
        }
        if (chooser == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(15);
        }
        Function hookUpFactory = client::createGridDataHookUp;
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vFileGetter = client::getVirtualFile;
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, client, place, vFileGetter, hookUpFactory, chooser){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer(new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(16);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull VisibleDatabaseSessionClient client) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(17);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(18);
        }
        ToolWindowAlways chooser = new ToolWindowAlways((LogView<?>)((DatabaseSession)client.getSession()).getView());
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, client, PlaceInGrid.center, () -> null, d2 -> {
            DatabaseSession session2 = (DatabaseSession)client.getSession();
            return GridDataHookUpManager.getInstance(project).createReadOnlyDatabaseHookUp((Disposable)d2, "", client.getDepartment(), session2);
        }, chooser){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer(new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(19);
        }
        return scriptingClientDataConsumer;
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(20);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        this.myCurrentContent = null;
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).afterLastRowAdded(context, total);
    }

    public void resetOutputTabCounter() {
        this.myMajorRequestCount = 0;
        this.myMinorRequestCount = 0;
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(21);
        }
        if (columns == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(22);
        }
        if (!this.isClientValid() || !((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        UiContent content = this.myCurrentContent = this.getPreparedContentFor((DataRequest.Context)context, (int)(++this.myResultSetsCount), (boolean)false).content;
        this.updateContentTitle(content, context, resultSetIndex, columns);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        content.ui.setBouncing(content.content, true);
        dataGrid.resetFilters();
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns(context, resultSetIndex, columns, firstRowNum);
    }

    @Override
    public void updateColumns(@NotNull DataRequest.Context context, DataConsumer.Column @NotNull [] columns) {
        DataGrid dataGrid;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(23);
        }
        if (columns == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(24);
        }
        DataGrid dataGrid2 = dataGrid = this.myCurrentContent == null ? null : ScriptingClientDataConsumer.getDataGrid(this.myCurrentContent.content);
        if (dataGrid == null) {
            return;
        }
        ScriptingClientDataConsumer.consumerFor(dataGrid).updateColumns(context, columns);
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(25);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).addRows(context, rows);
    }

    @NotNull
    private PlaceInGrid getPlaceInGrid() {
        PlaceInGrid placeInGrid = this.myPlace;
        if (placeInGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(26);
        }
        return placeInGrid;
    }

    @NlsSafe
    private String getNextTitle(int resultSetIndex) {
        StringBuilder title = new StringBuilder(DEFAULT_TITLE).append(" ").append(this.myMajorRequestCount);
        if (this.myMinorRequestCount > 1 || resultSetIndex > 1) {
            title.append("-").append(this.myMinorRequestCount);
        }
        if (resultSetIndex > 1) {
            title.append("-").append(resultSetIndex);
        }
        return title.toString();
    }

    protected boolean isClientValid() {
        return true;
    }

    private static boolean isGeneratedName(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(27);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null && content.getDisplayName().startsWith(info.originalTitle);
    }

    private void onRequestTakesTimeEDT(@NotNull DataRequest.Context context) {
        SqlTableType type;
        ConsoleDataRequest request;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(28);
        }
        ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)context.request), ConsoleDataRequest.class)) == null ? null : request.getResultSetSubquery(1);
        SqlTableType sqlTableType = type = resultSetSubQuery == null ? null : resultSetSubQuery.resultType;
        if (type == null || !((VisibleSession)this.myClient.getSession()).isValid() || !this.getPlace(context).showImmediate()) {
            return;
        }
        ContentInfo info = this.getPreparedContentFor(context, 1, true);
        UiContent content = info.content;
        if (!info.isNew) {
            return;
        }
        this.updateContentTitle(content, context, 1, null);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        List<DataConsumer.Column> columns = DbSqlUtil.createColumnsFromType(this.myProject, dialect, type, "", "", "");
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns(context, 1, (DataConsumer.Column[])ContainerUtil.toArray(columns, DataConsumer.Column[]::new), 1);
    }

    private void onRequestStartedEDT(@NotNull DataRequest.Context context) {
        int queryIndex;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(29);
        }
        this.myResultSetsCount = 0;
        if (!((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        if (!(context.request instanceof DataRequest.QueryRequest) && !(context.request instanceof DataRequest.CallRequest)) {
            return;
        }
        int n = queryIndex = context.request instanceof ConsoleDataRequest ? ((ConsoleDataRequest)context.request).queryIndex : 0;
        if (queryIndex == 0) {
            ++this.myMajorRequestCount;
            this.myMinorRequestCount = 1;
        } else {
            ++this.myMinorRequestCount;
        }
    }

    private void onRequestFinishedEDT(@NotNull DataRequest.Context context) {
        Collection contents;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(30);
        }
        if ((contents = this.myPreparedContentMap.remove((Object)context.request)) == null) {
            return;
        }
        for (UiContent content : contents) {
            if (!content.content.isValid()) continue;
            DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
            DataGridUtil.setProgressMessage(dataGrid, null);
        }
    }

    @Nullable
    private Content getValidCurrentContent() {
        return ((VisibleSession)this.myClient.getSession()).isValid() && this.myCurrentContent != null && this.myCurrentContent.content.isValid() ? this.myCurrentContent.content : null;
    }

    @NotNull
    private ContentInfo getPreparedContentFor(@NotNull DataRequest.Context context, int resultSetIndex, boolean fake) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(31);
        }
        UiContent preparedContent = resultSetIndex == 1 ? (UiContent)ContainerUtil.getFirstItem((Collection)this.myPreparedContentMap.get((Object)context.request)) : null;
        ContentInfo contentInfo = preparedContent != null && preparedContent.content.isValid() ? new ContentInfo(preparedContent, false) : this.reuseOrCreateContent(context);
        UiContent content = contentInfo.content;
        this.myPreparedContentMap.putValue((Object)context.request, (Object)content);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        if (!fake || contentInfo.isNew) {
            String title = this.getNextTitle(resultSetIndex);
            content.content.setDisplayName(title);
            content.content.setDescription(StringUtil.escapeXmlEntities((String)context.getQuery()));
        }
        DataGridUtil.setProgressMessage(dataGrid, "");
        this.getPlace(context).show(true, false).onSuccess(__ -> DbUIUtil.invokeLaterIfNeeded(() -> {
            if (content.content.isValid()) {
                content.content.getManager().setSelectedContent(content.content, false, false);
            }
        }));
        ContentInfo contentInfo2 = contentInfo;
        if (contentInfo2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(32);
        }
        return contentInfo2;
    }

    @NotNull
    private ContentInfo reuseOrCreateContent(@NotNull DataRequest.Context context) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(33);
        }
        ResultsPlace place = this.getPlace(context);
        boolean newTab = !(context.request instanceof ConsoleDataRequest) || ((ConsoleDataRequest)context.request).newTab;
        UiContent oldContent = this.findContentToReuse(place, newTab);
        UiContent resultContent = oldContent == null ? this.createNewContent(place) : oldContent;
        GridInfo gridInfo = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)resultContent.content);
        gridInfo.grid.getDataHookup().getPageModel().setPageSize(DbImplUtil.getPageSize(DataGridUtil.getDbms(gridInfo.grid)));
        gridInfo.originalTitle = DEFAULT_TITLE;
        gridInfo.major = this.myMajorRequestCount;
        gridInfo.minor = this.myMinorRequestCount;
        return new ContentInfo(resultContent, oldContent == null);
    }

    @Nullable
    private UiContent findContentToReuse(@NotNull ResultsPlace place, boolean newTab) {
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(34);
        }
        RunnerLayoutUi ui = place.getOrCreateUi();
        Content[] contents = ui.getContents();
        Content resultContent = null;
        if (!newTab) {
            GridInfo curInfo = null;
            for (Content content : contents) {
                DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
                if (dataGrid == null || content.isPinned() || !ScriptingClientDataConsumer.isGeneratedName(content)) continue;
                GridInfo info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content);
                if (info.major == this.myMajorRequestCount || curInfo != null && curInfo.major <= info.major && (curInfo.major != info.major || curInfo.minor <= info.minor)) continue;
                resultContent = content;
                curInfo = info;
            }
        }
        return resultContent == null ? null : new UiContent(ui, resultContent);
    }

    @NotNull
    private UiContent createNewContent(@NotNull ResultsPlace place) {
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(35);
        }
        RunnerLayoutUi ui = place.getOrCreateUi();
        DataGrid dataGrid = this.createTableResultPanel(ui);
        Content content = this.addContent(ui, dataGrid, place);
        place.readyToShow(content);
        GRID_INFO_KEY.set((UserDataHolder)content, (Object)new GridInfo(dataGrid));
        Disposer.register((Disposable)content, (Disposable)dataGrid);
        return new UiContent(ui, content);
    }

    private void updateContentTitle(@NotNull UiContent content, @NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @Nullable [] infos) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(36);
        }
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(37);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        if (context.request instanceof ConsoleDataRequest && this.myClient instanceof JdbcConsole) {
            String name;
            ConsoleDataRequest request = (ConsoleDataRequest)context.request;
            JdbcConsole console = (JdbcConsole)this.myClient;
            Language language = console.getLanguage();
            if (!console.isValid()) {
                return;
            }
            ConsoleDataRequest.ResultSetSubQuery subQuery = request.getResultSetSubquery(resultSetIndex);
            String query = subQuery == null ? null : subQuery.query;
            String title = subQuery == null ? null : subQuery.title;
            SqlTableType resultType = subQuery == null ? null : subQuery.resultType;
            DasTable table = DbSqlUtil.detectTable(this.myProject, language, DbSqlUtil.getDbDataSource(this.myProject, console.getDataSource()), console.getSearchPath(), query, resultType, infos == null ? Collections.emptyList() : Arrays.asList(infos));
            Objects.requireNonNull(DataGridUtil.getDatabaseHookUp(dataGrid)).setDatabaseTable(table);
            DatabaseEditorHelper.configureEditorHeader(this.myProject, this.myFileSupplier.get(), (JComponent)ObjectUtils.tryCast((Object)dataGrid.getTopComponent(), EditorHeaderComponent.class));
            if (content.content.isPinned()) {
                return;
            }
            if (title != null) {
                name = title;
            } else if (table != null) {
                name = QNameUtil.getQualifiedName((DasObject)table);
            } else if (resultType != null && resultType.getColumnCount() == 1) {
                name = resultType.getDisplayName();
                if (name.startsWith("(") && name.endsWith(")")) {
                    name = name.substring(1, name.length() - 1);
                }
            } else {
                name = null;
            }
            if (name != null) {
                String adjustedName = StringUtil.firstLast((String)name, (int)40);
                content.content.setDisplayName(new UniqueNameGenerator(Arrays.asList(content.ui.getContents()), c2 -> StringUtil.notNullize((String)(content.content == c2 ? null : c2.getDisplayName()))).generateUniqueName(adjustedName, "", "", " ", ""));
                ((GridInfo)ScriptingClientDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content.content)).originalTitle = content.content.getDisplayName();
            }
        }
    }

    protected DataGrid createTableResultPanel(final @NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(38);
        }
        Disposable hookUpParent = Disposer.newDisposable();
        final GridDataHookUp hookUp = (GridDataHookUp)this.myHookUpFactory.fun((Object)hookUpParent);
        ActionGroup popupGroup = DataGridUtil.getGridPopupActions();
        ActionGroup columnHeaderPopupGroup = DataGridUtil.getGridColumnHeaderPopupActions();
        TableResultPanel grid = new TableResultPanel(this.myProject, hookUp, popupGroup, popupGroup, columnHeaderPopupGroup, ActionGroup.EMPTY_GROUP, null, true){
            {
                super(project, dataHookUp, popupActions, gutterPopupActions, columnHeaderActions, rowHeaderActions, cellEditorFactoryProvider, useConsoleFonts);
                new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.ScriptingClientDataConsumer.escape.text", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Project project;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((project = e.getProject()) != null) {
                            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                        }
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        e.getPresentation().setEnabledAndVisible(!this.isEditing());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.registerCustomShortcutSet(27, 0, this.getResultView().getComponent());
            }

            @Override
            @NotNull
            public String getDisplayName() {
                GridMainPanel component = this.getComponent();
                Content content = ui.getContentManager().getContent((JComponent)((Object)component));
                String string = DatabaseBundle.message((String)"grid.1.choice.0.1.0", (Object[])new Object[]{content == null ? "" : content.getTabName()});
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return ScriptingClientDataConsumer.this.getOrCreateEditorWrapper(ui, this);
                }
                return super.getData(dataId);
            }

            @Override
            public boolean isReady() {
                return super.isReady() && this.isHookUpValid(this.getDataHookup());
            }

            private boolean isHookUpValid(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookup) {
                if (hookup == null) {
                    3.$$$reportNull$$$0(2);
                }
                return !(hookUp instanceof ConsoleGridDataHookUp) || ((ConsoleGridDataHookUp)hookup).isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hookup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isHookUpValid";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Disposer.register((Disposable)grid, (Disposable)hookUpParent);
        DataGridUtil.setupProgressIndicatingAuditor(grid);
        return grid;
    }

    private FileEditor getOrCreateEditorWrapper(final @NotNull RunnerLayoutUi ui, final @NotNull DataGrid resultPanel) {
        GridMainPanel dataGridComponent;
        TableEditorBase editor;
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(39);
        }
        if (resultPanel == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(40);
        }
        if ((editor = (TableEditorBase)((Object)ComponentUtil.getClientProperty((JComponent)((Object)(dataGridComponent = resultPanel.getComponent())), FILE_EDITOR_KEY))) == null) {
            editor = new TableEditorBase(this.myProject){

                @Override
                @NotNull
                public DataGrid getDataGrid() {
                    DataGrid dataGrid = resultPanel;
                    if (dataGrid == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return dataGrid;
                }

                @Override
                @NotNull
                public String getName() {
                    if (!((VisibleSession)ScriptingClientDataConsumer.this.myClient.getSession()).isValid()) {
                        String string = super.getName();
                        if (string == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    for (Content content : ui.getContents()) {
                        if (ScriptingClientDataConsumer.getDataGrid(content) != resultPanel) continue;
                        String string = content.getTabName();
                        if (string == null) {
                            4.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    String string = super.getName();
                    if (string == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/run/ScriptingClientDataConsumer$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataGrid";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ((JComponent)((Object)dataGridComponent)).putClientProperty(FILE_EDITOR_KEY, (Object)editor);
            Disposer.register((Disposable)resultPanel, (Disposable)editor);
        }
        return editor;
    }

    private Content addContent(@NotNull RunnerLayoutUi ui, @NotNull DataGrid dataGrid, @NotNull ResultsPlace place) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(41);
        }
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(42);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(43);
        }
        String contentId = "ResultTab#" + this.myMajorRequestCount + "." + this.myMinorRequestCount;
        Content content = ui.createContent(contentId, (ComponentWithActions)new ComponentWithActions.Impl((JComponent)((Object)dataGrid.getComponent())), "", DatabaseIcons.Table, dataGrid.getPreferredFocusedComponent());
        content.setCloseable(true);
        content.setPinnable(true);
        DataGridUtil.addGridHeaderComponent(dataGrid, this.myFileSupplier.get(), place.getActionGroupName());
        ui.addContent(content, 0, this.getPlaceInGrid(), false);
        return content;
    }

    @NotNull
    private static DataGrid getNotNullDataGrid(@NotNull Content content) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(44);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(45);
        }
        return dataGrid;
    }

    @Nullable
    public static DataGrid getDataGrid(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(46);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null ? info.grid : null;
    }

    @NotNull
    private static DataConsumer consumerFor(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(47);
        }
        DataBusGridDataHookUp.DataBusLoader dataBusLoader = Objects.requireNonNull(DataGridUtil.getDataBusHookUp(dataGrid)).getLoader();
        if (dataBusLoader == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(48);
        }
        return dataBusLoader;
    }

    @NotNull
    private ResultsPlace getPlace(@NotNull DataRequest.Context context) {
        ResultsPlace mySavedPlace;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(49);
        }
        ResultsPlace resultsPlace = (mySavedPlace = this.myResultsPlaces.get((Object)context.request)) == null ? this.myChooser.getDefaultPlace() : mySavedPlace;
        if (resultsPlace == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(50);
        }
        return resultsPlace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 32: 
            case 45: 
            case 48: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 32: 
            case 45: 
            case 48: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: 
            case 34: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 32: 
            case 45: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 27: 
            case 36: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedResults";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUis";
                break;
            }
            case 12: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "install";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceInGrid";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedContentFor";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullDataGrid";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "consumerFor";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEmbeddedResults";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 32: 
            case 45: 
            case 48: 
            case 50: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateColumns";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onRequestTakesTimeEDT";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStartedEDT";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinishedEDT";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedContentFor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "reuseOrCreateContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findContentToReuse";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createNewContent";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTitle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createTableResultPanel";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEditorWrapper";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullDataGrid";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "consumerFor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 32: 
            case 45: 
            case 48: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolWindowAlways
    implements ResultsPlaceChooser {
        private final ResultsPlace myPlace;
        private final LogView<?> myView;

        ToolWindowAlways(@NotNull LogView<?> view2) {
            if (view2 == null) {
                ToolWindowAlways.$$$reportNull$$$0(0);
            }
            this.myPlace = new LogViewResultsPlace(view2);
            this.myView = view2;
        }

        @Override
        @NotNull
        public ResultsPlace getDefaultPlace() {
            ResultsPlace resultsPlace = this.myPlace;
            if (resultsPlace == null) {
                ToolWindowAlways.$$$reportNull$$$0(1);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public ResultsPlace getResultsPlace(@NotNull DataRequest.Context context) {
            if (context == null) {
                ToolWindowAlways.$$$reportNull$$$0(2);
            }
            ResultsPlace resultsPlace = this.myPlace;
            if (resultsPlace == null) {
                ToolWindowAlways.$$$reportNull$$$0(3);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public Collection<RunnerLayoutUi> getAllUis() {
            List<RunnerLayoutUi> list = Collections.singletonList(this.myView.getUi());
            if (list == null) {
                ToolWindowAlways.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public Collection<DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor) {
            if (editor == null) {
                ToolWindowAlways.$$$reportNull$$$0(5);
            }
            List<DatabaseInEditorResults.Result> list = Collections.emptyList();
            if (list == null) {
                ToolWindowAlways.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$ToolWindowAlways";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$ToolWindowAlways";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultPlace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUis";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbeddedResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultsPlace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbeddedResults";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ResultsPlaceChooser {
        @NotNull
        public ResultsPlace getResultsPlace(@NotNull DataRequest.Context var1);

        @NotNull
        public Collection<RunnerLayoutUi> getAllUis();

        @NotNull
        public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor var1);

        @NotNull
        public ResultsPlace getDefaultPlace();
    }

    public static class LogViewResultsPlace
    implements ResultsPlace {
        private final LogView<?> myView;

        public LogViewResultsPlace(@NotNull LogView<?> view2) {
            if (view2 == null) {
                LogViewResultsPlace.$$$reportNull$$$0(0);
            }
            this.myView = view2;
        }

        @Override
        @NotNull
        public RunnerLayoutUi getOrCreateUi() {
            RunnerLayoutUi runnerLayoutUi = this.myView.getUi();
            if (runnerLayoutUi == null) {
                LogViewResultsPlace.$$$reportNull$$$0(1);
            }
            return runnerLayoutUi;
        }

        @Override
        @NotNull
        public Promise<Void> show(boolean activate, boolean focus) {
            Promise<Void> promise = this.myView.show(activate, focus);
            if (promise == null) {
                LogViewResultsPlace.$$$reportNull$$$0(2);
            }
            return promise;
        }

        @Override
        public void readyToShow(@NotNull Content content) {
            if (content == null) {
                LogViewResultsPlace.$$$reportNull$$$0(3);
            }
        }

        @Override
        public boolean showImmediate() {
            return true;
        }

        @Override
        public void requestFinished() {
        }

        @Override
        @NotNull
        public String getActionGroupName() {
            return "Console.TableResult.Group";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$LogViewResultsPlace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$LogViewResultsPlace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateUi";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "show";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readyToShow";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ResultsPlace {
        @NotNull
        public RunnerLayoutUi getOrCreateUi();

        @NotNull
        public Promise<Void> show(boolean var1, boolean var2);

        @NotNull
        public String getActionGroupName();

        public void readyToShow(@NotNull Content var1);

        public boolean showImmediate();

        public void requestFinished();
    }

    private static class PreventingExtraResultsConsumer
    extends DataConsumer.Wrapper {
        PreventingExtraResultsConsumer(@NotNull DataConsumer dataConsumer) {
            if (dataConsumer == null) {
                PreventingExtraResultsConsumer.$$$reportNull$$$0(0);
            }
            super(dataConsumer);
        }

        @Override
        public boolean accepts(DataRequest.Owner owner) {
            return !(owner instanceof ConsoleGridDataHookUp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConsumer", "com/intellij/database/run/ScriptingClientDataConsumer$PreventingExtraResultsConsumer", "<init>"));
        }
    }

    private class MyAuditor
    extends DataAuditor.Adapter {
        private final Set<DataRequest> myPendingRequests = ContainerUtil.newConcurrentSet();

        private MyAuditor() {
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(0);
            }
            super.requestStarted(context);
            ReadAction.run(() -> ScriptingClientDataConsumer.this.myResultsPlaces.put(context.request, ScriptingClientDataConsumer.this.myChooser.getResultsPlace(context)));
            if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                return;
            }
            this.myPendingRequests.add(context.request);
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestStartedEDT(context);
                ScriptingClientDataConsumer.this.myAlarm.addRequest(() -> {
                    if (ScriptingClientDataConsumer.this.myAlarm.isDisposed() || !this.myPendingRequests.contains((Object)context.request)) {
                        return;
                    }
                    ScriptingClientDataConsumer.this.onRequestTakesTimeEDT(context);
                }, 1000L, ModalityState.any());
            });
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index2) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(1);
            }
            this.myPendingRequests.remove((Object)context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(2);
            }
            this.myPendingRequests.remove((Object)context.request);
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(3);
            }
            this.myPendingRequests.remove((Object)context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ScriptingClientDataConsumer.this.getPlace(context).requestFinished();
                ScriptingClientDataConsumer.this.myResultsPlaces.remove((Object)context.request);
                if (!((VisibleSession)ScriptingClientDataConsumer.this.myClient.getSession()).isValid()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestFinishedEDT(context);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$MyAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UiContent {
        final RunnerLayoutUi ui;
        final Content content;

        private UiContent(@NotNull RunnerLayoutUi ui, @NotNull Content content) {
            if (ui == null) {
                UiContent.$$$reportNull$$$0(0);
            }
            if (content == null) {
                UiContent.$$$reportNull$$$0(1);
            }
            this.ui = ui;
            this.content = content;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ScriptingClientDataConsumer$UiContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentInfo {
        final UiContent content;
        final boolean isNew;

        ContentInfo(@NotNull UiContent content, boolean aNew) {
            if (content == null) {
                ContentInfo.$$$reportNull$$$0(0);
            }
            this.content = content;
            this.isNew = aNew;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/run/ScriptingClientDataConsumer$ContentInfo", "<init>"));
        }
    }

    private static class GridInfo {
        final DataGrid grid;
        String originalTitle;
        int major;
        int minor;

        GridInfo(DataGrid grid) {
            this.grid = grid;
        }
    }
}

