/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ParametersHolder
implements Disposable {
    private final Alarm myUpdateAlarm;
    private final Project myProject;
    private final ScriptModel.PStorage myStorage;
    private final Helper myHelper;
    private final ParametersPanel myParamPanel;
    private final VisibilityController myVisibilityController;

    public ParametersHolder(@NotNull Project project, @NotNull ScriptModel.PStorage storage, @NotNull ScriptModel<?> scriptModel, @NotNull Helper helper, @NotNull VisibilityController controller) {
        if (project == null) {
            ParametersHolder.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            ParametersHolder.$$$reportNull$$$0(1);
        }
        if (scriptModel == null) {
            ParametersHolder.$$$reportNull$$$0(2);
        }
        if (helper == null) {
            ParametersHolder.$$$reportNull$$$0(3);
        }
        if (controller == null) {
            ParametersHolder.$$$reportNull$$$0(4);
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myProject = project;
        this.myStorage = storage;
        this.myHelper = helper;
        this.myParamPanel = new MyParametersPanel(project, this, scriptModel, this.myStorage, helper);
        this.myUpdateAlarm.setActivationComponent((JComponent)this.myParamPanel);
        this.myVisibilityController = controller;
    }

    private boolean isToggled() {
        return this.myVisibilityController != null && this.myVisibilityController.isToggled();
    }

    public boolean isEnabled() {
        return this.myVisibilityController != null;
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> model) {
        if (model == null) {
            ParametersHolder.$$$reportNull$$$0(5);
        }
        this.myParamPanel.commit();
        return ParametersHolder.beforeExecuteQueries(this.myHelper.getVirtualFile(), this.myStorage, this.myProject, model);
    }

    public static boolean beforeExecuteQueries(@NotNull VirtualFile file, @NotNull ScriptModel.PStorage storage, @NotNull Project project, @NotNull ScriptModel<?> model) {
        boolean forceShowParams;
        if (file == null) {
            ParametersHolder.$$$reportNull$$$0(6);
        }
        if (storage == null) {
            ParametersHolder.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ParametersHolder.$$$reportNull$$$0(8);
        }
        if (model == null) {
            ParametersHolder.$$$reportNull$$$0(9);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (model.statements().isEmpty()) {
            return false;
        }
        boolean bl = forceShowParams = !model.getVirtualFile().equals(file) || DatabaseSettings.getSettings().alwaysReviewParameters;
        return (!forceShowParams || model.parameters().isEmpty()) && !ParametersPanel.hasUnassignedParameters(model, storage) || ParametersPanel.ensureAllParametersAreSet(project, model, storage);
    }

    public ParametersPanel getParamPanel() {
        return this.myParamPanel;
    }

    public ScriptModel.PStorage getPStorage() {
        return this.myStorage;
    }

    public void dispose() {
    }

    public AnAction attachToEditor() {
        this.myHelper.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ParametersHolder.this.myUpdateAlarm.cancelAllRequests();
                ParametersHolder.this.myUpdateAlarm.addComponentRequest(() -> {
                    ParametersHolder.this.myParamPanel.onModelUpdated();
                    ParametersHolder.this.myParamPanel.caretPositionChanged(ParametersHolder.this.myHelper.getEditor().getCaretModel().getOffset());
                }, 300);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ParametersHolder$1", "documentChanged"));
            }
        }, (Disposable)this);
        EditParameterAction editParameterAction = new EditParameterAction(this.myHelper);
        editParameterAction.getTemplatePresentation().setVisible(false);
        editParameterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this.myParamPanel);
        return editParameterAction;
    }

    @NotNull
    public AnAction initParameterView() {
        AnAction action2 = this.attachToEditor();
        JComponent shortcutTarget = this.myHelper.getEditor().getComponent();
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), shortcutTarget);
        return new ToggleParametersPanelAction();
    }

    @NotNull
    public Promise<Void> toggleParamContent(boolean state) {
        if (this.myVisibilityController == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ParametersHolder.$$$reportNull$$$0(10);
            }
            return promise;
        }
        if (state == this.isToggled()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                ParametersHolder.$$$reportNull$$$0(11);
            }
            return promise;
        }
        if (state) {
            this.myParamPanel.onModelUpdated();
            Promise<Void> promise = this.myVisibilityController.show(this.myProject, this);
            if (promise == null) {
                ParametersHolder.$$$reportNull$$$0(12);
            }
            return promise;
        }
        this.myVisibilityController.hide();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ParametersHolder.$$$reportNull$$$0(13);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ParametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ParametersHolder";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleParamContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Helper {
        @NotNull
        public Document getDocument();

        @NotNull
        public Editor getEditor();

        @NotNull
        public VirtualFile getVirtualFile();

        public boolean shouldOpenFileOnEditParameters();
    }

    public static interface VisibilityController {
        @NotNull
        public Promise<Void> show(@NotNull Project var1, @NotNull ParametersHolder var2);

        public void hide();

        public boolean isToggled();
    }

    private static class MyParametersPanel
    extends ParametersPanel {
        private final List<RangeHighlighter> myHighlighters;
        private final Project myProject;
        private final Helper myHelper;

        MyParametersPanel(@NotNull Project project, @NotNull ParametersHolder holder, @NotNull ScriptModel<?> model, @NotNull ScriptModel.PStorage storage, @NotNull Helper helper) {
            if (project == null) {
                MyParametersPanel.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                MyParametersPanel.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyParametersPanel.$$$reportNull$$$0(2);
            }
            if (storage == null) {
                MyParametersPanel.$$$reportNull$$$0(3);
            }
            if (helper == null) {
                MyParametersPanel.$$$reportNull$$$0(4);
            }
            super(project, model, storage, holder);
            this.myHelper = helper;
            this.myProject = project;
            this.myHighlighters = new ArrayList<RangeHighlighter>();
        }

        @Override
        protected void selectRanges(Iterable<TextRange> ranges) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            EditorFactory.getInstance().editors(this.myHelper.getDocument(), this.myProject).forEach(editor -> {
                editor.getSelectionModel().removeSelection();
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlightManager.removeSegmentHighlighter(editor, highlighter);
                }
            });
            this.myHighlighters.clear();
            TextRange first2 = (TextRange)Iterables.getFirst(ranges, null);
            if (first2 == null) {
                return;
            }
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, this.myHelper.getVirtualFile(), first2.getStartOffset());
            EditorFactory.getInstance().editors(this.myHelper.getDocument(), this.myProject).forEach(editor -> {
                for (TextRange range : ranges) {
                    highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), DatabaseColors.CONSOLE_SELECTED_PARAMETER, true, this.myHighlighters);
                }
                descriptor2.navigateIn(editor);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ParametersHolder$MyParametersPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleParametersPanelAction
    extends ToggleAction {
        ToggleParametersPanelAction() {
            super(DatabaseBundle.messagePointer((String)"action.ToggleParametersPanelAction.text", (Object[])new Object[0]), PlatformIcons.PARAMETER_ICON);
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleParametersPanelAction.$$$reportNull$$$0(0);
            }
            return ParametersHolder.this.isToggled();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleParametersPanelAction.$$$reportNull$$$0(1);
            }
            ParametersHolder.this.toggleParamContent(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/run/ParametersHolder$ToggleParametersPanelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditParameterAction
    extends DumbAwareAction {
        private final Helper myHelper;

        EditParameterAction(Helper helper) {
            if (helper == null) {
                EditParameterAction.$$$reportNull$$$0(0);
            }
            this.myHelper = helper;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditParameterAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditParameterAction.$$$reportNull$$$0(2);
            }
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            Editor currentEditor = this.myHelper.getEditor();
            if (owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent())) {
                int offset = currentEditor.getCaretModel().getOffset();
                ParametersHolder.this.toggleParamContent(true).onSuccess(v -> ParametersHolder.this.myParamPanel.tryEditParameterValue(offset));
                return;
            }
            if (currentEditor.getContentComponent().isShowing()) {
                IdeFocusManager.getInstance((Project)ParametersHolder.this.myProject).requestFocus((Component)currentEditor.getContentComponent(), true);
                return;
            }
            if (!this.myHelper.shouldOpenFileOnEditParameters()) {
                return;
            }
            int offset = currentEditor.getCaretModel().getOffset();
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(ParametersHolder.this.myProject, this.myHelper.getVirtualFile(), offset);
            FileEditorManager.getInstance((Project)ParametersHolder.this.myProject).openTextEditor(descriptor2, true);
        }

        private boolean isEnabled() {
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            Editor currentEditor = this.myHelper.getEditor();
            boolean isEditorIsFocusOwner = owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent());
            int caretOffset = currentEditor.getCaretModel().getOffset();
            return !isEditorIsFocusOwner || ParametersHolder.this.myParamPanel.findParameterAtOffset(caretOffset) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ParametersHolder$EditParameterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

