/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DatabaseMoveCaretDownHandler
extends EditorActionHandler.ForEachCaret {
    private final EditorActionHandler myOriginalHandler;

    public DatabaseMoveCaretDownHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            DatabaseMoveCaretDownHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            DatabaseMoveCaretDownHandler.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(editor.getProject(), vFile);
        int cOffset = caret.getOffset();
        if (console == null || cOffset != document.getTextLength()) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        Collection<? extends DatabaseInEditorResults.Result> results2 = console.getEmbeddedResults(editor);
        for (DatabaseInEditorResults.Result result : results2) {
            int offset = result.getOffset();
            if (offset != document.getTextLength()) continue;
            result.saveBeforeChanges();
            ScrollingModelEx scrollingModel = (ScrollingModelEx)ObjectUtils.tryCast((Object)editor.getScrollingModel(), ScrollingModelEx.class);
            if (scrollingModel != null) {
                scrollingModel.accumulateViewportChanges();
            }
            try {
                ApplicationManager.getApplication().runWriteAction(() -> EnterAction.insertNewLineAtCaret((Editor)editor));
            }
            finally {
                result.restoreAfterChanges();
                EditorModificationUtil.scrollToCaret((Editor)editor);
                if (scrollingModel != null) {
                    scrollingModel.flushViewportChanges();
                }
            }
            return;
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            DatabaseMoveCaretDownHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            DatabaseMoveCaretDownHandler.$$$reportNull$$$0(3);
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/DatabaseMoveCaretDownHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

