/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGoToSymbolContributor
implements GotoClassContributor,
ChooseByNameContributorEx,
DumbAware {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        Project project;
        if (processor == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        if ((project = scope.getProject()) == null) {
            return;
        }
        this.getRoots(project, scope).flatMap(o -> o.getNameIndex().getAllNames()).processEach(processor);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        GlobalSearchScope scope;
        Project project;
        if (name == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(4);
        }
        if ((project = (scope = parameters.getSearchScope()).getProject()) == null) {
            return;
        }
        for (DbDataSource dataSource2 : this.getRoots(project, scope)) {
            JBIterable objects2 = this.filterObjects(dataSource2.getNameIndex().getObjectsByName(name));
            Condition<DasObject> objectFilter = DbImplUtilCore.buildFilter((DasDataSource)dataSource2);
            if (objectFilter != null) {
                objects2 = objects2.filter(objectFilter);
            }
            TreePattern introspectionScope = DbImplUtilCore.getIntrospectionScope((DasDataSource)dataSource2);
            DbImplUtil.processCandidates((JBIterable<DasObject>)objects2, (Condition<? super DasObject>)((Condition)o -> DbImplUtilCore.isExpandable(o, introspectionScope)), (BooleanFunction<? super DasObject>)((BooleanFunction)o -> {
                NavigationItem item = this.getNavigationItem(dataSource2, (DasObject)o);
                return item == null || processor.process((Object)item);
            }));
        }
    }

    @Nullable
    protected NavigationItem getNavigationItem(DbDataSource dataSource2, DasObject o) {
        DbElement element2 = DbImplUtil.findElement(dataSource2, o);
        return element2 == null ? null : DbNavigationUtils.createToSourceNavigatable(element2);
    }

    @NotNull
    public JBIterable<DasObject> filterObjects(@NotNull Collection<DasObject> objects2) {
        if (objects2 == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.from(objects2).filter(o -> DbGoToSymbolContributor.isVisible(o));
        if (jBIterable == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static boolean isVisible(DasObject o) {
        BasicElement e = (BasicElement)ObjectUtils.tryCast((Object)o, BasicElement.class);
        if (e == null || e instanceof BasicNamespace) {
            return true;
        }
        BasicSchema sc = e.getSchema();
        BasicDatabase db = (sc == null ? e : sc).getDatabase();
        return !(sc != null && sc.isSubstituted() || db != null && db.isSubstituted());
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        DbElement element2 = DbNavigationUtils.extractDbElement((Navigatable)item);
        if (element2 == null) {
            return null;
        }
        DbDataSource dataSource2 = element2.getDataSource();
        String groupName = ((AbstractDataSource)dataSource2.getDelegate()).getGroupName();
        return (String)(groupName == null ? "" : groupName + "/") + dataSource2.getName() + "/" + QNameUtil.getQualifiedName(element2);
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "/";
    }

    protected JBIterable<DbDataSource> getRoots(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            DbGoToSymbolContributor.$$$reportNull$$$0(8);
        }
        JBIterable result = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources());
        return result.filter(o -> scope.contains(o.getVirtualFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbGoToSymbolContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterObjects";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

