/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFacadeCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbElementImpl<D, P extends DbElement>
extends FakePsiElement
implements DbElement,
PsiMetaOwner,
PsiPresentableMetaData {
    private static final Logger LOG = Logger.getInstance(DbElementImpl.class);
    public static final int WEIGHT_BASE = 10000;
    public static final int WEIGHT_INC = 1000;
    protected final P myParent;
    @NotNull
    protected final D myDelegate;
    protected volatile long myTransactionalVersion;
    protected static final String ASYNC_DOC_CUT = "<!-- async-doc-cut -->";

    public DbElementImpl(P parent2, @NotNull D delegate) {
        if (delegate == null) {
            DbElementImpl.$$$reportNull$$$0(0);
        }
        this.myTransactionalVersion = -1L;
        this.myParent = parent2;
        this.myDelegate = delegate;
    }

    @NotNull
    public D getDelegate() {
        D d2 = this.myDelegate;
        if (d2 == null) {
            DbElementImpl.$$$reportNull$$$0(1);
        }
        return d2;
    }

    @Nullable
    public P getDasParent() {
        return this.myParent;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getName() : DasUtil.NO_NAME;
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isQuoted() {
        return DbSqlUtilCore.isQuoted((DasObject)this);
    }

    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            DbElementImpl.$$$reportNull$$$0(3);
        }
        return sqlLanguage;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public short getPosition() {
        return this.myDelegate instanceof DasPositioned ? ((DasPositioned)this.myDelegate).getPosition() : (short)0;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = DbImplUtilCore.getDbms(this);
        if (dbms == null) {
            DbElementImpl.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    public void init(PsiElement element2) {
    }

    @NotNull
    public Project getProject() {
        Project project = ((DbElement)Objects.requireNonNull(this.getDasParent())).getProject();
        if (project == null) {
            DbElementImpl.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public boolean isWritable() {
        D delegate = this.getDelegate();
        if (delegate instanceof PsiElement) {
            return ((PsiElement)delegate).isWritable();
        }
        DatabaseSystem dataSource2 = this.getDataSource().getDelegate();
        return !(dataSource2 instanceof DatabaseConnectionPoint) || !((DatabaseConnectionPoint)dataSource2).isReadOnly();
    }

    public String getLocationString() {
        DbElement parent2;
        ObjectKind type = this.getKind();
        DbElement dbElement = parent2 = type != ObjectKind.NONE ? this.getParent() : null;
        if (parent2 != null) {
            return StringUtil.notNullize((String)StringUtil.nullize((String)QNameUtil.getQualifiedName(parent2)), (String)DbPresentation.getPresentableName((DasObject)parent2, true)) + " [" + this.getDataSource().getName() + "]";
        }
        return super.getLocationString();
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getVirtualFile() {
        return DatabaseElementVirtualFileImpl.findFile(this, !DbImplUtilCore.isDataTable(this.getKind()));
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(6);
        }
        return true;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
    }

    @NotNull
    public JBIterable<DbElement> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable jBIterable = this.getDataSource().findChildren(this).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public String getText() {
        return DatabaseEditorHelper.generateDefinition(this, new StringBuilder()).toString();
    }

    @NotNull
    public ObjectKind getKind() {
        D delegate = this.getDelegate();
        if (delegate instanceof DasObject) {
            ObjectKind objectKind = ((DasObject)delegate).getKind();
            if (objectKind == null) {
                DbElementImpl.$$$reportNull$$$0(8);
            }
            return objectKind;
        }
        throw new AssertionError((Object)(((Object)((Object)this)).getClass() + ":" + delegate));
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Nullable
    public Icon getBaseIcon() {
        return DbPresentationCore.getIcon(DbImplUtilCore.getDbms(this), this.getKind());
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return DbPresentationCore.getIcon((DasObject)this);
    }

    public boolean isCaseSensitive() {
        return DbElementImpl.isCaseSensitive(this);
    }

    @Nullable
    public String getComment() {
        return this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getComment() : null;
    }

    public DbElement getParent() {
        return this.getDasParent();
    }

    @NotNull
    public String getTypeName() {
        String string = DbPresentationCore.getPresentableName(this.getKind(), DbImplUtilCore.getDbms(this));
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement @NotNull [] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            DbElementImpl.$$$reportNull$$$0(10);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlElement sqlElement;
        if (name == null) {
            DbElementImpl.$$$reportNull$$$0(11);
        }
        if ((sqlElement = (SqlElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(this), SqlElement.class)) instanceof PsiNamedElement) {
            ((PsiNamedElement)sqlElement).setName(name);
        } else {
            D delegate = this.getDelegate();
            if (delegate instanceof PsiNamedElement) {
                ((PsiNamedElement)delegate).setName(name);
            }
        }
        return this;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            DbElementImpl.$$$reportNull$$$0(12);
        }
        for (DbElement element2 : this.getDasChildren(null)) {
            element2.accept(visitor2);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        D delegate = this.getDelegate();
        return !(delegate instanceof Navigatable) || ((Navigatable)delegate).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        DbNavigationUtils.navigateToSource(this, requestFocus);
    }

    @NotNull
    public StringBuilder getDocumentation(boolean hover) {
        StringBuilder stringBuilder = this.createDocHeaderColored().cast(StringBuilder.class);
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(13);
        }
        return stringBuilder;
    }

    @NotNull
    protected ColoredDdlBuilder createDocHeaderColored() {
        ColoredDdlBuilder colored = this.createDocBuilder(this.createDocHeaderDefault());
        String comment = this.getComment();
        if (StringUtil.isNotEmpty((String)comment)) {
            colored.plain("<br>").plain("-- " + comment, DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        ColoredDdlBuilder coloredDdlBuilder = colored;
        if (coloredDdlBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(14);
        }
        return coloredDdlBuilder;
    }

    @NotNull
    protected StringBuilder createDocHeaderDefault() {
        Pair<String, String> pair;
        ArrayList<DbElementImpl> elements = new ArrayList<DbElementImpl>();
        for (DbElementImpl cur2 = this; cur2 != null; cur2 = cur2.getParent()) {
            String name = cur2.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            elements.add(0, cur2);
        }
        HtmlBuilder builder = new HtmlBuilder();
        for (DbElement dbElement : elements) {
            builder.append((HtmlChunk)HtmlChunk.text((String)(StringUtil.capitalizeWords((String)dbElement.getTypeName(), (boolean)true) + ":")).bold()).append(" ").append(dbElement.getName()).br();
        }
        D delegate = this.getDelegate();
        Pair<String, String> pair2 = pair = delegate instanceof BasicElement ? ModelFacadeCore.forDbms(this.getDataSource().getDbms()).getModelHelper().getDocumentationLink((BasicElement)delegate) : null;
        if (pair != null) {
            HtmlChunk.Element linkLine = new HtmlBuilder().append(DatabaseBundle.message((String)"documentation", (Object[])new Object[0])).append(": ").append((HtmlChunk)HtmlChunk.link((String)((String)pair.second), (String)((String)pair.first)).wrapWith("tt")).wrapWith("b");
            builder.br().append((HtmlChunk)linkLine).br();
        }
        StringBuilder stringBuilder = new StringBuilder(DisplayHtmlValuesExtractor.getHeader()).append(builder);
        if (stringBuilder == null) {
            DbElementImpl.$$$reportNull$$$0(15);
        }
        return stringBuilder;
    }

    protected void scheduleAsyncDocumentationUpdate(@NotNull CharSequence prefix, @NotNull AsyncDocGetter docGetter) {
        if (prefix == null) {
            DbElementImpl.$$$reportNull$$$0(16);
        }
        if (docGetter == null) {
            DbElementImpl.$$$reportNull$$$0(17);
        }
        String connectingToDatabasePhrase = DatabaseBundle.message((String)"connecting.to.database.ellipsis", (Object[])new Object[0]);
        String progressMessage = "<br><small>" + connectingToDatabasePhrase + "</small>";
        QuickDocUtil.updateQuickDocAsync((PsiElement)this, (CharSequence)prefix, out -> {
            block5: {
                try {
                    CharOut charOut = CharOut.Util.newSink((Consumer<? super CharSequence>)out);
                    docGetter.beforeGet(charOut);
                    if (!DatabaseSettings.getSettings().loadSlowDocumentation) {
                        return;
                    }
                    if (!DbImplUtil.canConnectTo(this)) {
                        return;
                    }
                    out.consume((Object)ASYNC_DOC_CUT);
                    out.consume((Object)progressMessage);
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)ASYNC_DOC_CUT);
                    TimeoutUtil.sleep((long)1000L);
                    ConnectionProvider.runWithProvider(this, DGDepartment.QUICK_DOCUMENTATION, (ThrowableConsumer<ConnectionProvider, Exception>)((ThrowableConsumer)provider -> docGetter.get(charOut, (ConnectionProvider)provider)));
                }
                catch (ProcessCanceledException e) {
                    String connectionCanceledPhrase = DatabaseBundle.message((String)"connection.canceled", (Object[])new Object[0]);
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)progressMessage);
                    out.consume((Object)("<br><b>" + connectionCanceledPhrase + "</b>"));
                }
                catch (Exception e) {
                    String connectionFailedPhrase = DatabaseBundle.message((String)"connection.failed", (Object[])new Object[0]);
                    out.consume(QuickDocUtil.CUT_AT_CMD);
                    out.consume((Object)progressMessage);
                    out.consume((Object)DbImplUtil.exceptionToHtml(e, "<br><b>" + connectionFailedPhrase + "</b>", new StringBuilder()));
                    if (e instanceof SQLException || e instanceof IOException) break block5;
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    protected boolean appendDefinition(@NotNull StringBuilder sb) {
        String text2;
        if (sb == null) {
            DbElementImpl.$$$reportNull$$$0(18);
        }
        if ((text2 = DbImplUtil.loadDefinitionFromStorage(this)) == null && DatabaseEditorHelper.isDefinitionAvailable(this)) {
            StringBuilder tmp2 = new StringBuilder();
            DatabaseEditorHelper.generateDefinition(this, tmp2);
            if (tmp2.length() == 0) {
                return false;
            }
            tmp2.insert(0, "-- auto-generated definition\n");
            text2 = tmp2.toString();
        }
        if (text2 != null) {
            sb.append("<br><code><pre>");
            sb.append(this.sql2Html(text2));
            while (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("</pre></code>");
            return true;
        }
        return false;
    }

    protected ColoredDdlBuilder createDocBuilder(StringBuilder sb) {
        ColoredDdlBuilder colored = new ColoredDdlBuilder(sb);
        colored.configureFor(this);
        return colored;
    }

    protected void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this);
    }

    public boolean isValid() {
        return this.getDataSource().isValidImpl(this);
    }

    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl o = (DbDataSourceImpl)((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbDataSourceImpl.class).first());
        if (o != null) {
            DbDataSourceImpl dbDataSourceImpl = o;
            if (dbDataSourceImpl == null) {
                DbElementImpl.$$$reportNull$$$0(19);
            }
            return dbDataSourceImpl;
        }
        throw new AssertionError((Object)(this.getTypeName() + ": no datasource"));
    }

    public int getWeight() {
        ObjectKind kind = this.getKind();
        if (kind == ObjectKind.TABLE) {
            return 10000;
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return 11000;
        }
        if (kind == ObjectKind.VIEW) {
            return 12000;
        }
        if (kind == ObjectKind.SEQUENCE) {
            return 13000;
        }
        if (kind == ObjectKind.TRIGGER) {
            return 14000;
        }
        if (kind == ObjectKind.ROUTINE) {
            return 16000;
        }
        if (kind == ObjectKind.PACKAGE) {
            return 17000;
        }
        return 10000;
    }

    @NotNull
    protected String sql2Html(CharSequence s2) {
        String string = DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtilCore.getSqlDialect(this), s2);
        if (string == null) {
            DbElementImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static Processor<DbElement> newDeclarationProcessor(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(21);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(22);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(23);
        }
        Processor processor2 = element2 -> {
            if (lastParent == element2) {
                return true;
            }
            return processor.execute((DasSymbol)element2, state);
        };
        if (processor2 == null) {
            DbElementImpl.$$$reportNull$$$0(24);
        }
        return processor2;
    }

    @NotNull
    public Processor<DbElement> createDeclarationProcessor(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(25);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(26);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(27);
        }
        return DbElementImpl.newDeclarationProcessor(processor, state, lastParent, place);
    }

    public final boolean processDeclarations(@NotNull DasScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        JBIterable<DbDataSource> parents2;
        if (processor == null) {
            DbElementImpl.$$$reportNull$$$0(28);
        }
        if (state == null) {
            DbElementImpl.$$$reportNull$$$0(29);
        }
        if (place == null) {
            DbElementImpl.$$$reportNull$$$0(30);
        }
        Processor<DbElement> p2 = this.createDeclarationProcessor(processor, state, lastParent, place);
        JBIterable elements = JBIterable.empty();
        DasObject obj = (DasObject)ObjectUtils.tryCast(this.getDelegate(), DasObject.class);
        if (obj == null || DbImplUtil.isExpandable(obj, DbImplUtil.getIntrospectionScope((DasDataSource)this.getDataSource()))) {
            elements = elements.append(this.getDasChildren(null));
        }
        if (this instanceof DbNamespaceImpl && !(parents2 = DbElementImpl.getParentDataSources(this.getDataSource())).isEmpty()) {
            ObjectPath path = ObjectPaths.of((DasObject)this);
            JBIterable additional = parents2.flatten(ds -> DbSqlUtil.findObjects(ds, path).flatten(ns -> ns.getDasChildren(null)).map(o -> DbImplUtil.findElement(ds, o)));
            elements = elements.append((Iterable)additional).filter((Condition)new DbImplUtil.HashingStrategyUnique<DbElement>(){

                public int computeHashCode(DbElement object) {
                    return object == null ? 0 : object.getName().hashCode() + 31 * object.getKind().hashCode();
                }

                public boolean equals(DbElement o1, DbElement o2) {
                    if (o1 == o2 || o1 == null || o2 == null) {
                        return o1 == o2;
                    }
                    return o1.getName().equals(o2.getName()) || o1.getKind() == o2.getKind();
                }
            });
        }
        return ContainerUtil.process((Iterable)elements, p2);
    }

    @NotNull
    private static JBIterable<DbDataSource> getParentDataSources(@NotNull DbDataSource dataSource2) {
        if (dataSource2 == null) {
            DbElementImpl.$$$reportNull$$$0(31);
        }
        if (!(dataSource2.getDelegate() instanceof SqlDataSource)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbElementImpl.$$$reportNull$$$0(32);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.generate((Object)dataSource2, o -> {
            DatabaseSystem delegate = o.getDelegate();
            return delegate instanceof SqlDataSource ? ((SqlDataSource)delegate).getParentDataSource() : null;
        });
        if (jBIterable == null) {
            DbElementImpl.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    public String toString() {
        ObjectKind kind = this.getKind();
        String s2 = kind == ObjectKind.SCHEMA ? QNameUtil.getQualifiedName(this) : (this instanceof DbTableChild ? this.getText() : this.getName());
        return s2 + ": " + kind;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private static boolean isCaseSensitive(DbElement element2) {
        if (!(element2 instanceof DasSchemaChild) && !(element2 instanceof DasColumn)) {
            return false;
        }
        return DbUtil.isCaseSensitive((String)element2.getName(), (DbElement)element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 6: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docGetter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 22: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderColored";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderDefault";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeclarationProcessor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 33: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncDocumentationUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendDefinition";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newDeclarationProcessor";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationProcessor";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentDataSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface AsyncDocGetter {
        public void get(@NotNull CharOut var1, @NotNull ConnectionProvider var2) throws Exception;

        default public void beforeGet(@NotNull CharOut charOut) {
            if (charOut == null) {
                AsyncDocGetter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charOut", "com/intellij/database/psi/DbElementImpl$AsyncDocGetter", "beforeGet"));
        }
    }
}

