/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.BasicDataSourceManager;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbClusterImpl;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbCustomTypeImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbForeignKeyImpl;
import com.intellij.database.psi.DbIndexImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbObjectAttributeImpl;
import com.intellij.database.psi.DbPackageImpl;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutineImpl;
import com.intellij.database.psi.DbSchemaChildImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.DbTableKeyImpl;
import com.intellij.database.psi.DbTableTypeImpl;
import com.intellij.database.psi.DbTriggerImpl;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.psi.ModelNameIndexImpl;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDataSourceImpl
extends DbElementImpl<DasDataSource, DbElement>
implements DbDataSource {
    private static final Key<Object> LAST_DS_INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");
    private static final Pattern DOC_PATTERN = Pattern.compile("(?m)(^[^:]+:)");
    private static final Pattern NEW_LINE = Pattern.compile("\n");
    private final Project myProject;
    private final BasicDataSourceManager<DasDataSource> myManager;
    private final ClearableLazyValue<Pair<DatabaseDialectEx, Language>> myDialects;
    private final Map<DasObject, DbElement> myElements;
    private final Map<ObjectPath, List<DasObject>> myQNames;

    public DbDataSourceImpl(@NotNull Project project, @NotNull DasDataSource dataSource2, @NotNull DataSourceManager<DasDataSource> manager) {
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DbDataSourceImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DbDataSourceImpl.$$$reportNull$$$0(2);
        }
        super(null, dataSource2);
        this.myDialects = ClearableLazyValue.create(this::calcDialects);
        this.myElements = CollectionFactory.createConcurrentWeakKeyWeakValueIdentityMap();
        this.myQNames = ConcurrentFactoryMap.create(this::findElementImpl, ContainerUtil::createConcurrentSoftValueMap);
        this.myProject = project;
        this.myManager = (BasicDataSourceManager)manager;
    }

    @Override
    @NotNull
    public DatabaseSystem getDelegate() {
        DatabaseSystem databaseSystem = (DatabaseSystem)super.getDelegate();
        if (databaseSystem == null) {
            DbDataSourceImpl.$$$reportNull$$$0(3);
        }
        return databaseSystem;
    }

    @Override
    public boolean isValid() {
        if (this.getProject().isDisposed()) {
            return false;
        }
        long current = DbPsiFacade.getInstance((Project)this.getProject()).getModificationCount();
        if (current == this.myTransactionalVersion) {
            return true;
        }
        if (!this.myManager.containsDataSource((DasDataSource)this.getDelegate())) {
            return false;
        }
        this.myTransactionalVersion = current;
        return true;
    }

    public void clearCaches() {
        this.myQNames.clear();
        this.myDialects.drop();
        Throwable trace = new Throwable("DbDataSource.clearCaches");
        LAST_DS_INVALIDATION_TRACE.set((UserDataHolder)this, (Object)trace);
        if (!this.isValid()) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)this, (Object)trace);
        }
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDelegate().getDbms();
        if (dbms == null) {
            DbDataSourceImpl.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @Nullable
    public Version getVersion() {
        return this.getDelegate().getVersion();
    }

    @NotNull
    public DataSourceManager<DasDataSource> getDbManager() {
        BasicDataSourceManager<DasDataSource> basicDataSourceManager = this.myManager;
        if (basicDataSourceManager == null) {
            DbDataSourceImpl.$$$reportNull$$$0(5);
        }
        return basicDataSourceManager;
    }

    @Override
    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl dbDataSourceImpl = this;
        if (dbDataSourceImpl == null) {
            DbDataSourceImpl.$$$reportNull$$$0(6);
        }
        return dbDataSourceImpl;
    }

    @Override
    @Nullable
    public String getComment() {
        return ((DasDataSource)this.myDelegate).getComment();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            DbDataSourceImpl.$$$reportNull$$$0(7);
        }
        return sqlLanguage;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((DasDataSource)this.myDelegate).getName();
        if (string == null) {
            DbDataSourceImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            DbDataSourceImpl.$$$reportNull$$$0(9);
        }
        this.myManager.renameDataSource((DasDataSource)this.getDelegate(), name);
        return this;
    }

    @NotNull
    public String getUniqueId() {
        String string = ((DasDataSource)this.myDelegate).getUniqueId();
        if (string == null) {
            DbDataSourceImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = ((DasDataSource)this.myDelegate).getDatabaseVersion();
        if (nameVersion == null) {
            DbDataSourceImpl.$$$reportNull$$$0(11);
        }
        return nameVersion;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            DbDataSourceImpl.$$$reportNull$$$0(12);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return ((DasDataSource)this.myDelegate).getIcon(0);
    }

    @Override
    @Nullable
    public Icon getIcon(boolean open) {
        return this.getBaseIcon();
    }

    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(13);
        }
        return project;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return ((DasDataSource)this.myDelegate).getConnectionConfig();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        this.checkValid();
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)((Pair)this.myDialects.getValue()).first;
        if (databaseDialectEx == null) {
            DbDataSourceImpl.$$$reportNull$$$0(14);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Language getQueryLanguage() {
        this.checkValid();
        Language language = (Language)((Pair)this.myDialects.getValue()).second;
        if (language == null) {
            DbDataSourceImpl.$$$reportNull$$$0(15);
        }
        return language;
    }

    @NotNull
    private Pair<DatabaseDialectEx, Language> calcDialects() {
        Language ql = (Language)ObjectUtils.notNull((Object)this.myManager.getQueryLanguage((DasDataSource)this.getDelegate()), (Object)SqlDialects.getGenericDialect());
        DatabaseDialectEx db = (DatabaseDialectEx)ObjectUtils.notNull((Object)this.myManager.getDatabaseDialect((DasDataSource)this.getDelegate()), (Object)DatabaseDialects.getGenericDialect());
        Pair pair = Pair.create((Object)db, (Object)ql);
        if (pair == null) {
            DbDataSourceImpl.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    public DasModel getModel() {
        this.checkValid();
        DasModel dasModel = Objects.requireNonNull(this.getDelegate()).getModel();
        if (dasModel == null) {
            DbDataSourceImpl.$$$reportNull$$$0(17);
        }
        return dasModel;
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation(boolean hover) {
        StringBuilder sb = this.getDocumentationFast();
        if (!hover) {
            this.scheduleAsyncDocumentationUpdate(sb, new DbElementImpl.AsyncDocGetter(){

                @Override
                public void get(@NotNull CharOut charOut, @NotNull ConnectionProvider provider) {
                    if (charOut == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (provider == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DbDataSourceImpl.this.loadSlowDocumentationInner(charOut);
                    this.beforeGet(charOut);
                }

                @Override
                public void beforeGet(@NotNull CharOut charOut) {
                    if (charOut == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    DbDataSourceImpl.this.loadSlowDocumentation0(charOut);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "charOut";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "provider";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/psi/DbDataSourceImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "get";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeGet";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbDataSourceImpl.$$$reportNull$$$0(18);
        }
        return stringBuilder;
    }

    @Nls
    @NotNull
    public StringBuilder getDocumentationFast() {
        StringBuilder sb = this.createDocHeaderDefault();
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        String s1 = DatabaseBundle.message((String)"dataSource.quickInfo.dialectPhrase", (Object[])new Object[]{dialect.getDisplayName()});
        sb.append(s1).append("<br>");
        if (this.myDelegate instanceof LocalDataSource) {
            if (!StringUtil.isEmpty((String)this.getDatabaseVersion().name)) {
                sb.append("<br>").append("<!-- async-doc-cut -->");
                sb.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.myDelegate)));
                sb.append("<br>");
            }
        } else {
            DasObject first2 = (DasObject)((DasDataSource)this.myDelegate).getModel().getModelRoots().first();
            sb.append("<br>");
            Casing modes = ((DasDataSource)this.myDelegate).getModel().getCasing(ObjectKind.TABLE, first2);
            String s2 = DatabaseBundle.message((String)"dataSource.quickInfo.caseSensitivityPhrase", (Object[])new Object[]{modes.plain, modes.quoted});
            sb.append(s2).append("<br>");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbDataSourceImpl.$$$reportNull$$$0(19);
        }
        return stringBuilder;
    }

    private void loadSlowDocumentation0(@NotNull CharOut charOut) {
        Object2IntMap map2;
        if (charOut == null) {
            DbDataSourceImpl.$$$reportNull$$$0(20);
        }
        if ((map2 = (Object2IntMap)ReadAction.nonBlocking(() -> (Object2IntOpenHashMap)((JBTreeTraverser)this.getModel().traverser().expand(Conditions.instanceOf(DasNamespace.class))).traverse().reduce((Object)new Object2IntOpenHashMap(), (result, o) -> {
            result.addTo((Object)o.getKind(), 1);
            return result;
        })).executeSynchronously()) == null || map2.isEmpty()) {
            return;
        }
        Object[] kinds = (ObjectKind[])map2.keySet().toArray((Object[])new ObjectKind[0]);
        Arrays.sort(kinds);
        Dbms dbms = this.getDbms();
        charOut.append("<br><b>Contents:</b>");
        for (Object kind : kinds) {
            int count = map2.getInt(kind);
            charOut.append("<br>" + count + " " + StringUtil.pluralize((String)DbPresentationCore.getPresentableName((ObjectKind)kind, dbms), (int)count));
        }
        charOut.append("<br>");
    }

    private static String boldAndNewLine(@NotNull String str) {
        if (str == null) {
            DbDataSourceImpl.$$$reportNull$$$0(21);
        }
        return NEW_LINE.matcher(DOC_PATTERN.matcher(str).replaceAll("<b>$1</b>")).replaceAll("<br>\n");
    }

    private void loadSlowDocumentationInner(CharOut charOut) {
        charOut.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.myDelegate)));
        charOut.append("<br>");
    }

    public <S> Function<DasObject, S> mapper() {
        return s2 -> this.findElement((DasObject)s2);
    }

    private List<DasObject> findElementImpl(ObjectPath key) {
        return (List)QNameUtil.findByPath(this.getModel(), key, (Function<? super ObjectPath, ? extends JBIterable<DasObject>>)((Function)p2 -> JBIterable.from((Iterable)this.myQNames.get(p2)))).addAllTo((Collection)new SmartList());
    }

    @Contract(value="null->null;!null->!null")
    public DbElement findElement(@Nullable DasObject o) {
        return o == null ? null : (o instanceof DbElement ? (DbElement)o : this.myElements.computeIfAbsent(o, this::createDbElement));
    }

    @NotNull
    private DbElement createDbElement(@NotNull DasObject dasElement) {
        DbDataSourceImpl parent2;
        if (dasElement == null) {
            DbDataSourceImpl.$$$reportNull$$$0(22);
        }
        ObjectKind kind = dasElement.getKind();
        DasObject dasParent = dasElement.getDasParent();
        DbDataSourceImpl dbDataSourceImpl = parent2 = dasParent == null || dasParent instanceof BasicRoot ? this : this.findElement(dasParent);
        DbElementImpl element2 = kind == ObjectKind.DATABASE || DbImplUtil.isSchema(kind) ? new DbNamespaceImpl(parent2, dasElement) : (dasElement instanceof DasUserDefinedType ? (kind == ObjectKind.TABLE_TYPE ? new DbTableTypeImpl(parent2, (DasUserDefinedType)dasElement) : new DbCustomTypeImpl(parent2, (DasUserDefinedType)dasElement)) : (dasElement instanceof DasRoutine ? new DbRoutineImpl(parent2, (DasRoutine)dasElement) : (dasElement instanceof DasTable ? new DbTableImpl(parent2, (DasTable)dasElement) : (kind == ObjectKind.COLUMN && dasElement instanceof DasColumn && parent2 instanceof DbTable ? new DbColumnImpl((DbTable)parent2, (DasColumn)dasElement) : (kind == ObjectKind.COLUMN && dasElement instanceof DasTypedObject ? new DbObjectAttributeImpl(parent2, (DasTypedObject)dasElement) : (kind == ObjectKind.OBJECT_ATTRIBUTE && dasElement instanceof DasTypedObject ? new DbObjectAttributeImpl(parent2, (DasTypedObject)dasElement) : (kind == ObjectKind.KEY && dasElement instanceof DasTableKey && parent2 instanceof DbTable ? new DbTableKeyImpl((DbTable)parent2, (DasTableKey)dasElement) : (kind == ObjectKind.FOREIGN_KEY && dasElement instanceof DasForeignKey && parent2 instanceof DbTable ? new DbForeignKeyImpl((DbTable)parent2, (DasForeignKey)dasElement) : (kind == ObjectKind.INDEX && dasElement instanceof DasIndex && parent2 instanceof DbTable ? new DbIndexImpl((DbTable)parent2, (DasIndex)dasElement) : (kind == ObjectKind.PACKAGE ? new DbPackageImpl(parent2, dasElement) : ((kind == ObjectKind.RULE || kind == ObjectKind.TRIGGER) && dasElement instanceof DasTrigger && parent2 instanceof DbTable ? new DbTriggerImpl((DbTable)parent2, (DasTrigger)dasElement) : (dasElement instanceof DasCluster ? new DbClusterImpl(parent2, (DasCluster)dasElement) : (dasElement instanceof DasSynonym ? new DbSynonymImpl(parent2, (DasSynonym)dasElement) : (dasElement instanceof DasSchemaChild ? new DbSchemaChildImpl(parent2, (DasSchemaChild)dasElement) : new DbElementImpl<DasObject, DbDataSourceImpl>(parent2, dasElement)))))))))))))));
        DbNamespaceImpl dbNamespaceImpl = element2;
        if (dbNamespaceImpl == null) {
            DbDataSourceImpl.$$$reportNull$$$0(23);
        }
        return dbNamespaceImpl;
    }

    @Override
    public void navigate(boolean requestFocus) {
        super.navigate(requestFocus);
    }

    @Nullable
    public DbElement findElement(@NotNull ObjectPath path) {
        if (path == null) {
            DbDataSourceImpl.$$$reportNull$$$0(24);
        }
        this.checkValid();
        DasObject o = (DasObject)ContainerUtil.getFirstItem(this.myQNames.get(path));
        return o == null ? null : this.findElement(o);
    }

    @NotNull
    public JBIterable<DasObject> findObjects(@NotNull ObjectPath path) {
        if (path == null) {
            DbDataSourceImpl.$$$reportNull$$$0(25);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)this.myQNames.get(path));
        if (jBIterable == null) {
            DbDataSourceImpl.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<DbElement> findChildren(@NotNull DbElement element2) {
        JBIterable children2;
        if (element2 == null) {
            DbDataSourceImpl.$$$reportNull$$$0(27);
        }
        this.checkValid();
        Object delegate = element2.getDelegate();
        if (element2 == this) {
            children2 = this.getModel().getModelRoots();
        } else if (delegate instanceof DasObject) {
            children2 = ((DasObject)delegate).getDasChildren(null);
        } else {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbDataSourceImpl.$$$reportNull$$$0(28);
            }
            return jBIterable;
        }
        JBIterable jBIterable = children2.map(o -> this.findElement((DasObject)o));
        if (jBIterable == null) {
            DbDataSourceImpl.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    public boolean isValidImpl(DbElement element2) {
        DbElementImpl e = (DbElementImpl)element2;
        long count = DbPsiFacade.getInstance((Project)this.getProject()).getModificationCount();
        if (e.myTransactionalVersion == count) {
            return true;
        }
        if (this.isValid()) {
            DasModel model = Objects.requireNonNull(this.getDelegate()).getModel();
            BasicModElement basic = (BasicModElement)ObjectUtils.tryCast((Object)element2.getDelegate(), BasicModElement.class);
            if (basic != null && !basic.isDropped() && model.contains((DasObject)basic)) {
                e.myTransactionalVersion = count;
                return true;
            }
        }
        if (PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)e) == null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)e, (Object)LAST_DS_INVALIDATION_TRACE.get((UserDataHolder)this));
        }
        return false;
    }

    @NotNull
    public ModelNameIndex getNameIndex() {
        DasModel model = this.getModel();
        ModelNameIndex modelNameIndex = model instanceof BaseModel ? ((BaseModel)model).getNameIndex() : ModelNameIndexImpl.EMPTY_INDEX;
        if (modelNameIndex == null) {
            DbDataSourceImpl.$$$reportNull$$$0(30);
        }
        return modelNameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charOut";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDialects";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationFast";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildren";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadSlowDocumentation0";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "boldAndNewLine";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDbElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

