/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.Grants$Controller$WhenMappings;
import com.intellij.database.model.properties.GrantsKt;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PrimitiveIterator;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003,-.B#\b\u0016\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J6\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0015\"\b\b\u0001\u0010\u0016*\u00020\u00172\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00160\u00052\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\u001c\u0010\u001c\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0017J\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0017J\u001c\u0010 \u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u0017J\b\u0010\"\u001a\u00020#H\u0016J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0096\u0002J\u0006\u0010&\u001a\u00020\u0007J\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\b\u0010*\u001a\u00020\u0007H\u0016J\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003R\u001b\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/model/properties/Grants;", "T", "Lcom/intellij/database/model/properties/Grants$Grant;", "", "c", "Lcom/intellij/database/model/properties/Grants$Controller;", "text", "", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/String;)V", "controller", "gs", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/Iterable;)V", "getController", "()Lcom/intellij/database/model/properties/Grants$Controller;", "grants", "Ljava/util/NavigableSet;", "equals", "", "other", "", "granteeFilter", "Lcom/intellij/openapi/util/Condition;", "U", "Lcom/intellij/database/model/basic/BasicElement;", "u", "grantsFor", "Ljava/util/SortedSet;", "e", "grantsForByGrantee", "", "grantsForGrantee", "Lcom/intellij/util/containers/JBIterable;", "grantsForGranteeByTarget", "g", "hashCode", "", "iterator", "", "serialize", "toMutableList", "", "toMutableSet", "toString", "with", "Controller", "Grant", "State", "intellij.database.core.impl"})
public final class Grants<T extends Grant>
implements Iterable<T>,
KMappedMarker {
    private final NavigableSet<T> grants;
    @NotNull
    private final Controller<T, ?> controller;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        Object object2 = object;
        if (object == null) return false;
        Object $this$castSafelyTo$iv = object2;
        boolean $i$f$castSafelyTo = false;
        Object object3 = $this$castSafelyTo$iv;
        if (!(object3 instanceof Grants)) {
            object3 = null;
        }
        Grants grants = (Grants)object3;
        object2 = grants;
        if (grants == null) return false;
        Object object4 = object2;
        boolean bl = false;
        boolean bl2 = false;
        Object it2 = object4;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual(this.grants, ((Grants)it2).grants);
        return bl4;
    }

    public int hashCode() {
        return this.grants.hashCode();
    }

    @NotNull
    public final Grants<T> with(@NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        return new Grants<T>(this.controller, gs);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.grants.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"grants.iterator()");
        return iterator;
    }

    @Nullable
    public final SortedSet<T> grantsFor(@NotNull BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.grants.isEmpty()) {
            return null;
        }
        T t = this.controller.lower(e);
        if (t == null) {
            return Collections.emptySortedSet();
        }
        T l = t;
        T u = this.controller.upper(l);
        SortedSet<T> sortedSet = this.grants.subSet(l, u);
        boolean bl = false;
        boolean bl2 = false;
        SortedSet<T> it2 = sortedSet;
        boolean bl3 = false;
        SortedSet<T> sortedSet2 = it2;
        Intrinsics.checkNotNullExpressionValue(sortedSet2, (String)"it");
        Collection collection = sortedSet2;
        boolean bl4 = false;
        return !collection.isEmpty() ? sortedSet : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Iterable<Collection<T>> grantsForByGrantee(@NotNull BasicElement e) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.grantsFor(e);
        if (object != null) {
            JBIterable jBIterable = object;
            boolean bl = false;
            boolean bl2 = false;
            JBIterable it2 = jBIterable;
            boolean bl3 = false;
            object = JBIterable.from((Iterable)((Iterable)it2));
            if (object != null && (object = GrantsKt.groupByGrantee((Iterable)object, this.controller)) != null) {
                collection = object.values();
                return collection;
            }
        }
        collection = null;
        return collection;
    }

    @Nullable
    public final JBIterable<T> grantsForGrantee(@NotNull BasicElement u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        if (this.grants.isEmpty()) {
            return null;
        }
        Condition<T> condition = this.granteeFilter(this.controller, u);
        if (condition == null) {
            return null;
        }
        Condition<T> filter2 = condition;
        return JBIterable.from((Iterable)this.grants).filter(filter2);
    }

    private final <U extends BasicElement> Condition<T> granteeFilter(Controller<T, U> c2, BasicElement u) {
        U u2 = c2.asGrantee(u);
        if (u2 == null) {
            return null;
        }
        U g = u2;
        T key = c2.withGrantee(c2.create(), g);
        return new Condition<T>(c2, (Grant)key){
            final /* synthetic */ Controller $c;
            final /* synthetic */ Grant $key;

            public final boolean value(T it2) {
                return this.$c.getGranteeStrategy().equals((Object)this.$key, it2);
            }
            {
                this.$c = controller;
                this.$key = grant;
            }
        };
    }

    @Nullable
    public final JBIterable<Collection<T>> grantsForGranteeByTarget(@NotNull BasicElement g) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                object = this.grantsForGrantee(g);
                if (object == null || (object = object.collect()) == null) break block2;
                JBIterable jBIterable = object;
                boolean bl = false;
                boolean bl2 = false;
                JBIterable it2 = jBIterable;
                boolean bl3 = false;
                JBIterable jBIterable2 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"it");
                object = jBIterable2.isNotEmpty() ? jBIterable : null;
                if (object != null) break block3;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"grantsForGrantee(g)?.col\u2026NotEmpty } ?: return null");
        JBIterable res2 = object;
        return res2.split(JBIterable.Split.BEFORE, (Condition)new JBIterable.SCond<T>(this){
            private T u;
            final /* synthetic */ Grants this$0;

            public boolean value(@NotNull T t) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                T fu = this.u;
                if (fu != null && this.this$0.getController().compare(t, fu) < 0) {
                    return false;
                }
                this.u = this.this$0.getController().upper(t);
                return fu != null;
            }
            {
                this.this$0 = this$0;
            }
        }).map((Function)grantsForGranteeByTarget.2.INSTANCE);
    }

    @NotNull
    public String toString() {
        return "Grants(size=" + this.grants.size() + ')';
    }

    @NotNull
    public final List<T> toMutableList() {
        return CollectionsKt.toMutableList((Collection)this.grants);
    }

    @NotNull
    public final SortedSet<T> toMutableSet() {
        return CollectionsKt.toSortedSet((Iterable)this.grants, (Comparator)this.controller);
    }

    @NotNull
    public final String serialize() {
        StringBuilder sb = new StringBuilder();
        for (Grant grant : this.grants) {
            CharSequence charSequence = sb;
            boolean bl = false;
            if (charSequence.length() > 0) {
                sb.append('\n');
            }
            Grant grant2 = grant;
            Intrinsics.checkNotNullExpressionValue((Object)grant2, (String)"grant");
            sb.append(PropertyConverter.escapeSlashN(this.controller.serialize(grant2)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final Controller<T, ?> getController() {
        return this.controller;
    }

    public Grants(@NotNull Controller<T, ?> controller, @NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        this.controller = controller;
        ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Comparator)this.controller, gs);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSortedSet, (String)"ImmutableSortedSet.copyOf(controller, gs)");
        this.grants = (NavigableSet)immutableSortedSet;
    }

    /*
     * Unable to fully structure code
     */
    public Grants(final @NotNull Controller<T, ?> c, @Nullable String text) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        v0 = this;
        v1 = c;
        v2 = StringKt.nullize$default((String)text, (boolean)false, (int)1, null);
        if (v2 == null || (v2 = StringsKt.splitToSequence$default((CharSequence)((CharSequence)v2), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null)) == null || (v2 = SequencesKt.mapNotNull((Sequence)v2, (Function1)((Function1)new Function1<String, T>(){

            @Nullable
            public final T invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                String string = StringUtil.unescapeStringCharacters((String)it2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.unescapeStringCharacters(it)");
                return c.deserialize(string);
            }
        }))) == null || (v2 = v2.iterator()) == null) ** GOTO lbl-1000
        var3_3 = v2;
        var4_4 = false;
        var5_5 = false;
        var6_6 = var3_3;
        var9_7 = v1;
        var8_8 = v0;
        $i$a$-let-Grants$2 = false;
        var10_10 = JBIterable.once((Iterator)it);
        v0 = var8_8;
        v1 = var9_7;
        v2 = var10_10;
        if (v2 != null) {
            v3 = (Iterable)v2;
        } else lbl-1000:
        // 2 sources

        {
            v4 = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"JBIterable.empty()");
            v3 = (Iterable)v4;
        }
        v0(v1, v3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B!\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0005R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/model/properties/Grants$Grant;", "", "subs", "Ljava/util/BitSet;", "permission", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "(Ljava/util/BitSet;Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;)V", "isSub", "", "()Z", "mySubs", "getPermission", "()Ljava/lang/String;", "permissionName", "getPermissionName", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "getSubs", "()Ljava/util/BitSet;", "subsStream", "Ljava/util/stream/IntStream;", "getSubsStream", "()Ljava/util/stream/IntStream;", "equals", "other", "hasGrantOption", "hashCode", "", "serializeSubs", "intellij.database.core.impl"})
    public static abstract class Grant {
        @NotNull
        private final String permission;
        private final BitSet mySubs;
        @NotNull
        private final State state;

        @NotNull
        public final String getPermission() {
            return this.permission;
        }

        @NotNull
        public final String getPermissionName() {
            String string = StringUtil.toLowerCase((String)this.permission);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toLowerCase(permission)");
            return string;
        }

        public final boolean isSub() {
            return this.mySubs != null;
        }

        @NotNull
        public final IntStream getSubsStream() {
            IntStream intStream;
            if (this.mySubs == null) {
                IntStream intStream2 = IntStream.empty();
                intStream = intStream2;
                Intrinsics.checkNotNullExpressionValue((Object)intStream2, (String)"IntStream.empty()");
            } else {
                IntStream intStream3 = this.mySubs.stream();
                intStream = intStream3;
                Intrinsics.checkNotNullExpressionValue((Object)intStream3, (String)"mySubs.stream()");
            }
            return intStream;
        }

        @Nullable
        public final BitSet getSubs() {
            BitSet bitSet = this.mySubs;
            return (BitSet)(bitSet != null ? bitSet.clone() : null);
        }

        public final boolean hasGrantOption() {
            return this.state.getWithGrantOption();
        }

        @NotNull
        public final String serializeSubs() {
            StringBuilder sb = new StringBuilder();
            if (this.mySubs != null) {
                int l = sb.length();
                PrimitiveIterator.OfInt it2 = this.mySubs.stream().iterator();
                while (it2.hasNext()) {
                    if (l != sb.length()) {
                        sb.append(",");
                    }
                    Integer n = it2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.next()");
                    sb.append(n);
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Grant && Intrinsics.areEqual((Object)this.permission, (Object)((Grant)other).permission) && this.state == ((Grant)other).state && Intrinsics.areEqual((Object)this.mySubs, (Object)((Grant)other).mySubs);
        }

        public int hashCode() {
            int result = this.permission.hashCode();
            result = 31 * result + this.state.hashCode();
            BitSet bitSet = this.mySubs;
            result = 31 * result + (bitSet != null ? bitSet.hashCode() : 0);
            return result;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        /*
         * Unable to fully structure code
         */
        protected Grant(@Nullable BitSet subs, @NotNull String permission, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super();
            this.state = state;
            v0 = DbUtil.intern((String)permission);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"DbUtil.intern(permission)");
            this.permission = v0;
            v1 = this;
            v2 = subs;
            if (v2 == null) ** GOTO lbl-1000
            var4_4 = v2;
            var5_5 = false;
            var6_6 = false;
            var7_7 = var4_4;
            var9_8 = v1;
            $i$a$-takeIf-Grants$Grant$mySubs$1 = false;
            var10_10 = it.isEmpty() == false;
            v1 = var9_8;
            v2 = var10_10 != false ? var4_4 : null;
            if (v2 != null) {
                var4_4 = v2;
                var5_5 = false;
                var6_6 = false;
                it = var4_4;
                var9_8 = v1;
                $i$a$-run-Grants$Grant$mySubs$2 = false;
                v3 = $this$run.clone();
                if (v3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.BitSet");
                }
                var10_11 = (BitSet)v3;
                v1 = var9_8;
                v4 = var10_11;
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v1.mySubs = v4;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0005\b&\u0018\u0000 a*\b\b\u0001\u0010\u0001*\u00020\u0002*\b\b\u0002\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001aB\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0013\u001a\u0004\u0018\u00018\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H&\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0003\u0010\u0018J\u0018\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0003\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\r\u0010\u001f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020#H&\u00a2\u0006\u0002\u0010$J#\u0010%\u001a\u0004\u0018\u00018\u00022\b\u0010&\u001a\u0004\u0018\u00018\u00012\b\u0010'\u001a\u0004\u0018\u00010\u0004H&\u00a2\u0006\u0002\u0010(J\u001f\u0010%\u001a\u0004\u0018\u00018\u00022\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00018\u00012\b\u0010'\u001a\u0004\u0018\u00010\u0004H&\u00a2\u0006\u0002\u0010(J \u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00020-0,2\b\u0010'\u001a\u0004\u0018\u00010\u0004H&J!\u0010.\u001a\u00020#2\b\u0010\u0014\u001a\u0004\u0018\u00018\u00022\b\u0010&\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001012\u0006\u00102\u001a\u00020\u0004J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0004H&J\u0017\u00106\u001a\u0004\u0018\u00018\u00012\u0006\u00102\u001a\u00020\u0004H&\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020#092\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H&J\u001f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H&\u00a2\u0006\u0002\u0010?J\u0017\u0010@\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010AJ\u0013\u0010B\u001a\u00020#2\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010AJ\u001e\u0010C\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040-0,2\b\u0010'\u001a\u0004\u0018\u00010\u0004J!\u0010D\u001a\u00020#2\b\u00102\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010/J\u0015\u0010E\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010FJ\u0013\u0010G\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010FJ\u001d\u0010H\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010IJ\u001d\u0010J\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010K\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010LJ/\u0010M\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010N\u001a\u00020#2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020>H&\u00a2\u0006\u0002\u0010RJ\u001d\u0010S\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010Q\u001a\u00020>H&\u00a2\u0006\u0002\u0010TJ\u001d\u0010U\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u00102\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010IJ\u001d\u0010V\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010K\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010LJ\u001d\u0010W\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020#H&\u00a2\u0006\u0002\u0010XJ\u001d\u0010Y\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020#H&\u00a2\u0006\u0002\u0010XJ\u001e\u0010Z\u001a\u00020\u001b*\u00020\u001b2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u001b0\\H\u0084\b\u00f8\u0001\u0000J3\u0010Z\u001a\u00020\u001b\"\f\b\u0003\u0010\u0018*\u0006\u0012\u0002\b\u00030]*\u00020\u001b2\b\u0010^\u001a\u0004\u0018\u0001H\u00182\b\u0010_\u001a\u0004\u0018\u0001H\u0018H\u0004\u00a2\u0006\u0002\u0010`R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006b"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller;", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "U", "Lcom/intellij/database/model/basic/BasicElement;", "Ljava/util/Comparator;", "()V", "bothStrategy", "Lgnu/trove/TObjectHashingStrategy;", "getBothStrategy", "()Lgnu/trove/TObjectHashingStrategy;", "granteeStrategy", "getGranteeStrategy", "noGrants", "Lcom/intellij/database/model/properties/Grants;", "getNoGrants", "()Lcom/intellij/database/model/properties/Grants;", "targetStrategy", "getTargetStrategy", "asGrantee", "u", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicElement;", "byGrantee", "", "V", "byTarget", "compare", "", "o1", "o2", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)I", "create", "()Lcom/intellij/database/model/properties/Grants$Grant;", "deserialize", "text", "", "(Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "findGrantee", "g", "h", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicElement;", "findTarget", "granteeFamiliesFor", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/families/Family;", "granteeText", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "grantsHolder", "Lcom/intellij/database/model/basic/BasicGrantsHolder;", "e", "holdsItsGrants", "", "element", "lower", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "possiblePrivileges", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "possibleStates", "", "Lcom/intellij/database/model/properties/Grants$State;", "(Lcom/intellij/database/model/meta/BasicMetaObject;)[Lcom/intellij/database/model/properties/Grants$State;", "serialize", "(Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "serializeState", "targetFamiliesFor", "targetText", "upper", "(Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "withAntiState", "withGrantee", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "withGranteeFrom", "src", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "withPermission", "perm", "subs", "Ljava/util/BitSet;", "state", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;Ljava/util/BitSet;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withState", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withTarget", "withTargetFrom", "withUnresolvedGrantee", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "withUnresolvedTarget", "thenCompare", "nextStage", "Lkotlin/Function0;", "", "a", "b", "(ILjava/lang/Comparable;Ljava/lang/Comparable;)I", "Companion", "intellij.database.core.impl"})
    public static abstract class Controller<G extends Grant, U extends BasicElement>
    implements Comparator<G> {
        @NotNull
        private final Grants<G> noGrants = new Grants(this, CollectionsKt.emptyList());
        @NotNull
        private final TObjectHashingStrategy<G> bothStrategy = new TObjectHashingStrategy<G>(this){
            final /* synthetic */ Controller this$0;

            public boolean equals(@NotNull G o1, @NotNull G o2) {
                Intrinsics.checkNotNullParameter(o1, (String)"o1");
                Intrinsics.checkNotNullParameter(o2, (String)"o2");
                return this.this$0.getGranteeStrategy().equals(o1, o2) && this.this$0.getTargetStrategy().equals(o1, o2);
            }

            public int computeHashCode(@NotNull G object) {
                Intrinsics.checkNotNullParameter(object, (String)"object");
                return this.this$0.getGranteeStrategy().computeHashCode(object) + 31 * this.this$0.getTargetStrategy().computeHashCode(object);
            }
            {
                this.this$0 = this$0;
            }
        };
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Grants<G> getNoGrants() {
            return this.noGrants;
        }

        @NotNull
        public abstract TObjectHashingStrategy<G> getGranteeStrategy();

        @NotNull
        public abstract TObjectHashingStrategy<G> getTargetStrategy();

        @NotNull
        public final TObjectHashingStrategy<G> getBothStrategy() {
            return this.bothStrategy;
        }

        @NotNull
        public final <V> Map<G, V> byGrantee() {
            return (Map)new THashMap(this.getGranteeStrategy());
        }

        @NotNull
        public final <V> Map<G, V> byTarget() {
            return (Map)new THashMap(this.getTargetStrategy());
        }

        protected final int thenCompare(int $this$thenCompare, @NotNull Function0<Integer> nextStage) {
            int $i$f$thenCompare = 0;
            Intrinsics.checkNotNullParameter(nextStage, (String)"nextStage");
            Integer n = $this$thenCompare;
            boolean bl = false;
            boolean bl2 = false;
            int it2 = ((Number)n).intValue();
            boolean bl3 = false;
            Integer n2 = it2 != 0 ? n : null;
            return n2 != null ? n2.intValue() : ((Number)nextStage.invoke()).intValue();
        }

        /*
         * WARNING - void declaration
         */
        protected final <V extends Comparable<?>> int thenCompare(int $this$thenCompare, @Nullable V a2, @Nullable V b2) {
            int n;
            void $this$thenCompare$iv;
            int n2 = $this$thenCompare;
            Controller this_$iv = this;
            boolean $i$f$thenCompare = false;
            Integer n3 = (int)$this$thenCompare$iv;
            boolean bl = false;
            boolean bl2 = false;
            int it$iv = ((Number)n3).intValue();
            boolean bl3 = false;
            Integer n4 = it$iv != 0 ? n3 : null;
            if (n4 != null) {
                n = n4;
            } else {
                boolean bl4 = false;
                n = ComparisonsKt.compareValues(a2, b2);
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(@NotNull G o1, @NotNull G o2) {
            int n;
            void $this$thenCompare$iv;
            Intrinsics.checkNotNullParameter(o1, (String)"o1");
            Intrinsics.checkNotNullParameter(o2, (String)"o2");
            Controller controller = this;
            BitSet bitSet = ((Grant)o1).getSubs();
            BitSet bitSet2 = ((Grant)o2).getSubs();
            int n2 = this.thenCompare(ComparisonsKt.compareValues((Comparable)((Comparable)((Object)((Grant)o1).getPermission())), (Comparable)((Comparable)((Object)((Grant)o2).getPermission()))), (Comparable)(bitSet != null ? Integer.valueOf(bitSet.length()) : null), (Comparable)(bitSet2 != null ? Integer.valueOf(bitSet2.length()) : null));
            Controller this_$iv = this;
            boolean $i$f$thenCompare = false;
            Integer n3 = (int)$this$thenCompare$iv;
            boolean bl = false;
            boolean bl2 = false;
            int it$iv = ((Number)n3).intValue();
            boolean bl3 = false;
            Integer n4 = it$iv != 0 ? n3 : null;
            if (n4 != null) {
                n = n4;
            } else {
                int n5;
                Controller controller2;
                block3: {
                    controller2 = controller;
                    boolean bl4 = false;
                    PrimitiveIterator.OfInt it1 = ((Grant)o1).getSubsStream().iterator();
                    PrimitiveIterator.OfInt it2 = ((Grant)o2).getSubsStream().iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        int res2 = ComparisonsKt.compareValues((Comparable)Integer.valueOf(it1.nextInt()), (Comparable)Integer.valueOf(it2.nextInt()));
                        if (res2 == 0) continue;
                        n5 = res2;
                        break block3;
                    }
                    n5 = ComparisonsKt.compareValues((Comparable)Boolean.valueOf(it1.hasNext()), (Comparable)Boolean.valueOf(it2.hasNext()));
                }
                int n6 = n5;
                controller = controller2;
                n = n6;
            }
            return controller.thenCompare(n, (Comparable)((Object)((Grant)o1).getState()), (Comparable)((Object)((Grant)o2).getState()));
        }

        @Nullable
        public abstract String serialize(@NotNull G var1);

        @NotNull
        public abstract G deserialize(@NotNull String var1);

        @NotNull
        public abstract Iterable<String> possiblePrivileges(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract State[] possibleStates(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract G create();

        @Nullable
        public abstract G lower(@NotNull BasicElement var1);

        @NotNull
        public abstract G upper(@NotNull G var1);

        @Nullable
        public abstract U asGrantee(@Nullable BasicElement var1);

        @Nullable
        public abstract U findGrantee(@Nullable G var1, @Nullable BasicElement var2);

        @NotNull
        public String granteeText(@Nullable U u, @Nullable G g) {
            Object object = u;
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            return object;
        }

        @NotNull
        public abstract JBIterable<Family<? extends U>> granteeFamiliesFor(@Nullable BasicElement var1);

        @NotNull
        public final JBIterable<Family<? extends BasicElement>> targetFamiliesFor(@Nullable BasicElement h) {
            BasicElement basicElement;
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from((Function)targetFamiliesFor.1.INSTANCE).filter((Condition)new Condition<Family<? extends BasicElement>>(this){
                final /* synthetic */ Controller this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean value(Family<? extends BasicElement> it2) {
                    Family<? extends BasicElement> family = it2;
                    Intrinsics.checkNotNullExpressionValue(family, (String)"it");
                    if (!(Intrinsics.areEqual((Object)family.getMetaObject().kind, (Object)ObjectKind.COLUMN) ^ true)) return false;
                    BasicMetaObject<?> basicMetaObject = it2.getMetaObject();
                    Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"it.metaObject");
                    if (!this.this$0.possiblePrivileges(basicMetaObject).iterator().hasNext()) return false;
                    return true;
                }
                {
                    this.this$0 = controller;
                }
            })).withRoots((Iterable)((basicElement = h) != null && (basicElement = basicElement.getParent()) != null ? basicElement.getFamilies() : null))).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBTreeTraverser.from<Fam\u2026ent?.families).traverse()");
            return jBIterable;
        }

        @Nullable
        public U findGrantee(@NotNull BasicElement h, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return (U)((BasicElement)this.granteeFamiliesFor(h).filterMap(new Function<Family<? extends U>, U>(this, text2){
                final /* synthetic */ Controller this$0;
                final /* synthetic */ String $text;

                @Nullable
                public final U fun(Family<? extends U> f) {
                    return f.find(new Predicate<U>(this){
                        final /* synthetic */ findGrantee.1 this$0;

                        public final boolean test(U it2) {
                            return Intrinsics.areEqual((Object)this.this$0.this$0.granteeText(it2, null), (Object)this.this$0.$text);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = controller;
                    this.$text = string;
                }
            }).first());
        }

        @Nullable
        public abstract BasicElement findTarget(@Nullable G var1, @Nullable BasicElement var2);

        @NotNull
        public String targetText(@Nullable BasicElement e, @Nullable G g) {
            Object object;
            block5: {
                block6: {
                    String string;
                    block8: {
                        block7: {
                            block4: {
                                if (!(e instanceof BasicRoot)) break block4;
                                object = "server";
                                break block5;
                            }
                            object = e;
                            if (object == null) break block6;
                            Object object2 = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object it2 = object2;
                            boolean bl3 = false;
                            string = StringKt.nullize$default((String)BasicPaths.getIdentity(e), (boolean)false, (int)1, null);
                            if (string == null) break block7;
                            String string2 = string;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String it3 = string2;
                            boolean bl6 = false;
                            string = e.getName() + it3;
                            if (string != null) break block8;
                        }
                        String string3 = e.getName();
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e.name");
                    }
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            return object;
        }

        @NotNull
        public abstract G withTarget(@NotNull G var1, @NotNull BasicElement var2);

        @NotNull
        public abstract G withTargetFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withUnresolvedTarget(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGrantee(@NotNull G var1, @NotNull U var2);

        @NotNull
        public abstract G withUnresolvedGrantee(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGranteeFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withPermission(@NotNull G var1, @NotNull String var2, @Nullable BitSet var3, @NotNull State var4);

        @NotNull
        public abstract G withState(@NotNull G var1, @NotNull State var2);

        @NotNull
        public final G withAntiState(@NotNull G g) {
            State state;
            Intrinsics.checkNotNullParameter(g, (String)"g");
            switch (Grants$Controller$WhenMappings.$EnumSwitchMapping$0[((Grant)g).getState().ordinal()]) {
                case 1: 
                case 2: {
                    state = State.REVOKE;
                    break;
                }
                case 3: 
                case 4: {
                    state = State.GRANT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return this.withState(g, state);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final BasicGrantsHolder<G> grantsHolder(@NotNull BasicElement e) {
            void $this$grantsHolder$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BasicElement basicElement = e;
            boolean strict$iv = !this.holdsItsGrants(e);
            boolean $i$f$grantsHolder = false;
            return (BasicGrantsHolder)DasUtil.getParentOfClass((DasObject)((DasObject)$this$grantsHolder$iv), BasicGrantsHolder.class, (boolean)strict$iv);
        }

        public abstract boolean holdsItsGrants(@NotNull BasicElement var1);

        @NotNull
        public final String serializeState(@NotNull G g) {
            Intrinsics.checkNotNullParameter(g, (String)"g");
            return String.valueOf(((Grant)g).getState().getCode());
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J \u0010\r\u001a\u0002H\u000e\"\u0010\b\u0003\u0010\u000e\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u000e0\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller$Companion;", "", "()V", "deserializeId", "", "text", "", "deserializeKind", "Lcom/intellij/database/model/ObjectKind;", "deserializeState", "Lcom/intellij/database/model/properties/Grants$State;", "deserializeSubs", "Ljava/util/BitSet;", "minEnum", "T", "", "()Ljava/lang/Enum;", "minId", "minState", "nextId", "id", "nextName", "name", "serializeKind", "kind", "intellij.database.core.impl"})
        public static final class Companion {
            public final /* synthetic */ <T extends Enum<T>> T minEnum() {
                int $i$f$minEnum = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Object[] objectArray = Enum.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"T::class.java.enumConstants");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"T::class.java.enumConstants.first()");
                return (T)((Enum)object);
            }

            @NotNull
            public final State minState() {
                Companion this_$iv = this;
                boolean $i$f$minEnum = false;
                Object[] objectArray = State.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"T::class.java.enumConstants");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"T::class.java.enumConstants.first()");
                return (State)((Enum)object);
            }

            public final long minId() {
                return Long.MIN_VALUE;
            }

            public final long nextId(long id) {
                return id + 1L;
            }

            @NotNull
            public final String nextName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return name + "\u0000";
            }

            @NotNull
            public final State deserializeState(@Nullable String text2) {
                State state;
                State state2;
                block3: {
                    String string = text2;
                    if (string == null || string.length() != 1) {
                        return State.GRANT;
                    }
                    char c2 = text2.charAt(0);
                    State[] stateArray = State.values();
                    boolean bl = false;
                    State[] stateArray2 = stateArray;
                    boolean bl2 = false;
                    State[] stateArray3 = stateArray2;
                    int n = stateArray3.length;
                    for (int j = 0; j < n; ++j) {
                        State state3;
                        State it2 = state3 = stateArray3[j];
                        boolean bl3 = false;
                        if (!(it2.getCode() == c2)) continue;
                        state2 = state3;
                        break block3;
                    }
                    state2 = state = null;
                }
                if (state2 == null) {
                    state = State.GRANT;
                }
                return state;
            }

            @NotNull
            public final ObjectKind deserializeKind(@Nullable String text2) {
                CharSequence charSequence = text2;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    ObjectKind objectKind = ObjectKind.NONE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.NONE");
                    return objectKind;
                }
                ObjectKind objectKind = (ObjectKind)ObjectKind.ourKinds.get(text2);
                if (objectKind == null) {
                    ObjectKind objectKind2 = ObjectKind.NONE;
                    objectKind = objectKind2;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"ObjectKind.NONE");
                }
                return objectKind;
            }

            public final long deserializeId(@Nullable String text2) {
                long l;
                String string = StringKt.nullize$default((String)text2, (boolean)false, (int)1, null);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    l = Long.parseLong(string2);
                } else {
                    l = Long.MIN_VALUE;
                }
                return l;
            }

            @NotNull
            public final String serializeKind(@NotNull ObjectKind kind) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                ObjectKind objectKind = kind;
                boolean bl = false;
                boolean bl2 = false;
                ObjectKind it2 = objectKind;
                boolean bl3 = false;
                Object object = Intrinsics.areEqual((Object)it2, (Object)ObjectKind.NONE) ^ true ? objectKind : null;
                if (object == null || (object = object.code()) == null) {
                    object = "";
                }
                return object;
            }

            @Nullable
            public final BitSet deserializeSubs(@Nullable String text2) {
                CharSequence charSequence = text2;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    return null;
                }
                BitSet subs = new BitSet();
                Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), (Function1)deserializeSubs.1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it2 = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    subs.set(it2);
                }
                return subs;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/model/properties/Grants$State;", "", "code", "", "(Ljava/lang/String;IC)V", "getCode", "()C", "term", "", "getTerm", "()Ljava/lang/String;", "withGrantOption", "", "getWithGrantOption", "()Z", "GRANT", "GRANT_WITH_GRANT_OPTION", "REVOKE", "DENY", "intellij.database.core.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State GRANT;
        public static final /* enum */ State GRANT_WITH_GRANT_OPTION;
        public static final /* enum */ State REVOKE;
        public static final /* enum */ State DENY;
        private static final /* synthetic */ State[] $VALUES;
        private final char code;

        static {
            State[] stateArray = new State[4];
            State[] stateArray2 = stateArray;
            stateArray[0] = GRANT = new State('G');
            stateArray[1] = GRANT_WITH_GRANT_OPTION = new GRANT_WITH_GRANT_OPTION("GRANT_WITH_GRANT_OPTION", 1);
            stateArray[2] = REVOKE = new State('R');
            stateArray[3] = DENY = new State('D');
            $VALUES = stateArray;
        }

        @NotNull
        public String getTerm() {
            String string = StringUtil.toLowerCase((String)this.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toLowerCase(name)");
            return string;
        }

        public final boolean getWithGrantOption() {
            return this == GRANT_WITH_GRANT_OPTION;
        }

        public final char getCode() {
            return this.code;
        }

        private State(char code) {
            this.code = code;
        }

        public /* synthetic */ State(String $enum$name, int $enum$ordinal, char code, DefaultConstructorMarker $constructor_marker) {
            this(code);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/properties/Grants$State$GRANT_WITH_GRANT_OPTION;", "Lcom/intellij/database/model/properties/Grants$State;", "term", "", "getTerm", "()Ljava/lang/String;", "intellij.database.core.impl"})
        static final class GRANT_WITH_GRANT_OPTION
        extends State {
            @Override
            @NotNull
            public String getTerm() {
                return GRANT.getTerm();
            }

            /*
             * WARNING - void declaration
             */
            GRANT_WITH_GRANT_OPTION() {
                void var1_1;
            }
        }
    }
}

