/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaReference<S extends BasicElement, T extends BasicElement> {
    private static final Interner<BasicMetaReference<?, ?>> ourInterner = new WeakInterner(new TObjectHashingStrategy<BasicMetaReference<?, ?>>(){

        public int computeHashCode(BasicMetaReference<?, ?> o) {
            return Objects.hash(o.name, o.slowResolver);
        }

        public boolean equals(BasicMetaReference<?, ?> o1, BasicMetaReference<?, ?> o2) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null || o1.getClass() != o2.getClass()) {
                return false;
            }
            return Objects.equals(o1.name, o2.name) && Objects.equals(o1.slowResolver, o2.slowResolver);
        }
    });
    public final String name;
    public final MethodHandle resolver;
    private final Method slowResolver;

    public BasicMetaReference(String name, Method resolver) {
        this.name = name;
        this.slowResolver = resolver;
        try {
            this.resolver = MethodHandles.publicLookup().unreflect(resolver);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public T resolve(S source) {
        try {
            return (T)this.resolver.invoke((BasicElement)source);
        }
        catch (Throwable th) {
            ExceptionUtil.rethrow((Throwable)th);
            return null;
        }
    }

    private static <S extends BasicElement, T extends BasicElement> BasicMetaReference<S, T> intern(BasicMetaReference<S, T> ref) {
        return (BasicMetaReference)ourInterner.intern(ref);
    }

    public static <S extends BasicElement, T extends BasicElement> BasicMetaReference<S, T> create(@NonNls String name, Class<? extends BasicElement> modApi) {
        String getterName = "get" + name;
        return BasicMetaReference.createImpl(name, modApi, getterName);
    }

    @NotNull
    private static <S extends BasicElement, T extends BasicElement> BasicMetaReference<S, T> createImpl(@NonNls String name, Class<?> modApi, String getterName) {
        BasicMetaReference<S, T> basicMetaReference;
        try {
            Method getter = BasicMetaProperty.getBaseMethod(modApi, getterName, new Class[0]);
            basicMetaReference = BasicMetaReference.intern(new BasicMetaReference<S, T>(name, getter));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("model error", e);
        }
        if (basicMetaReference == null) {
            BasicMetaReference.$$$reportNull$$$0(0);
        }
        return basicMetaReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/meta/BasicMetaReference", "createImpl"));
    }
}

