/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaObject<M extends BasicModElement> {
    private static final BasicMetaObject<?>[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty<?>[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    private static final BasicMetaReference<?, ?>[] EMPTY_REFS_ARRAY = new BasicMetaReference[0];
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Supplier<? extends M> dataFactory;
    public final BiConsumer<M, Map<String, String>> dataDeserializer;
    public final BasicMetaProperty<?>[] properties;
    public final BasicMetaReference<M, ?>[] references;
    private final Object[] defaults;
    private final long reverseInternal;
    public final BasicMetaObject<?>[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Supplier<? extends M> dataFactory, BiConsumer<M, Map<String, String>> dataDeserializer, BasicMetaProperty<?>[] properties, BasicMetaReference<M, ?>[] references, Object[] defaults, long reverseInternal, BasicMetaObject<?>[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.dataFactory = dataFactory;
        this.dataDeserializer = dataDeserializer;
        this.properties = properties == null ? EMPTY_PROPS_ARRAY : properties;
        this.references = references == null ? EMPTY_REFS_ARRAY : references;
        this.defaults = defaults == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : defaults;
        this.reverseInternal = reverseInternal;
        for (BasicMetaObject<?> child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            assert (child.myParent == null);
            child.myParent = this;
        }
        assert (this.properties.length == this.defaults.length);
    }

    @Nullable
    public BasicMetaObject<?> getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public ObjectKind getParentKind(int i2) {
        BasicMetaObject<?> cur2;
        for (cur2 = this; i2 > 0 && cur2 != null; cur2 = cur2.getParent(), --i2) {
        }
        return cur2 == null ? null : cur2.kind;
    }

    @NotNull
    public BasicMetaModel<?> getModel() {
        Object parent2 = this.myParent;
        while (parent2 instanceof BasicMetaObject) {
            parent2 = ((BasicMetaObject)parent2).myParent;
        }
        BasicMetaModel basicMetaModel = (BasicMetaModel)parent2;
        if (basicMetaModel == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    void setModel(@NotNull BasicMetaModel<?> model) {
        if (model == null) {
            BasicMetaObject.$$$reportNull$$$0(1);
        }
        assert (this.myParent == null);
        this.myParent = model;
    }

    public boolean kindOf(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.apiClass);
    }

    public <T extends BasicModElement> BasicMetaObject<T> tryCast(@Nullable Class<T> clazz) {
        return this.kindOf(clazz) ? this : null;
    }

    @NotNull
    public M newDataObject() {
        BasicModElement basicModElement = (BasicModElement)this.dataFactory.get();
        if (basicModElement == null) {
            BasicMetaObject.$$$reportNull$$$0(2);
        }
        return (M)basicModElement;
    }

    public <T> T getDefault(@NotNull BasicMetaProperty<T> property) {
        if (property == null) {
            BasicMetaObject.$$$reportNull$$$0(3);
        }
        return this.getDefault(property, -1);
    }

    public <T> T getDefault(@NotNull BasicMetaProperty<T> property, int hint) {
        if (property == null) {
            BasicMetaObject.$$$reportNull$$$0(4);
        }
        return (T)this.defaults[this.indexOf(property, hint)];
    }

    public boolean isInternal(@NotNull BasicMetaProperty<?> property) {
        if (property == null) {
            BasicMetaObject.$$$reportNull$$$0(5);
        }
        return this.isInternal(property, -1);
    }

    public boolean isInternal(@NotNull BasicMetaProperty<?> property, int hint) {
        int idx;
        int revIdx;
        if (property == null) {
            BasicMetaObject.$$$reportNull$$$0(6);
        }
        return (this.reverseInternal & 1L << (revIdx = this.properties.length - (idx = this.indexOf(property, hint)) - 1)) != 0L;
    }

    private int indexOf(@NotNull BasicMetaProperty<?> property, int hint) {
        if (property == null) {
            BasicMetaObject.$$$reportNull$$$0(7);
        }
        if (hint != -1) {
            if (this.properties[hint] != property) {
                throw new AssertionError((Object)("Wrong hint for " + property + " in " + this));
            }
            return hint;
        }
        int idx = ArrayUtil.indexOf((Object[])this.properties, property);
        if (idx == -1) {
            throw new AssertionError((Object)("No " + property + " in " + this));
        }
        return idx;
    }

    @NotNull
    public String toString() {
        if (this.myParent instanceof BasicMetaObject) {
            String string = this.myParent + "." + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (this.myParent instanceof BasicMetaModel) {
            String string = ((BasicMetaModel)this.myParent).dbms.getDisplayName() + ": " + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.kind.code();
        if (string == null) {
            BasicMetaObject.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataObject";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

