/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.diff.DbDiffCheckOption;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.diff.DbMigrationAction;
import com.intellij.database.model.diff.SchemaDiffRequest;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDiffAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Pair<DbElement, DbElement> elements = SchemaDiffAction.getElements(e);
        e.getPresentation().setEnabled(project != null && elements != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Pair<DbElement, DbElement> pair = SchemaDiffAction.getElements(e);
        if (pair == null) {
            return;
        }
        DirDiffSettings settings = SchemaDiffAction.createSettings(((DbElement)pair.first).getDataSource().getDbms(), ((DbElement)pair.second).getDataSource().getDbms());
        Couple<DbDiffElement> elements = SchemaDiffAction.createElements((DbElement)pair.first, (DbElement)pair.second, settings);
        SchemaDiffRequest request = new SchemaDiffRequest((DbDiffElement)((Object)elements.first), (DbDiffElement)((Object)elements.second));
        DiffManager.getInstance().showDiff(project, (DiffRequest)request);
    }

    @NotNull
    public static DirDiffSettings createSettings(@NotNull Dbms dbms1, @NotNull Dbms dbms2) {
        if (dbms1 == null) {
            SchemaDiffAction.$$$reportNull$$$0(2);
        }
        if (dbms2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(3);
        }
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.enableSyncActions = false;
        DefaultActionGroup options = new DefaultActionGroup(DatabaseBundle.message((String)"action.options.text", (Object[])new Object[0]), true);
        options.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        SchemaDiffAction.addActionOption(settings, "IGNORE_ORDER", DatabaseBundle.message((String)"action.ignore.order.text", (Object[])new Object[0]), "alt O", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_CASE", DatabaseBundle.message((String)"action.ignore.case.text", (Object[])new Object[0]), "alt C", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_SOURCE_CODE", DatabaseBundle.message((String)"action.ignore.source.code.text", (Object[])new Object[0]), "alt S", options);
        if (ScriptingOptionStatic.IGNORE_OWNER.getApplicableDbs().value((Object)dbms1) || ScriptingOptionStatic.IGNORE_OWNER.getApplicableDbs().value((Object)dbms2)) {
            SchemaDiffAction.addActionOption(settings, "PG_IGNORE_OWNER", DatabaseBundle.message((String)"action.ignore.owner.text", (Object[])new Object[0]), "alt W", options);
        }
        if (ScriptingOptionStatic.IGNORE_DEFINER.getApplicableDbs().value((Object)dbms1) || ScriptingOptionStatic.IGNORE_DEFINER.getApplicableDbs().value((Object)dbms2)) {
            SchemaDiffAction.addActionOption(settings, "MYSQL_IGNORE_DEFINER", DatabaseBundle.message((String)"action.ignore.definer.text", (Object[])new Object[0]), "alt D", options);
        }
        settings.addExtraAction((AnAction)options);
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        DirDiffSettings dirDiffSettings = settings;
        if (dirDiffSettings == null) {
            SchemaDiffAction.$$$reportNull$$$0(4);
        }
        return dirDiffSettings;
    }

    private static void addActionOption(DirDiffSettings settings, String key, @NlsActions.ActionText String text2, String shortcut, DefaultActionGroup options) {
        settings.customSettings.put(key, DbDiffCheckOption.getOption(key));
        options.add((AnAction)new DbDiffCheckOption(key, text2, shortcut));
    }

    @NotNull
    public static Couple<DbDiffElement> createElements(DbElement e1, DbElement e2, DirDiffSettings settings) {
        BasicElement b1 = (BasicElement)e1.getDelegate();
        BasicElement b2 = (BasicElement)e2.getDelegate();
        boolean stepUp = DbDiffElement.isContainer(b1) || DbDiffElement.isContainer(b2);
        Couple couple = Couple.of((Object)((Object)SchemaDiffAction.createElement(e1, settings, e2, stepUp)), (Object)((Object)SchemaDiffAction.createElement(e2, settings, e1, stepUp)));
        if (couple == null) {
            SchemaDiffAction.$$$reportNull$$$0(5);
        }
        return couple;
    }

    @NotNull
    public static DbDiffElement createElement(DbElement element2, DirDiffSettings settings, DbElement other, boolean stepUp) {
        Dbms dbms = DbImplUtil.getDbms((BasicElement)other.getDelegate());
        BasicElement e = (BasicElement)element2.getDelegate();
        BasicElement realRoot = stepUp || e.getParent() == null ? e : e.getParent();
        DbDiffRoot root2 = new DbDiffRoot(element2.getDataSource(), settings, dbms, e);
        return new DbDiffElement(root2, realRoot, SchemaDiffAction.createAltElement(root2.getAltModel(), realRoot));
    }

    private static BasicModElement createAltElement(@Nullable BasicModModel model, BasicElement e) {
        if (model == null) {
            return null;
        }
        BasicMetaObject<?> meta = model.getMetaModel().findBestMetaObject(e.getMetaObject());
        if (meta == null) {
            return null;
        }
        Ref res2 = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            res2.set((Object)SchemaDiffAction.instantiate(r, meta));
            if (res2.isNull()) {
                BasicModMixinElement.dropChildren(r);
            }
        });
        return (BasicModElement)res2.get();
    }

    @Nullable
    private static BasicModElement instantiate(@NotNull BasicModElement o, @NotNull BasicMetaObject<?> meta) {
        if (o == null) {
            SchemaDiffAction.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            SchemaDiffAction.$$$reportNull$$$0(7);
        }
        if (meta.kind == o.getKind()) {
            return o;
        }
        BasicMetaObject<?> p2 = meta.getParent();
        BasicModElement parent2 = p2 == null ? null : SchemaDiffAction.instantiate(o, p2);
        ModFamily family = parent2 == null ? null : parent2.familyOf(meta.kind);
        return family == null ? null : (BasicModElement)family.createNewOne();
    }

    @Nullable
    private static Pair<DbElement, DbElement> getElements(AnActionEvent e) {
        DbElement e2;
        DbElement e1;
        block7: {
            DbElement same;
            PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
            if (elements == null || elements.length != 2 || !(elements[0] instanceof DbElement) || !(elements[1] instanceof DbElement)) {
                return null;
            }
            e1 = (DbElement)elements[0];
            e2 = (DbElement)elements[1];
            HashMap<ObjectKind, DbElement> possible1 = new HashMap<ObjectKind, DbElement>();
            HashMap<ObjectKind, DbElement> possible2 = new HashMap<ObjectKind, DbElement>();
            e1 = SchemaDiffAction.fillPossible(e1, possible1);
            e2 = SchemaDiffAction.fillPossible(e2, possible2);
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p2 = e1.getParent();
                if (p2 != null && possible1.containsKey(p2.getKind())) {
                    e1 = p2;
                    continue;
                }
                break block7;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        if (!(e1.getDelegate() instanceof BasicElement)) {
            return null;
        }
        if (!(e2.getDelegate() instanceof BasicElement)) {
            return null;
        }
        return Pair.create((Object)e1, (Object)e2);
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Map<ObjectKind, DbElement> pos) {
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(8);
        }
        if (pos == null) {
            SchemaDiffAction.$$$reportNull$$$0(9);
        }
        if (DasUtil.getParentOfKind((DasObject)el, (ObjectKind)ObjectKind.SCHEMA, (boolean)true) == null) {
            DbElement tmp2 = el;
            while (tmp2 != null) {
                pos.put(tmp2.getKind(), tmp2);
                el = tmp2;
                tmp2 = tmp2.getKind() == ObjectKind.SCHEMA ? null : (DbElement)tmp2.getDasChildren(null).single();
            }
            return el;
        }
        pos.put(el.getKind(), el);
        return el;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms2";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

