/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameBasedRelationProvider
implements ModelRelationManager.ModelRelationProvider {
    public static final String ID = "ByName";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target) {
        DasObject parent2;
        JBIterable matches;
        if (table == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(0);
        }
        if ((matches = JBIterable.from(NameBasedRelationSettings.getInstance().getCompiledRules())).isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NameBasedRelationProvider.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable queries = DasUtil.getColumns((DasObject)table).flatten(col -> matches.filterMap(e -> FkSearchQuery.create(table, col, (Pattern)e.first, (String)e.second))).collect();
        if (queries.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NameBasedRelationProvider.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        JBIterable tables = target == null ? ((parent2 = table.getDasParent()) == null ? JBIterable.of((Object)table) : parent2.getDasChildren(null).filter(DasTable.class)) : JBIterable.of((Object)target);
        tables = tables.transform(DbSqlUtilCore.checkCancelled(100));
        JBIterable jBIterable = tables.flatten(tgt -> {
            JBIterable acceptable = queries.filter(q -> q.matches((DasTable)tgt)).collect();
            return acceptable.isEmpty() ? JBIterable.empty() : DasUtil.getColumns((DasObject)tgt).filterMap(col -> (DasForeignKey)acceptable.filterMap(q -> q.matches((DasColumn)col) ? q.createFk((DasTable)tgt, (DasColumn)col) : null).first());
        });
        if (jBIterable == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/NameBasedRelationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Rule
    implements Comparable<Rule> {
        @Attribute(value="MATCH")
        @NotNull
        public String match;
        @Attribute(value="REPLACE")
        @NotNull
        public String replace;

        public Rule() {
            this("", "");
        }

        public Rule(@NotNull String match2, @NotNull String replace) {
            if (match2 == null) {
                Rule.$$$reportNull$$$0(0);
            }
            if (replace == null) {
                Rule.$$$reportNull$$$0(1);
            }
            this.match = match2;
            this.replace = replace;
        }

        @Override
        public int compareTo(@NotNull Rule o) {
            int res2;
            if (o == null) {
                Rule.$$$reportNull$$$0(2);
            }
            if ((res2 = Comparing.compare((Comparable)((Object)this.match), (Comparable)((Object)o.match))) != 0) {
                return res2;
            }
            return Comparing.compare((Comparable)((Object)this.replace), (Comparable)((Object)o.replace));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "match";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider$Rule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="NameBasedRelationSettings", storages={@Storage(value="editor.xml")})
    @Service
    public static final class NameBasedRelationSettings
    implements PersistentStateComponent<NameBasedRelationSettings> {
        @Tag(value="FK_RULES")
        @XCollection(elementName="fk-rules")
        private Set<Rule> myFkRules = new TreeSet<Rule>(Collections.singleton(new Rule("(.*)_(?i)id", "$1\\\\.(?i)id")));
        @Transient
        private List<Pair<Pattern, String>> myCompiledRules = null;

        public static NameBasedRelationSettings getInstance() {
            return (NameBasedRelationSettings)ApplicationManager.getApplication().getService(NameBasedRelationSettings.class);
        }

        public NameBasedRelationSettings getState() {
            return this;
        }

        public void loadState(@NotNull NameBasedRelationSettings state) {
            if (state == null) {
                NameBasedRelationSettings.$$$reportNull$$$0(0);
            }
            XmlSerializerUtil.copyBean((Object)state, (Object)this);
        }

        public void setFkRules(Set<Rule> rules) {
            if (rules.equals(this.myFkRules)) {
                return;
            }
            this.myFkRules = rules;
            this.myCompiledRules = null;
        }

        public Set<Rule> getFkRules() {
            return this.myFkRules;
        }

        public List<Pair<Pattern, String>> getCompiledRules() {
            if (this.myCompiledRules == null) {
                this.myCompiledRules = new ArrayList<Pair<Pattern, String>>(this.myFkRules.size());
                for (Rule rule : this.myFkRules) {
                    try {
                        ContainerUtil.addIfNotNull(this.myCompiledRules, NameBasedRelationSettings.compile(rule));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
            }
            return this.myCompiledRules;
        }

        @Nullable
        public static Pair<Pattern, String> compile(Rule rule) {
            if (StringUtil.isEmpty((String)rule.match) || StringUtil.isEmpty((String)rule.replace)) {
                return null;
            }
            Pattern pattern = Pattern.compile(rule.match);
            return Pair.create((Object)pattern, (Object)rule.replace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/model/NameBasedRelationProvider$NameBasedRelationSettings", "loadState"));
        }
    }

    public static final class FkSearchQuery {
        private final DasTable myTable;
        private final DasColumn myCol;
        private final Pattern myTableLookup;
        private final Pattern myColLookup;

        private FkSearchQuery(DasTable table, DasColumn col, Pattern tableLookup, Pattern colLookup) {
            this.myTable = table;
            this.myCol = col;
            this.myTableLookup = tableLookup;
            this.myColLookup = colLookup;
        }

        private boolean matches(@NotNull DasTable refTable) {
            String tab;
            if (refTable == null) {
                FkSearchQuery.$$$reportNull$$$0(0);
            }
            return FkSearchQuery.matchesTable(this.myTableLookup, tab = refTable.getName());
        }

        private boolean matches(@NotNull DasColumn refCol) {
            String col;
            if (refCol == null) {
                FkSearchQuery.$$$reportNull$$$0(1);
            }
            if (!FkSearchQuery.matchesColumn(this.myColLookup, col = refCol.getName())) {
                return false;
            }
            DasTable refTable = refCol.getTable();
            String tab = DasUtil.getName((DasObject)refTable);
            return DasUtil.getForeignKeys((DasTable)this.myTable).filter(f -> Objects.equals(f.getRefTableName(), tab) && JBIterable.from((Iterable)f.getColumnsRef().resolveObjects()).single() == this.myCol && f.getRefTable() == refTable && JBIterable.from((Iterable)f.getRefColumns().resolveObjects()).single() == refCol).isEmpty();
        }

        public static boolean matchesTable(Pattern lookup, String tab) {
            if (lookup.matcher(tab).matches()) {
                return true;
            }
            String single = StringUtil.unpluralize((String)tab);
            return single != null && !single.equals(tab) && lookup.matcher(single).matches();
        }

        public static boolean matchesColumn(Pattern lookup, String col) {
            return lookup.matcher(col).matches();
        }

        @Nullable
        private static FkSearchQuery create(DasTable table, DasColumn col, Pattern pat, String repl) {
            String name = col.getName();
            try {
                Pair<String, String> lookup = FkSearchQuery.buildLookup(pat, repl, name);
                return lookup == null ? null : new FkSearchQuery(table, col, Pattern.compile((String)lookup.first), Pattern.compile((String)lookup.second));
            }
            catch (PatternSyntaxException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static Pair<String, String> buildLookup(Pattern pat, String repl, String name) {
            Matcher matcher = pat.matcher(name);
            if (!matcher.matches()) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            matcher.appendReplacement(buf, repl);
            int i2 = buf.indexOf("\\.");
            if (i2 == -1) {
                throw new IllegalArgumentException("Lookup should contain \\.");
            }
            return Pair.create((Object)buf.substring(0, i2), (Object)buf.substring(i2 + 2));
        }

        @NotNull
        private DasForeignKey createFk(@NotNull DasTable refTable, final @NotNull DasColumn refColumn) {
            if (refTable == null) {
                FkSearchQuery.$$$reportNull$$$0(2);
            }
            if (refColumn == null) {
                FkSearchQuery.$$$reportNull$$$0(3);
            }
            return new ModelRelationManager.ExtraRelation(this.myTable, refTable){

                @Override
                public String getProviderId() {
                    return NameBasedRelationProvider.ID;
                }

                @NotNull
                public MultiRef<? extends DasTypedObject> getRefColumns() {
                    MultiRef multiRef = DasUtil.asRef(Collections.singleton(refColumn));
                    if (multiRef == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return multiRef;
                }

                @NotNull
                public MultiRef<? extends DasTypedObject> getColumnsRef() {
                    MultiRef multiRef = DasUtil.asRef(Collections.singleton(myCol));
                    if (multiRef == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return multiRef;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/model/NameBasedRelationProvider$FkSearchQuery$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRefColumns";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getColumnsRef";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refTable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refCol";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumn";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider$FkSearchQuery";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

