/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasExternal;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelRelationManager {
    private static final ExtensionPointName<ModelRelationProvider> EP = ExtensionPointName.create((String)"com.intellij.database.modelRelationProvider");

    @NotNull
    public static JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @NotNull DasTable target) {
        if (table == null) {
            ModelRelationManager.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ModelRelationManager.$$$reportNull$$$0(1);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)EP.getExtensionList()).flatten(p2 -> p2.getForeignKeys(project, table, target));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @Nullable DasTable table) {
        JBIterable jBIterable = table == null ? JBIterable.empty() : JBIterable.from((Iterable)EP.getExtensionList()).flatten(p2 -> p2.getForeignKeys(project, table, null));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasForeignKey> getExportedKeys(@Nullable Project project, @Nullable DasTable table) {
        if (table == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ModelRelationManager.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        ArrayList<ModelRelationProvider> toCompute = new ArrayList<ModelRelationProvider>();
        JBIterable result = JBIterable.empty();
        for (ModelRelationProvider provider : EP.getExtensionList()) {
            JBIterable<DasForeignKey> exported = provider.getExportedKeys(project, table);
            if (exported == null) {
                toCompute.add(provider);
                continue;
            }
            result = result.append(exported);
        }
        JBIterable jBIterable = toCompute.isEmpty() ? result : result.append(ModelRelationManager.computeExported(project, table, toCompute));
        if (jBIterable == null) {
            ModelRelationManager.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static JBIterable<DasForeignKey> computeExported(@Nullable Project project, @NotNull DasTable table, @NotNull List<ModelRelationProvider> providers) {
        if (table == null) {
            ModelRelationManager.$$$reportNull$$$0(6);
        }
        if (providers == null) {
            ModelRelationManager.$$$reportNull$$$0(7);
        }
        Dbms dbms = DbImplUtilCore.getDbms((DasObject)table);
        DasObject sc = DasUtil.getSchemaObject((DasObject)table);
        DasTable searchRoot = sc == null ? table : (DasObject)ObjectUtils.notNull((Object)sc.getDasParent(), (Object)sc);
        BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dbms);
        Set toExpand = metaModel.findMetaObjects(ObjectKind.FOREIGN_KEY).flatten(mo -> JBIterable.generate(mo.getParent(), o -> o.getParent())).map(o -> o.kind).toSet();
        JBIterable iterProviders = JBIterable.from(providers);
        return ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)searchRoot)).expand(o -> toExpand.contains(o.getKind()))).filter(DasTable.class).flatten(src -> iterProviders.flatten(provider -> provider.getForeignKeys(project, (DasTable)src, table)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelRelationManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelRelationManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeys";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeExported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ExtraRelation
    implements DasForeignKey,
    DasExternal {
        private final DasTable myTable;
        private final DasTable myRefTable;

        public ExtraRelation(@NotNull DasTable table, @NotNull DasTable refTable) {
            if (table == null) {
                ExtraRelation.$$$reportNull$$$0(0);
            }
            if (refTable == null) {
                ExtraRelation.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.myRefTable = refTable;
        }

        public boolean isQuoted() {
            return true;
        }

        public String getRefTableName() {
            return this.myRefTable.getName();
        }

        public String getRefTableSchema() {
            return DasUtil.getSchema((DasObject)this.myRefTable);
        }

        public String getRefTableCatalog() {
            return DasUtil.getCatalog((DasObject)this.myRefTable);
        }

        @Nullable
        public DasTable getRefTable() {
            return this.myRefTable;
        }

        public DasForeignKey.RuleAction getDeleteRule() {
            return null;
        }

        public DasForeignKey.RuleAction getUpdateRule() {
            return null;
        }

        public DasForeignKey.Deferrability getDeferrability() {
            return null;
        }

        @Nullable
        public DasTable getTable() {
            return this.myTable;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            if (objectKind == null) {
                ExtraRelation.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                ExtraRelation.$$$reportNull$$$0(3);
            }
            return string;
        }

        public abstract String getProviderId();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refTable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelRelationManager$ExtraRelation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelRelationManager$ExtraRelation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DasForeignKeys
    implements ModelRelationProvider {
        public static final String ID = "DAS";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target) {
            if (table == null) {
                DasForeignKeys.$$$reportNull$$$0(0);
            }
            JBIterable res2 = DasUtil.getForeignKeys((DasTable)table);
            JBIterable jBIterable = target == null ? res2 : res2.filter(fk -> this.isReferenceTo((DasForeignKey)fk, target));
            if (jBIterable == null) {
                DasForeignKeys.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        protected boolean isReferenceTo(@NotNull DasForeignKey fk, @NotNull DasTable target) {
            if (fk == null) {
                DasForeignKeys.$$$reportNull$$$0(2);
            }
            if (target == null) {
                DasForeignKeys.$$$reportNull$$$0(3);
            }
            return target.getName().equals(fk.getRefTableName()) && fk.getRefTable() == target;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelRelationManager$DasForeignKeys";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelRelationManager$DasForeignKeys";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getForeignKeys";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ModelRelationProvider {
        public String getId();

        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project var1, @NotNull DasTable var2, @Nullable DasTable var3);

        @Nullable(value="Compute from FK's")
        default public @Nullable(value="Compute from FK's") JBIterable<DasForeignKey> getExportedKeys(@Nullable Project project, @NotNull DasTable table) {
            if (table == null) {
                ModelRelationProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/model/ModelRelationManager$ModelRelationProvider", "getExportedKeys"));
        }
    }
}

