/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModLikeColumn;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSynonym;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelHelperCore {
    public static final ObjectKindVariant DEFAULT = new ObjectKindVariant(() -> "");
    public static final ObjectKindVariant FUNCTION = new ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.function", (Object[])new Object[0]));
    public static final ObjectKindVariant PROCEDURE = new ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.procedure", (Object[])new Object[0]));

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind) {
        if (kind == null) {
            ModelHelperCore.$$$reportNull$$$0(0);
        }
        return DbPresentationCore.getIcon(kind);
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            ModelHelperCore.$$$reportNull$$$0(1);
        }
        ObjectKind kind = c2.getKind();
        if (c2 instanceof PsiElement && !((PsiElement)c2).isValid()) {
            return this.getIcon(kind);
        }
        if (kind == ObjectKind.COLUMN && c2 instanceof DasColumn) {
            return this.getColumnIcon((DasColumn)c2);
        }
        if (kind == ObjectKind.KEY && c2 instanceof DasTableKey) {
            return ((DasTableKey)c2).isPrimary() ? DatabaseIcons.GoldKey : DatabaseIcons.GoldKeyAlt;
        }
        if (kind == ObjectKind.FOREIGN_KEY && c2 instanceof DasForeignKey) {
            DasForeignKey.RuleAction r1 = ((DasForeignKey)c2).getUpdateRule();
            DasForeignKey.RuleAction r2 = ((DasForeignKey)c2).getDeleteRule();
            return r1 != null && r1 != DasForeignKey.RuleAction.NO_ACTION || r2 != null && r2 != DasForeignKey.RuleAction.NO_ACTION ? DatabaseIcons.BlueKeyTrigger : DatabaseIcons.BlueKey;
        }
        if (kind == ObjectKind.INDEX && c2 instanceof DasIndex) {
            DasIndex index2 = (DasIndex)c2;
            return index2.isUnique() ? (index2.isFunctionBased() ? DatabaseIcons.IndexUniqueFun : DatabaseIcons.IndexUnique) : (index2.isFunctionBased() ? DatabaseIcons.IndexFun : DatabaseIcons.Index);
        }
        if (kind != ObjectKind.SCRIPT && kind != ObjectKind.AGGREGATE && kind != ObjectKind.MACRO && c2 instanceof DasRoutine) {
            DasRoutine.Kind k = ((DasRoutine)c2).getRoutineKind();
            return k == DasRoutine.Kind.PROCEDURE ? DatabaseIcons.Procedure : (k == DasRoutine.Kind.FUNCTION ? DatabaseIcons.Function : DatabaseIcons.Routine);
        }
        if (kind == ObjectKind.CLUSTER && c2 instanceof DasCluster) {
            ClusterType clusterType = ((DasCluster)c2).getClusterType();
            return clusterType == ClusterType.INDEX ? DatabaseIcons.IndexCluster : (clusterType == ClusterType.HASH ? DatabaseIcons.HashCluster : DatabaseIcons.UnspecifiedCluster);
        }
        return this.getIcon(kind);
    }

    protected Icon getColumnIcon(@NotNull DasColumn c2) {
        DasTable table;
        if (c2 == null) {
            ModelHelperCore.$$$reportNull$$$0(2);
        }
        Set attrs = (table = c2.getTable()) == null ? Collections.emptySet() : table.getColumnAttrs(c2);
        boolean pinned = c2.isNotNull();
        boolean inIndex = attrs.contains(DasColumn.Attribute.INDEX);
        boolean pk = attrs.contains(DasColumn.Attribute.PRIMARY_KEY);
        boolean fk = attrs.contains(DasColumn.Attribute.FOREIGN_KEY);
        if (pk && fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldBlueKeyDotIndex : DatabaseIcons.ColGoldBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldBlueKeyIndex : DatabaseIcons.ColGoldBlueKey;
        }
        if (pk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldKeyDotIndex : DatabaseIcons.ColGoldKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldKeyIndex : DatabaseIcons.ColGoldKey;
        }
        if (fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColBlueKeyDotIndex : DatabaseIcons.ColBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColBlueKeyIndex : DatabaseIcons.ColBlueKey;
        }
        if (pinned) {
            return inIndex ? DatabaseIcons.ColDotIndex : DatabaseIcons.ColDot;
        }
        return inIndex ? DatabaseIcons.ColIndex : DatabaseIcons.Col;
    }

    @Nls
    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        if (kind == null) {
            ModelHelperCore.$$$reportNull$$$0(3);
        }
        String string = kind == ObjectKind.ROOT ? DatabaseBundle.message((String)"ObjectKind.data.source", (Object[])new Object[0]) : kind.getPresentableName();
        if (string == null) {
            ModelHelperCore.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @Nullable
    public String nodeTriggerSuffix(@NotNull BasicTrigger o) {
        if (o == null) {
            ModelHelperCore.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public String nodeTableSuffix(@NotNull BasicTable delegate) {
        if (delegate == null) {
            ModelHelperCore.$$$reportNull$$$0(6);
        }
        return null;
    }

    @NotNull
    public JBIterable<ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            ModelHelperCore.$$$reportNull$$$0(7);
        }
        if (meta.kind == ObjectKind.ROUTINE) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKindVariant[]{FUNCTION, PROCEDURE});
            if (jBIterable == null) {
                ModelHelperCore.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)DEFAULT);
        if (jBIterable == null) {
            ModelHelperCore.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        BasicModNamedElement namedParent;
        if (e == null) {
            ModelHelperCore.$$$reportNull$$$0(10);
        }
        if (variant == null) {
            ModelHelperCore.$$$reportNull$$$0(11);
        }
        if (vars == null) {
            ModelHelperCore.$$$reportNull$$$0(12);
        }
        String name = this.generateTemplateName(e.getKind());
        if (e instanceof BasicModNamedElement) {
            this.setTemplateName((BasicModNamedElement)e, name);
            vars.put(name, name);
        }
        if (e instanceof BasicModView) {
            String query = "select * from my_table";
            ((BasicModView)e).setSourceText(new SimpleCompositeText((CharSequence)query, CompositeText.Kind.COMPACT_DEFINITION));
            vars.put("src", query);
        }
        BasicElement parent2 = e.getParent();
        if (e.getKind() == ObjectKind.BODY && (namedParent = (BasicModNamedElement)ObjectUtils.tryCast((Object)parent2, BasicModNamedElement.class)) != null) {
            this.setTemplateName(namedParent, name);
        }
        if (parent2 instanceof BasicModLikeTable) {
            String pName = this.generateTemplateName(parent2.getKind());
            this.setTemplateName((BasicModLikeTable)parent2, pName);
            vars.put(pName, pName);
        }
        if (e instanceof BasicModTrigger) {
            ((BasicModTrigger)e).setTurn(TrigTurn.AFTER_STMT);
            vars.put("turn", "after");
            ((BasicModTrigger)e).setEvents(Collections.singleton(TrigEvent.INSERT));
            vars.put("event", "insert");
            vars.put("for_each", "statement");
        }
        if (e instanceof BasicModIndex) {
            BasicModLikeTable tab = (BasicModLikeTable)e.getParent();
            if (tab != null) {
                BasicModLikeColumn col = (BasicModLikeColumn)tab.getColumns().createNewOne();
                this.setTemplateName(col, "idx_column");
            }
            ((BasicModIndex)e).setColNames(new String[]{"idx_column"});
            vars.put("idx_columns", "idx_column");
        }
        if (e instanceof BasicModSynonym) {
            ((BasicModSynonym)e).setTargetObjectKind(ObjectKind.TABLE);
            vars.put("synonym_target_kind", "table");
            ((BasicModSynonym)e).setTargetObjectName("synonym_target");
            vars.put("synonym_target", "synonym_target");
        }
        if (e instanceof BasicModRoutine) {
            BasicModRoutine r = (BasicModRoutine)e;
            boolean isFunc = variant == FUNCTION;
            r.setRoutineKind(isFunc ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            BasicModArgument arg = (BasicModArgument)r.getArguments().createNewOne();
            this.setTemplateName(arg, "arg1");
            String type = DbImplUtilCore.getDbms(e).is(Dbms.BIGQUERY) ? "int64" : "int";
            arg.setDataType(DataTypeFactory.of(type));
            vars.put("args", "arg1 " + type);
            if (isFunc) {
                r.createOrGetReturnArgument().setDataType(DataTypeFactory.of("varchar"));
                vars.put("return", "varchar");
            }
        }
    }

    @NotNull
    protected String generateTemplateName(@NotNull ObjectKind expKind) {
        if (expKind == null) {
            ModelHelperCore.$$$reportNull$$$0(13);
        }
        String kindName = this.getName(expKind);
        String string = StringUtil.toLowerCase((String)kindName.replace(' ', '_')) + "_name";
        if (string == null) {
            ModelHelperCore.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected void setTemplateName(BasicModNamedElement named, String name) {
        named.setName(name);
        named.setNameQuoted(false);
        named.setNameScripted(true);
    }

    public @Nullable Pair<@Nls String, String> getDocumentationLink(@NotNull BasicElement element2) {
        if (element2 == null) {
            ModelHelperCore.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public Grants.Controller<?, ?> getGrantController() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelHelperCore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expKind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelHelperCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generationVariants";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTemplateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nodeTriggerSuffix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nodeTableSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generationVariants";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillPropertiesWithExamples";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplateName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ObjectKindVariant {
        private final Supplier<@Nls String> myDisplayName;

        public ObjectKindVariant(Supplier<@Nls String> name) {
            this.myDisplayName = name;
        }

        @Nls
        public String getText() {
            return this.myDisplayName.get();
        }
    }
}

