/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelHelper
extends ModelHelperCore {
    public static final ModelHelperCore DUMMY = new ModelHelper(){};

    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        if (helper == null) {
            ModelHelper.$$$reportNull$$$0(0);
        }
        if (from == null) {
            ModelHelper.$$$reportNull$$$0(1);
        }
        if (to == null) {
            ModelHelper.$$$reportNull$$$0(2);
        }
        to.setDefaultExpression(from.defaultValue);
        boolean autoInc = from.flags.contains((Object)DeColumn.Flag.AUTO_INC);
        BasicTableColumn e = (BasicTableColumn)ObjectUtils.tryCast((Object)from.unwrap(), BasicTableColumn.class);
        SequenceIdentity se = e == null ? null : e.getSequenceIdentity();
        to.setSequenceIdentity(autoInc ? (SequenceIdentity)ObjectUtils.notNull((Object)se, (Object)SequenceIdentity.UNKNOWN) : null);
    }

    public void exportLightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
        Set attrs;
        if (helper == null) {
            ModelHelper.$$$reportNull$$$0(3);
        }
        if (to == null) {
            ModelHelper.$$$reportNull$$$0(4);
        }
        if (from == null) {
            ModelHelper.$$$reportNull$$$0(5);
        }
        if ((attrs = from.getTable().getColumnAttrs(from)).contains(DasColumn.Attribute.AUTO_GENERATED)) {
            to.flags.add(DeColumn.Flag.AUTO_INC);
        }
    }

    public boolean gridColumnHasDefaultValue(BasicElement column2) {
        return false;
    }

    public int getJdbcType(BasicTypedElement element2) {
        return element2.getDataType().jdbcType;
    }

    public DasTable sqlCreateFakeTable(String catalog, String schema, String name) {
        throw new UnsupportedOperationException();
    }

    public void ddlPreviewProcessCorrespondence(@NotNull Collection<ElementDelta<?>> correspondence, @NotNull ElementDelta<BasicElement> delta) {
        if (correspondence == null) {
            ModelHelper.$$$reportNull$$$0(6);
        }
        if (delta == null) {
            ModelHelper.$$$reportNull$$$0(7);
        }
    }

    public void docAppendInfo(@NotNull BasicElement delegate, @NotNull StringBuilder sb) {
        if (delegate == null) {
            ModelHelper.$$$reportNull$$$0(8);
        }
        if (sb == null) {
            ModelHelper.$$$reportNull$$$0(9);
        }
    }

    public boolean mustParticipateInInsert(@NotNull DasColumn column2) {
        if (column2 == null) {
            ModelHelper.$$$reportNull$$$0(10);
        }
        return !DasUtil.isAuto((DasColumn)column2) && column2.getDefault() == null && column2.isNotNull();
    }

    @Nullable
    public DataType getDataTypeForGridCompletion(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        DasColumn dasColumn;
        if (grid == null) {
            ModelHelper.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            ModelHelper.$$$reportNull$$$0(12);
        }
        return (dasColumn = DataGridUtil.getDatabaseColumn(grid, grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2))) != null ? dasColumn.getDataType() : null;
    }

    @NotNull
    public String unquoteEnumValue(@NotNull String value2) {
        if (value2 == null) {
            ModelHelper.$$$reportNull$$$0(13);
        }
        String string = StringUtil.unquoteString((String)value2);
        if (string == null) {
            ModelHelper.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj, @Nullable String comment) {
        if (obj == null) {
            ModelHelper.$$$reportNull$$$0(15);
        }
        return comment;
    }

    protected static @NotNull Pair<@Nls String, String> link(@Nls String name, String url) {
        Pair pair = Pair.create((Object)name, (Object)url);
        if (pair == null) {
            ModelHelper.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        DbObjectEditorFactory dbObjectEditorFactory = DbObjectEditorFactory.DEFAULT;
        if (dbObjectEditorFactory == null) {
            ModelHelper.$$$reportNull$$$0(17);
        }
        return dbObjectEditorFactory;
    }

    public void invalidateIntrospectionCache(@NotNull BasicModModel model) {
        if (model == null) {
            ModelHelper.$$$reportNull$$$0(18);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondence";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelHelper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteEnumValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "link";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exportApplyColumn";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exportLightExport";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ddlPreviewProcessCorrespondence";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "docAppendInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mustParticipateInInsert";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDataTypeForGridCompletion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unquoteEnumValue";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleJdbcComment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIntrospectionCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

