/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInsertValuesExtractor
extends SqlValuesExtractor {
    public SqlInsertValuesExtractor(@NotNull ObjectFormatter converter, @Nullable DasTable databaseTable) {
        if (converter == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(0);
        }
        super(converter, databaseTable);
    }

    @Override
    public SqlInsertExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (config == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(1);
        }
        return new SqlInsertExtraction(out, dbms, config, allColumns, selectedColumns);
    }

    private static void removeComputedAndAutoVal(int[] selectedColumns, TIntObjectHashMap<DataConsumer.Column> columnsMap, DasTable databaseTable, boolean addComputedColumns, boolean addGeneratedColumns) {
        for (int selectedColumn : selectedColumns) {
            DasColumn dasColumn;
            DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
            if (column2 == null) continue;
            if (DbImplUtil.isRowId(column2)) {
                columnsMap.remove(selectedColumn);
                continue;
            }
            if (databaseTable == null || (dasColumn = (DasColumn)DasUtil.findChild((DasObject)databaseTable, DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)column2.name)) == null || (addGeneratedColumns || !DasUtil.isAutoGenerated((DasColumn)dasColumn)) && (addComputedColumns || !DasUtil.isComputed((DasColumn)dasColumn))) continue;
            columnsMap.remove(selectedColumn);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/SqlInsertValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SqlInsertExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        SqlInsertExtraction(CharOut output, Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dbms, config, allColumns, selectedColumnIndices);
        }

        @Override
        protected void appendHeader(boolean appendNewLine) {
            Project project;
            if (!this.myConfig.getAddTableDdl()) {
                return;
            }
            if (SqlInsertValuesExtractor.this.myDatabaseTable instanceof DbElement) {
                this.myDdlBuilder.plain(DatabaseEditorHelper.generateDefinition((DbElement)SqlInsertValuesExtractor.this.myDatabaseTable, new StringBuilder()).toString());
                return;
            }
            if (SqlInsertValuesExtractor.this.myDatabaseTable instanceof BasicElement && (project = DbImplUtil.getAnyProject()) != null) {
                this.myDdlBuilder.plain(DatabaseEditorHelper.generateDefinitionUsingScriptingService(project, (BasicElement)SqlInsertValuesExtractor.this.myDatabaseTable).toString());
                return;
            }
            this.myDdlBuilder.keyword("CREATE").space().keyword("TABLE").space();
            if (SqlInsertValuesExtractor.this.myDatabaseTable == null) {
                this.myDdlBuilder.identifier("MY_TABLE");
            } else {
                this.myDdlBuilder.ref((DasObject)SqlInsertValuesExtractor.this.myDatabaseTable, SqlInsertValuesExtractor.this.myDatabaseTable.getName());
            }
            this.myDdlBuilder.space().symbol("(").newLine();
            boolean first2 = true;
            for (DataConsumer.Column column2 : this.myAllColumns) {
                if (DbImplUtil.isRowId(column2)) continue;
                if (first2) {
                    first2 = false;
                } else {
                    this.myDdlBuilder.symbol(",").newLine();
                }
                String typeName = StringUtil.isEmpty((String)column2.typeName) ? "unknown" : column2.typeName;
                this.myDdlBuilder.space(2).columnRef(column2.name).space().type(typeName);
            }
            this.myDdlBuilder.newLine().symbol(")").newStatement();
        }

        @Override
        protected void appendData(List<DataConsumer.Row> rows) {
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            SqlInsertValuesExtractor.removeComputedAndAutoVal(selectedColumns, columnsMap, SqlInsertValuesExtractor.this.myDatabaseTable, this.myConfig.getAddComputedColumns(), this.myConfig.getAddGeneratedColumns());
            for (DataConsumer.Row row : rows) {
                DataConsumer.Column column2;
                this.myDdlBuilder.keyword("INSERT").space().keyword("INTO").space();
                if (SqlInsertValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef((DasObject)SqlInsertValuesExtractor.this.myDatabaseTable).space();
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                boolean first2 = true;
                this.myDdlBuilder.symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first2) {
                        first2 = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column2.name);
                }
                this.myDdlBuilder.symbol(")").space();
                first2 = true;
                this.myDdlBuilder.keyword("VALUES").space().symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first2) {
                        first2 = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.literal(SqlInsertValuesExtractor.this.getValueLiteral(row, column2, this.myDbms, ObjectFormatter.Mode.SQL_SCRIPT));
                }
                this.myDdlBuilder.symbol(")");
                this.myDdlBuilder.newStatement();
            }
        }
    }
}

