/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ClassMap;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatter {
    private static final int MIN_IMAGE_BYTES = 100;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private final Map<FormatterKey, Formatter> myFormatCache = new ConcurrentHashMap<FormatterKey, Formatter>(10, 0.75f, Runtime.getRuntime().availableProcessors());
    private Formatter myDateFormat;
    private Formatter myTimeFormat;
    private Formatter myShortZonedTimeFormat;
    private Formatter myShortZonedTimestampFormat;
    private NumberFormatter myNumberFormat;
    private NumberFormatter myBigIntFormat;
    private static final MyMap<Object> ourToObject = new MyMap();
    private final MyMap<String> myToString = new MyMap();

    public ObjectFormatter() {
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o;
            }
        });
        this.myToString.register(Object[].class, this::arrayToString);
        this.myToString.register(long[].class, new Converter<long[], String>(){

            @Override
            public String convert(long[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, mode);
            }
        });
        this.myToString.register(int[].class, new Converter<int[], String>(){

            @Override
            public String convert(int[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, mode);
            }
        });
        this.myToString.register(double[].class, new Converter<double[], String>(){

            @Override
            public String convert(double[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, mode);
            }
        });
        this.myToString.register(byte[].class, new Converter<byte[], String>(){

            @Override
            public String convert(byte[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.isMsHierarchyid(dbms, column2) ? DbImplUtilCore.getDatabaseDialect(dbms).getBinaryLiteralString(o) : (mode != Mode.SQL_SCRIPT && ObjectFormatter.isOracleGUID(o, column2, dbms) ? DialectUtils.toHexString(o) : ObjectFormatter.this.bytesToStringImpl(o, o.length, dbms, mode));
            }
        });
        this.myToString.register(BitString.class, new Converter<BitString, String>(){

            @Override
            public String convert(BitString o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.bitsToString(o, column2);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return new String(o);
            }
        });
        this.myToString.register(Clob.class, new Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Clob o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = trimmed > 0 ? o.getSubString(1L, trimmed) : "";
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, new Converter<LobInfo.ClobInfo, String>(){

            @Override
            public String convert(LobInfo.ClobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o.isTruncated() && o.data == null ? "" : o.data;
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, new Converter<LobInfo.FileClobInfo, String>(){

            @Override
            public String convert(LobInfo.FileClobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Blob.class, new Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Blob o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), length, dbms, mode);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, String>(){

            @Override
            public String convert(LobInfo.BlobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o.isTruncated() && o.data == null ? "" : ObjectFormatter.this.bytesToStringImpl(o.data, o.length, dbms, mode);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, new Converter<LobInfo.FileBlobInfo, String>(){

            @Override
            public String convert(LobInfo.FileBlobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                String str = ObjectFormatter.dateToString(ObjectFormatter.this.getTimestampFormat(column2, dbms), o, dbms, column2);
                return dbms.is(Dbms.MONGO) ? ObjectFormatter.mongoDate(str, mode) : str;
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.getTimeFormat().format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                Formatter format = column2 == null || column2.clazz == null ? ObjectFormatter.this.getDateFormat(column2, dbms) : (dbms.is(Dbms.MONGO) || column2.clazz.endsWith("Timestamp") ? ObjectFormatter.this.getTimestampFormat(column2, dbms) : (column2.clazz.endsWith("Time") ? ObjectFormatter.this.getTimeFormat() : ObjectFormatter.this.getDateFormat(column2, dbms)));
                String str = ObjectFormatter.dateToString(format, o, dbms, column2);
                return dbms.is(Dbms.MONGO) ? ObjectFormatter.mongoDate(str, mode) : str;
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.getBigIntFormat().format(o);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (dbms.is(Dbms.MONGO)) {
                    if (o instanceof Double) {
                        if (Double.isInfinite((Double)o) || Double.isNaN((Double)o)) {
                            String v;
                            String string = (Double)o == Double.POSITIVE_INFINITY ? "Infinity" : (v = (Double)o == Double.NEGATIVE_INFINITY ? "-Infinity" : "NaN");
                            return mode == Mode.JSON ? "{\"$numberDecimal\": \"" + v + "\"}" : (mode == Mode.JS_SCRIPT ? "new NumberDecimal(\"" + v + "\")" : v);
                        }
                    } else if (o instanceof BigDecimal) {
                        if (mode == Mode.JSON) {
                            return String.format("{\"$numberDecimal\": %s}", ((BigDecimal)o).toPlainString());
                        }
                        if (mode == Mode.JS_SCRIPT) {
                            return "new NumberDecimal(\"" + ((BigDecimal)o).toPlainString() + "\")";
                        }
                    }
                }
                return ObjectFormatter.this.getDecimalFormat(column2, dbms).format(o);
            }
        });
        this.myToString.register(ImageInfo.class, new Converter<ImageInfo, String>(){

            @Override
            public String convert(ImageInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (mode == Mode.DISPLAY || o.bytes == null) {
                    return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
                }
                return ObjectFormatter.this.bytesToStringImpl(o.bytes, o.size, dbms, mode);
            }
        });
        this.myToString.register(TextInfo.class, new Converter<TextInfo, String>(){

            @Override
            public String convert(TextInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return mode == Mode.SQL_SCRIPT && dbms.isPostgres() && ObjectFormatter.isPgDecodedLiteral(column2, o) ? o.text : (mode == Mode.SQL_SCRIPT ? ObjectFormatter.bytesToString(o.bytes, dbms, mode) : o.text);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                Mode itemsMode;
                Mode mode2 = itemsMode = mode == Mode.DISPLAY || mode == Mode.JS_SCRIPT ? Mode.JS_SCRIPT : Mode.JSON;
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : (ObjectFormatter.isHstore(column2) ? ObjectFormatter.hstoreToString(o, mode) : (dbms.isDocumentOriented() ? JsonUtilKt.toJson(o, dbms, ObjectFormatter.this, itemsMode, null, false) : null));
            }
        });
        this.myToString.register(Set.class, new Converter<Set, String>(){

            @Override
            public String convert(Set o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : null;
            }
        });
        this.myToString.register(List.class, new Converter<List, String>(){

            @Override
            public String convert(List o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                Mode itemsMode;
                Mode mode2 = itemsMode = mode == Mode.DISPLAY || mode == Mode.JS_SCRIPT ? Mode.JS_SCRIPT : Mode.JSON;
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : (dbms.isDocumentOriented() ? JsonUtilKt.toJson(o, dbms, ObjectFormatter.this, itemsMode, null, false) : null);
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return mode != Mode.SQL_SCRIPT ? String.valueOf(o) : (dbms.isTransactSql() ? (o.booleanValue() ? "1" : "0") : String.valueOf(o));
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, new Converter<TimeZonedTimestamp, String>(){

            @Override
            public String convert(TimeZonedTimestamp o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getShortZonedTimestampFormat(column2, dbms), o, dbms, column2);
            }
        });
        this.myToString.register(TimeZonedTime.class, new Converter<TimeZonedTime, String>(){

            @Override
            public String convert(TimeZonedTime o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.getShortZonedTimeFormat(column2, dbms).format(o);
            }
        });
        this.myToString.register(ZonedValue.class, new Converter<ZonedValue, String>(){

            @Override
            public String convert(ZonedValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (mode == Mode.DISPLAY) {
                    Object object = ObjectFormatter.objectToObject(o, column2, Dbms.UNKNOWN);
                    return ObjectFormatter.this.objectToString(object, column2, dbms, mode);
                }
                return o.getStringRepresentation();
            }
        });
        this.myToString.register(ReservedCellValue.class, new Converter<ReservedCellValue, String>(){

            @Override
            public String convert(ReservedCellValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o == null ? null : StringUtil.toLowerCase((String)String.valueOf((Object)o));
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoValue.class, new Converter<MongoJdbcHelper.MongoValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.mongoValueToString(o, column2, dbms, mode);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoObjectIdValue.class, new Converter<MongoJdbcHelper.MongoObjectIdValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoObjectIdValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return mode == Mode.JS_SCRIPT ? "new ObjectId(\"" + o.unwrap() + "\")" : ObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column2, dbms, mode);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoRegexpValue.class, new Converter<MongoJdbcHelper.MongoRegexpValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoRegexpValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return mode == Mode.JSON ? ObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column2, dbms, mode) : "/" + o.pattern + "/" + o.options;
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoTimestampValue.class, new Converter<MongoJdbcHelper.MongoTimestampValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoTimestampValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return mode == Mode.JSON ? ObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column2, dbms, mode) : (mode == Mode.JS_SCRIPT ? "new Timestamp(" + o.inc + ", " + o.time + ")" : "Timestamp(" + o.inc + ", " + o.time + ")");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMinKeyValue.class, new Converter<MongoJdbcHelper.MongoMinKeyValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoMinKeyValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (o == null) {
                    return null;
                }
                return mode == Mode.JS_SCRIPT ? "new MinKey()" : (mode == Mode.JSON ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), o.unwrap()) : "MinKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMaxKeyValue.class, new Converter<MongoJdbcHelper.MongoMaxKeyValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoMaxKeyValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (o == null) {
                    return null;
                }
                return mode == Mode.JS_SCRIPT ? "new MaxKey()" : (mode == Mode.JSON ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), o.unwrap()) : "MaxKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBinaryValue.class, new Converter<MongoJdbcHelper.MongoBinaryValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoBinaryValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, column2, dbms, mode);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBlobInfo.class, new Converter<MongoJdbcHelper.MongoBlobInfo, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoBlobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, column2, dbms, mode);
            }
        });
        this.myToString.register(UUID.class, new Converter<UUID, String>(){

            @Override
            public String convert(UUID o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (dbms.is(Dbms.MONGO)) {
                    if (mode == Mode.JSON) {
                        byte[] binaryData = new byte[16];
                        ObjectFormatter.writeLongToArrayBigEndian(binaryData, 0, o.getMostSignificantBits());
                        ObjectFormatter.writeLongToArrayBigEndian(binaryData, 8, o.getLeastSignificantBits());
                        return ObjectFormatter.this.convertMongoBinaryValue(binaryData, (byte)4, column2, dbms, mode);
                    }
                    if (mode == Mode.JS_SCRIPT) {
                        return "new UUID(\"" + o.toString() + "\")";
                    }
                }
                return o.toString();
            }
        });
    }

    @NotNull
    private static String mongoDate(String str, Mode mode) {
        Object object = mode == Mode.JSON ? "{\"$date\": \"" + str + "\"}" : (mode == Mode.JS_SCRIPT ? "new ISODate(\"" + str + "\")" : str);
        if (object == null) {
            ObjectFormatter.$$$reportNull$$$0(0);
        }
        return object;
    }

    @Nullable
    private String mongoValueToString(@Nullable MongoJdbcHelper.MongoValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
        if (o == null) {
            return null;
        }
        Object unwrapped = o.unwrap();
        String string = this.objectToString(unwrapped, column2, dbms, mode);
        return mode == Mode.JSON ? (string != null && ObjectFormatter.isStringLiteral(dbms, column2, unwrapped, null, mode) ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), StringUtil.escapeStringCharacters((String)string)) : String.format("{\"$%s\": %s}", o.jsonTypeName(), string)) : string;
    }

    private static boolean isMsHierarchyid(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(1);
        }
        return dbms.isMicrosoft() && column2 != null && "hierarchyid".equals(column2.typeName);
    }

    private static void writeLongToArrayBigEndian(byte[] bytes, int offset, long x) {
        bytes[offset + 7] = (byte)(0xFFL & x);
        bytes[offset + 6] = (byte)(0xFFL & x >> 8);
        bytes[offset + 5] = (byte)(0xFFL & x >> 16);
        bytes[offset + 4] = (byte)(0xFFL & x >> 24);
        bytes[offset + 3] = (byte)(0xFFL & x >> 32);
        bytes[offset + 2] = (byte)(0xFFL & x >> 40);
        bytes[offset + 1] = (byte)(0xFFL & x >> 48);
        bytes[offset] = (byte)(0xFFL & x >> 56);
    }

    private String convertMongoBinaryValue(byte[] data, byte type, DataConsumer.Column column2, Dbms dbms, Mode mode) {
        String string = Base64.getEncoder().encodeToString(data);
        if (mode != Mode.JSON) {
            String v = "BinData(" + type + ", \"" + string + "\")";
            return mode == Mode.JS_SCRIPT ? "new " + v : v;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        String typeStr = Integer.toString(type, 16);
        map2.put("base64", string);
        map2.put("subType", typeStr.length() == 1 ? "0" + typeStr : typeStr);
        String str = this.objectToString(map2, column2, dbms, mode);
        return "{\"$binary\": " + str + "}";
    }

    private static boolean isOracleGUID(byte[] o, DataConsumer.Column column2, Dbms dbms) {
        return dbms.isOracle() && o != null && o.length == 16 && "RAW".equals(column2.typeName);
    }

    public static boolean isHstore(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(2);
        }
        return "hstore".equals(column2.typeName) && "java.util.Map".equals(column2.clazz);
    }

    public static boolean isJson(@NotNull DataConsumer.Column column2, Dbms family) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(3);
        }
        return (family.isMysql() || family.isPostgres()) && StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"json", "jsonb"});
    }

    public static boolean isPostgresArray(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(4);
        }
        return column2.type == 2003;
    }

    public static boolean isBinaryTextColumn(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(5);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column2.typeName);
    }

    public static boolean isPostgresRangeType(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(6);
        }
        return StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"int4range", "int8range", "numrange", "tsrange", "tstzrange", "daterange"});
    }

    private static String hstoreToString(Map<String, String> hstore, Mode mode) {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first2) {
                sb.append(',');
                sb.append(mode == Mode.DISPLAY ? (char)'\n' : ' ');
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), mode != Mode.DISPLAY, false);
            sb.append(" => ");
            ObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), mode != Mode.DISPLAY, false);
            first2 = false;
        }
        return sb.toString();
    }

    public static void appendHstoreValue(StringBuilder sb, String value2, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value2).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value2) : value2);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    private static String dateToString(@NotNull Formatter formatter, @NotNull Object value2, @Nullable Dbms dbms, @Nullable DataConsumer.Column column2) {
        String boundaryString;
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(7);
        }
        if (value2 == null) {
            ObjectFormatter.$$$reportNull$$$0(8);
        }
        return (boundaryString = BoundaryValueResolver.getInfinityString(dbms, column2, value2)) == null ? formatter.format(value2) : boundaryString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String bytesToStringImpl(byte @NotNull [] o, long wholeLength, Dbms dbms, Mode mode) {
        void mode2;
        if (o == null) {
            ObjectFormatter.$$$reportNull$$$0(9);
        }
        boolean truncated = wholeLength != (long)o.length;
        boolean wholeValueLoaded = !truncated && o.length < DatabaseSettings.getSettings().getBytesLimitPerValue();
        String stringValue = wholeValueLoaded && mode2 != Mode.SQL_SCRIPT ? DbImplUtil.validateDetectedString(CharsetToolkit.tryDecodeString((byte[])o, (Charset)StandardCharsets.UTF_8)) : null;
        return stringValue != null ? stringValue : ObjectFormatter.bytesToString(o, dbms, (Mode)mode2);
    }

    @Nullable
    public static Object objectToObject(@Nullable Object o, DataConsumer.Column column2, Dbms dbms) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)ourToObject.get(o.getClass());
        Object result = converter != null ? (Object)converter.convert(o, column2, dbms, Mode.DEFAULT) : null;
        return result != null ? result : ObjectFormatter.objectToObject(String.valueOf(o), column2, dbms);
    }

    public static void convertRows(@NotNull List<DataConsumer.Row> rows, @Nullable List<DataConsumer.Column> columns, @NotNull Dbms dbms) {
        if (rows == null) {
            ObjectFormatter.$$$reportNull$$$0(10);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(11);
        }
        if (columns == null) {
            return;
        }
        for (DataConsumer.Row row : rows) {
            if (row == null || row.values.length != columns.size()) continue;
            for (int i2 = 0; i2 < row.values.length; ++i2) {
                row.values[i2] = ObjectFormatter.objectToObject(row.values[i2], columns.get(i2), dbms);
            }
        }
    }

    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, @NotNull Mode mode) {
        if (mode == null) {
            ObjectFormatter.$$$reportNull$$$0(12);
        }
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result = converter != null ? (String)converter.convert(o, column2, dbms, mode) : null;
        result = result != null ? result : this.objectToString(String.valueOf(o), column2, dbms, mode);
        return Objects.requireNonNull(result);
    }

    @Nullable
    public String getValueLiteral(@Nullable Object value2, @NotNull DataConsumer.Column column2, Dbms dbms, Mode mode) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(13);
        }
        return value2 == ReservedCellValue.NULL || value2 == ReservedCellValue.UNSET ? null : this.objectToString(value2, column2, dbms, mode);
    }

    public static boolean isStringLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2, @Nullable Object value2, @Nullable JdbcHelper helper, @NotNull Mode mode) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(14);
        }
        if (mode == null) {
            ObjectFormatter.$$$reportNull$$$0(15);
        }
        if (mode == Mode.JSON) {
            if (value2 instanceof Number || value2 instanceof Boolean || value2 instanceof Map || value2 instanceof List) {
                return false;
            }
            return !dbms.isMongo() || !(value2 instanceof MongoJdbcHelper.MongoValue) && !(value2 instanceof Date) && !ObjectFormatter.isSpecialDouble(value2) && !(value2 instanceof LobInfo.BlobInfo) && !(value2 instanceof UUID);
        }
        if (dbms.is(Dbms.MONGO)) {
            switch (mode) {
                case JS_SCRIPT: {
                    return value2 instanceof String || value2 instanceof LobInfo.ClobInfo;
                }
                case DEFAULT: 
                case SQL_SCRIPT: {
                    return value2 instanceof String || value2 instanceof LobInfo.ClobInfo || value2 instanceof MongoJdbcHelper.MongoValue || value2 instanceof UUID || value2 instanceof java.sql.Date || value2 instanceof Map || value2 instanceof List || value2 instanceof NestedObjectWrapper || ObjectFormatter.isSpecialDouble(value2);
                }
            }
            return false;
        }
        if (mode == Mode.SQL_SCRIPT || mode == Mode.DEFAULT || mode == Mode.JS_SCRIPT) {
            return value2 instanceof LobInfo.ClobInfo || column2 != null && (ObjectFormatter.isCommonLiteral(dbms, column2, value2, helper) || ObjectFormatter.isJson(column2, dbms) || ObjectFormatter.isPostgresStringLiteral(dbms, column2, value2));
        }
        return false;
    }

    private static boolean isSpecialDouble(@Nullable Object value2) {
        return value2 instanceof Double && (Double.isNaN((Double)value2) || Double.isInfinite((Double)value2));
    }

    private static boolean isCommonLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column2, @Nullable Object value2, @Nullable JdbcHelper helper) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(16);
        }
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(17);
        }
        helper = helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms);
        int jdbcType = ExtractorsUtil.guessJdbcType(column2, value2, dbms);
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 91 || jdbcType == 2005 || jdbcType == -8 || jdbcType == 239 || helper.isTimestamp(jdbcType) || helper.isZonedColumn(column2.typeName, jdbcType) || ObjectFormatter.isBitString(column2) || !dbms.isCassandra() && StringUtil.equalsIgnoreCase((CharSequence)column2.typeName, (CharSequence)"uuid");
    }

    private static boolean isPostgresStringLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column2, @Nullable Object value2) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(18);
        }
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(19);
        }
        return dbms.isPostgres() && (ObjectFormatter.isHstore(column2) || ObjectFormatter.isPostgresRangeType(column2) || ObjectFormatter.isPostgresArray(column2) || StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"interval", "cird", "circle", "inet", "line", "lseg", "macaddr", "macaddr8", "money", "path", "point", "polygon", "tsquery", "tsvector", "xml"}) || ObjectFormatter.isPgDecodedLiteral(column2, value2));
    }

    public static boolean isPgDecodedLiteral(@NotNull DataConsumer.Column column2, @Nullable Object value2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(20);
        }
        return value2 instanceof TextInfo && ObjectFormatter.isBinaryTextColumn(column2);
    }

    @NotNull
    public String getPlainValue(@NotNull DataConsumer.Column column2, @NotNull DataConsumer.Row row, Dbms dbms, @NotNull Mode mode) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(21);
        }
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(22);
        }
        if (mode == null) {
            ObjectFormatter.$$$reportNull$$$0(23);
        }
        String string = this.getPlainValue(column2.getValue(row), column2, dbms, mode);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getPlainValue(@Nullable Object object, @NotNull DataConsumer.Column column2, Dbms dbms, @NotNull Mode mode) {
        String literal;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(25);
        }
        if (mode == null) {
            ObjectFormatter.$$$reportNull$$$0(26);
        }
        String string = (literal = this.objectToString(object, column2, dbms, mode)) == null ? "null" : literal;
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String getPlainValue(@Nullable Object object, @NotNull DataConsumer.Column column2, Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(28);
        }
        String string = this.getPlainValue(object, column2, dbms, Mode.DISPLAY);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    private static Object tryDetectObject(byte @NotNull [] bytes) {
        ImageInfo image;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(30);
        }
        if ((image = ObjectFormatter.tryDetectImage(bytes)) != null) {
            return image;
        }
        return ObjectFormatter.tryDetectString(bytes);
    }

    @Nullable
    public static TextInfo tryDetectString(byte @NotNull [] bytes) {
        Charset charset;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(31);
        }
        String text2 = (charset = DbImplUtil.guessCharsetFromContent(bytes)) == null ? null : DbImplUtil.validateDetectedString(CharsetToolkit.tryDecodeString((byte[])bytes, (Charset)charset));
        return text2 == null ? null : new TextInfo(text2, bytes, charset);
    }

    @Nullable
    private static ImageInfo tryDetectImage(final byte @NotNull [] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(32);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    @Nullable
    private static BufferedImage readImage(byte @NotNull [] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(33);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T extractImageData(byte @NotNull [] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            ObjectFormatter.$$$reportNull$$$0(34);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(35);
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<Object> readers = stream != null ? ImageIO.getImageReaders(stream) : Collections.emptyIterator();
            ImageReader reader = readers.hasNext() ? (ImageReader)readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Formatter getTimeFormat() {
        this.initFormats();
        return this.myTimeFormat;
    }

    public Formatter getZonedTimeFormat(DataConsumer.Column column2, Dbms dbms) {
        FormatterKey key = new FormatterKey(column2, TimeZonedTime.class);
        Formatter format = this.myFormatCache.get(key);
        if (format != null) {
            return format;
        }
        CompositeFormatter result = FormatterCreator.newZonedTimeFormat(ObjectFormatter.calculateScale(column2, dbms));
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    public Formatter getShortZonedTimeFormat(DataConsumer.Column column2, Dbms dbms) {
        if (this.myShortZonedTimeFormat == null) {
            int scale = ObjectFormatter.calculateScale(column2, dbms);
            this.myShortZonedTimeFormat = FormatterCreator.newShortZonedTimeFormat(scale);
        }
        return this.myShortZonedTimeFormat;
    }

    public Formatter getShortZonedTimestampFormat(DataConsumer.Column column2, Dbms dbms) {
        if (this.myShortZonedTimestampFormat == null) {
            int scale = ObjectFormatter.calculateScale(column2, dbms);
            this.myShortZonedTimestampFormat = FormatterCreator.newShortEraZonedTimestampFormat(scale);
        }
        return this.myShortZonedTimestampFormat;
    }

    public Formatter getTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(36);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(37);
        }
        FormatterKey key = new FormatterKey(column2, Timestamp.class);
        Formatter formatter = format = dbms.is(Dbms.MONGO) ? null : this.myFormatCache.get(key);
        if (format != null) {
            return format;
        }
        Formatter result = ObjectFormatter.newTimestampFormat(column2, dbms);
        if (!dbms.is(Dbms.MONGO)) {
            this.myFormatCache.putIfAbsent(key, result);
        }
        return result;
    }

    @Nullable
    public Formatter getTimestampFormat(@NotNull Domain domain, @NotNull Dbms dbms) {
        if (domain == null) {
            ObjectFormatter.$$$reportNull$$$0(38);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(39);
        }
        if (domain.getLogicType() != LogicalType.TIMESTAMP || !dbms.is(Dbms.MONGO)) {
            return null;
        }
        return FormatterCreator.newDateFormatWithTime();
    }

    public CompositeFormatter getZonedTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        FormatterKey key;
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(40);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(41);
        }
        if ((format = this.myFormatCache.get(key = new FormatterKey(column2, TimeZonedTimestamp.class))) instanceof CompositeFormatter) {
            return (CompositeFormatter)format;
        }
        CompositeFormatter result = FormatterCreator.newZonedTimestampFormat(dbms, column2, ObjectFormatter.calculateScale(column2, dbms));
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    public Formatter getDateFormat(@Nullable DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(42);
        }
        if (this.myDateFormat != null) {
            return this.myDateFormat;
        }
        this.myDateFormat = ObjectFormatter.newDateFormat(column2, dbms);
        return this.myDateFormat;
    }

    @NotNull
    private <T> String arrayToString(T[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
        if (o.length == 0) {
            return mode == Mode.DISPLAY ? "{}" : "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int len = Math.min(o.length, mode == Mode.DISPLAY ? 100 : o.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(this.objectToString(o[i2], column2, dbms, Mode.DISPLAY));
        }
        if (len < o.length) {
            sb.append(",...");
        }
        sb.append("}");
        String string = sb.toString();
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static Formatter newTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(44);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(45);
        }
        Formatter formatter = FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraTimestampFormat(dbms, column2, ObjectFormatter.calculateScale(column2, dbms)) : (dbms.is(Dbms.MONGO) ? FormatterCreator.newDateFormatWithTime() : FormatterCreator.newTimestampFormat(ObjectFormatter.calculateScale(column2, dbms)));
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(46);
        }
        return formatter;
    }

    @NotNull
    private static Formatter newDateFormat(@Nullable DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(47);
        }
        Formatter formatter = FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraDateFormatter(dbms, column2) : FormatterCreator.newDateFormatter();
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(48);
        }
        return formatter;
    }

    @NotNull
    private static String bitsToString(@NotNull BitString string, @NotNull DataConsumer.Column column2) {
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(49);
        }
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(50);
        }
        long length = string.getLength();
        byte[] bytes = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while ((long)j < length) {
            byte b2 = bytes[j / 8];
            sb.append((b2 & 128 >>> j % 8) != 0 ? (char)'1' : '0');
            ++j;
        }
        while (sb.length() > column2.precision && sb.length() > 0 && sb.charAt(0) == '0') {
            sb.delete(0, 1);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            ObjectFormatter.$$$reportNull$$$0(51);
        }
        return string2;
    }

    private static int calculateScale(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(52);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(53);
        }
        int scale = column2.scale;
        if (dbms.isMysql() && column2.type == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)column2.typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)column2.typeName))) {
            scale = column2.precision - 20;
        }
        if (dbms.isSqlite()) {
            scale = 3;
        }
        return MathUtil.clamp((int)scale, (int)0, (int)9);
    }

    public NumberFormatter getDecimalFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(54);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(55);
        }
        FormatterKey key = new FormatterKey(column2, Number.class);
        Formatter formatter = format = dbms.is(Dbms.MONGO) ? null : this.myFormatCache.get(key);
        if (format instanceof NumberFormatter) {
            return (NumberFormatter)format;
        }
        NumberFormatter result = ObjectFormatter.isFloat(column2) ? FormatterCreator.newFloatFormat() : FormatterCreator.newDecimalFormat();
        int fractionDigits = column2.scale;
        result.setParseBigDecimal(ObjectFormatter.isBigDecimal(column2));
        result.setMinimumFractionDigits(ObjectFormatter.isFloatingPoint(column2) || ObjectFormatter.isH2DecimalWithUnspecifiedPrecision(column2) ? 0 : fractionDigits);
        result.setMaximumFractionDigits(340);
        if (column2.attributes.contains((Object)DataConsumer.Column.Attribute.ZERO_PADDING) && column2.precision > 0) {
            result.setMinimumIntegerDigits(column2.precision);
        }
        if (!dbms.is(Dbms.MONGO)) {
            this.myFormatCache.putIfAbsent(key, result);
        }
        return result;
    }

    @Nullable
    public NumberFormatter getDecimalFormat(@NotNull Domain domain) {
        ConversionPoint point;
        if (domain == null) {
            ObjectFormatter.$$$reportNull$$$0(56);
        }
        if ((point = domain.getPoint()) == ConversionPoint.SINGLE_PRECISION) {
            return FormatterCreator.newFloatFormat();
        }
        if (point != ConversionPoint.DOUBLE_PRECISION && point != ConversionPoint.BIG_DECIMAL) {
            return null;
        }
        NumberFormatter result = FormatterCreator.newDecimalFormat();
        result.setParseBigDecimal(point == ConversionPoint.BIG_DECIMAL);
        result.setMinimumFractionDigits(0);
        result.setMaximumFractionDigits(340);
        return result;
    }

    @Nullable
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)o).data;
        }
        if (o instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)o).data;
        }
        if (o instanceof TextInfo) {
            return ((TextInfo)o).bytes;
        }
        if (o instanceof ImageInfo) {
            return ((ImageInfo)o).bytes;
        }
        return o;
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable Object value2) {
        return value2 instanceof Boolean ? (Boolean)value2 : (value2 instanceof Number ? Boolean.valueOf(((Number)value2).intValue() == 1) : (value2 instanceof String ? ObjectFormatter.parseBoolean((String)value2) : null));
    }

    @Nullable
    private static Boolean parseBoolean(@NotNull String value2) {
        if (value2 == null) {
            ObjectFormatter.$$$reportNull$$$0(57);
        }
        return StringUtil.findIgnoreCase((String)value2, (String[])new String[]{"1", "true"}) ? Boolean.TRUE : (StringUtil.findIgnoreCase((String)value2, (String[])new String[]{"0", "false"}) ? Boolean.FALSE : null);
    }

    public static boolean isFloatingPoint(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(58);
        }
        return ObjectFormatter.isFloat(column2) || ObjectFormatter.isDouble(column2);
    }

    public static boolean isBigDecimal(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(59);
        }
        return BigDecimal.class.getName().equals(column2.clazz);
    }

    public static boolean isBooleanColumn(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        int type;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(60);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(61);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2, value2, dbms)) == 16 || (ObjectFormatter.isBit(column2.typeName, type) || "java.lang.Boolean".equals(column2.clazz)) && column2.precision <= 1;
    }

    public static boolean isNumericValue(@Nullable Object object, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(62);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(63);
        }
        int type = ExtractorsUtil.guessJdbcType(column2, object, dbms);
        return ArrayUtil.contains((Object)type, (Object[])new Integer[]{4, 5, -6, -5, 7, 6, 8, 3, 2}) || !dbms.in(Dbms.DOCUMENT_ORIENTED) && (ObjectFormatter.isFloatingPoint(column2) || ObjectFormatter.isBigDecimal(column2));
    }

    public static boolean isBitString(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            ObjectFormatter.$$$reportNull$$$0(64);
        }
        return c2.precision > 1 && ObjectFormatter.isBit(c2.typeName, c2.type);
    }

    private static boolean isBit(@Nullable String typeName, int jdbcType) {
        return jdbcType == -7 || typeName != null && StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"bit", "bit varying", "varbit"});
    }

    private static boolean isFloat(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(65);
        }
        return Float.class.getName().equals(column2.clazz) || "oracle.sql.BINARY_FLOAT".equals(column2.clazz);
    }

    private static boolean isDouble(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(66);
        }
        return Double.class.getName().equals(column2.clazz) || "oracle.sql.BINARY_DOUBLE".equals(column2.clazz);
    }

    private static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(67);
        }
        return "DECIMAL".equals(column2.typeName) && 65535 == column2.precision && Short.MAX_VALUE == column2.scale;
    }

    @NotNull
    private static String bytesToString(byte @NotNull [] bytes, Dbms dbms, Mode mode) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(68);
        }
        String string = mode == Mode.DISPLAY ? DialectUtils.toPresentableHexString(bytes) : DbImplUtilCore.getDatabaseDialect(dbms).getBinaryLiteralString(bytes);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(69);
        }
        return string;
    }

    private void initFormats() {
        if (this.myTimeFormat != null) {
            return;
        }
        this.myTimeFormat = FormatterCreator.newTimeFormat();
        this.myNumberFormat = FormatterCreator.newDecimalFormat();
        this.myNumberFormat.setParseIntegerOnly(true);
        this.myBigIntFormat = FormatterCreator.newDecimalFormat();
        this.myBigIntFormat.setParseIntegerOnly(true);
        this.myBigIntFormat.setParseBigDecimal(true);
    }

    @NotNull
    public Formatter getNumberFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myNumberFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(70);
        }
        return numberFormatter;
    }

    @NotNull
    public Formatter getBigIntFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myBigIntFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(71);
        }
        return numberFormatter;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    static {
        Converter<Object, Object> identity = new Converter<Object, Object>(){

            @Override
            public Object convert(Object o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o;
            }
        };
        ourToObject.put(Object[].class, identity);
        ourToObject.put(long[].class, identity);
        ourToObject.put(int[].class, identity);
        ourToObject.put(double[].class, identity);
        ourToObject.put(TimeZonedValue.class, identity);
        ourToObject.put(LobInfo.ClobInfo.class, identity);
        ourToObject.put(MongoJdbcHelper.MongoValue.class, identity);
        ourToObject.put(MongoJdbcHelper.MongoBlobInfo.class, identity);
        ourToObject.put(NestedObjectWrapper.class, identity);
        ourToObject.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, Object>(){

            @Override
            public Object convert(LobInfo.BlobInfo o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = ObjectFormatter.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        ourToObject.put(Boolean.class, identity);
        ourToObject.put(Number.class, identity);
        ourToObject.put(Timestamp.class, identity);
        ourToObject.put(Time.class, identity);
        ourToObject.register(ZonedValue.class, new Converter<ZonedValue, Object>(){

            @Override
            public Object convert(ZonedValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                String stringValue = o.getStringRepresentation();
                int scale = ObjectFormatter.calculateScale(column2, dbms);
                ParsePosition position = new ParsePosition(0);
                return ObjectUtils.notNull((Object)(DbImplUtil.isZonedTimeColumn(column2, dbms) ? FormatterCreator.newZonedTimeFormat(scale).parse(stringValue, position) : FormatterCreator.newZonedTimestampFormat(dbms, column2, scale).parse(stringValue, position)), (Object)stringValue);
            }
        });
        ourToObject.register(BitString.class, new Converter<BitString, Object>(){

            @Override
            public Object convert(BitString o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return ObjectFormatter.bitsToString(o, column2);
            }
        });
        ourToObject.register(Date.class, new Converter<Date, Object>(){

            @Override
            public Object convert(Date o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (dbms.is(Dbms.MONGO) || column2 != null && column2.clazz != null && column2.clazz.endsWith("Timestamp")) {
                    return new Timestamp(o.getTime());
                }
                if (column2 != null && column2.clazz != null && column2.clazz.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        ourToObject.register(byte[].class, new Converter<byte[], Object>(){

            @Override
            public Object convert(byte[] o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                Object detectedObject = ObjectFormatter.isMsHierarchyid(dbms, column2) ? null : ObjectFormatter.tryDetectObject(o);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)DatabaseSettings.getSettings().getBytesLimitPerValue());
            }
        });
        ourToObject.register(Clob.class, new Converter<Clob, Object>(){

            @Override
            public Object convert(Clob o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)DatabaseSettings.getSettings().getBytesLimitPerValue());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(Blob.class, new Converter<Blob, Object>(){

            @Override
            public Object convert(Blob o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)DatabaseSettings.getSettings().getBytesLimitPerValue());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(String.class, new Converter<String, Object>(){

            @Override
            public Object convert(String o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return LobInfo.fromString((String)o, (int)DatabaseSettings.getSettings().getBytesLimitPerValue());
            }
        });
        ourToObject.register(Map.class, new Converter<Map, Object>(){

            @Override
            public Object convert(Map o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return dbms.isCassandra() || ObjectFormatter.isHstore(column2) || dbms.isDocumentOriented() ? o : null;
            }
        });
        ourToObject.register(Set.class, new Converter<Set, Object>(){

            @Override
            public Object convert(Set o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return dbms.isCassandra() ? o : null;
            }
        });
        ourToObject.register(List.class, new Converter<List, Object>(){

            @Override
            public Object convert(List o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return dbms.isCassandra() || dbms.isDocumentOriented() ? o : null;
            }
        });
        ourToObject.register(InetAddress.class, new Converter<InetAddress, Object>(){

            @Override
            public Object convert(InetAddress o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                if (!dbms.isCassandra()) {
                    return null;
                }
                String value2 = o.toString();
                return value2.substring(value2.indexOf("/") + 1);
            }
        });
        ourToObject.register(UUID.class, new Converter<UUID, Object>(){

            @Override
            public Object convert(UUID o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return dbms.isMongo() ? o : o.toString();
            }
        });
        ourToObject.register(ReservedCellValue.class, new Converter<ReservedCellValue, Object>(){

            @Override
            public Object convert(ReservedCellValue o, DataConsumer.Column column2, Dbms dbms, Mode mode) {
                return o;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 47: 
            case 53: 
            case 55: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 36: 
            case 40: 
            case 44: 
            case 50: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 8: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 12: 
            case 15: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExtractor";
                break;
            }
            case 38: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mongoDate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 24: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainValue";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormat";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "bitsToString";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIntFormat";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMsHierarchyid";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isHstore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresRangeType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "objectToString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCommonLiteral";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresStringLiteral";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPgDecodedLiteral";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPlainValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectObject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectImage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "extractImageData";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTimestampFormat";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimestampFormat";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newTimestampFormat";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormat";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "bitsToString";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "calculateScale";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDecimalFormat";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isFloatingPoint";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isBigDecimal";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanColumn";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isNumericValue";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isBitString";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isDouble";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isH2DecimalWithUnspecifiedPrecision";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Mode {
        DISPLAY,
        SQL_SCRIPT,
        JS_SCRIPT,
        JSON,
        DEFAULT;

    }

    private static class FormatterKey {
        private final DataConsumer.Column myColumn;
        private final Class<?> myClass;

        FormatterKey(@NotNull DataConsumer.Column column2, @NotNull Class<?> aClass) {
            if (column2 == null) {
                FormatterKey.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                FormatterKey.$$$reportNull$$$0(1);
            }
            this.myColumn = column2;
            this.myClass = aClass;
        }

        public int hashCode() {
            return this.myClass.hashCode() + this.myColumn.hashCode() * 31;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatterKey)) {
                return false;
            }
            FormatterKey key = (FormatterKey)obj;
            return this.myClass.equals(key.myClass) && this.myColumn.equals(key.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$FormatterKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextInfo {
        public final String text;
        public final byte[] bytes;
        public final Charset charset;

        public TextInfo(@NotNull String text2, byte @NotNull [] bytes, @NotNull Charset charset) {
            if (text2 == null) {
                TextInfo.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                TextInfo.$$$reportNull$$$0(1);
            }
            if (bytes == null) {
                TextInfo.$$$reportNull$$$0(2);
            }
            this.text = text2;
            this.bytes = bytes;
            this.charset = charset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextInfo info = (TextInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            if (!this.charset.equals(info.charset)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + this.charset.hashCode();
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$TextInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImageInfo {
        public final String format;
        public final int width;
        public final int height;
        public final int size;
        public final byte[] bytes;

        public ImageInfo(@NotNull String format, int width, int height, int size, byte @Nullable [] bytes) {
            if (format == null) {
                ImageInfo.$$$reportNull$$$0(0);
            }
            this.format = format;
            this.width = width;
            this.height = height;
            this.size = size;
            this.bytes = bytes;
        }

        @Nullable
        public BufferedImage createImage() {
            return this.bytes != null ? ObjectFormatter.readImage(this.bytes) : null;
        }

        @NotNull
        public ImageInfo stripBytes() {
            return new ImageInfo(this.format, this.width, this.height, this.size, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo info = (ImageInfo)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            if (this.size != info.size) {
                return false;
            }
            if (!this.format.equals(info.format)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.format.hashCode();
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.size;
            result = 31 * result + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter$ImageInfo", "<init>"));
        }
    }

    private static abstract class ImageDataExtractor<T> {
        private ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }

    private static final class MyMap<T>
    extends ClassMap<Converter<Object, T>> {
        private MyMap() {
            super(new ConcurrentHashMap());
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value2) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/ObjectFormatter$MyMap", "register"));
        }
    }

    static interface Converter<X, V> {
        public V convert(X var1, DataConsumer.Column var2, Dbms var3, Mode var4);
    }
}

