/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.helpers.CouchbaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractorsUtil {
    private ExtractorsUtil() {
    }

    @NotNull
    public static String getPresentableSize(long length) {
        String string = StringUtil.formatFileSize((long)length);
        if (string == null) {
            ExtractorsUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getTypeNameForEditing(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(2);
        }
        return value2 instanceof ReservedCellValue && dbms.in(Dbms.DOCUMENT_ORIENTED) ? (BaseDomainRegistry.getDomain(dbms, null, new TypeNameColumnDescriptor(column2.typeName), true) != null ? column2.typeName : ExtractorsUtil.getTypeName(column2, "", dbms)) : ExtractorsUtil.getTypeName(column2, value2, dbms);
    }

    @NlsSafe
    @NotNull
    public static String getTypeName(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(4);
        }
        String string = value2 instanceof UnparsedValue && ((UnparsedValue)value2).getDomain() != null ? Objects.requireNonNull(((UnparsedValue)value2).getDomain()).simpleName() : (dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value2) : (dbms.is(Dbms.COUCHBASE_QUERY) ? CouchbaseJdbcHelper.getTypeName((Object)value2) : column2.typeName));
        if (string == null) {
            ExtractorsUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static Domain guessDomainForEditing(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object initialValue) {
        if (grid == null) {
            ExtractorsUtil.$$$reportNull$$$0(6);
        }
        if (columnIdx == null) {
            ExtractorsUtil.$$$reportNull$$$0(7);
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        DataConsumer.Column column2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        TypeNameColumnDescriptor descriptor2 = column2 == null ? null : new TypeNameColumnDescriptor(ExtractorsUtil.getTypeNameForEditing(column2, initialValue, dbms));
        return descriptor2 == null ? null : BaseDomainRegistry.getDomain(dbms, DbImplUtil.getDatabaseVersion((DasDataSource)DataGridUtil.getDatabaseSystem(grid)), descriptor2, true);
    }

    public static int guessJdbcType(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(9);
        }
        if (dbms.in(Dbms.DOCUMENT_ORIENTED) && value2 != null && !(value2 instanceof ReservedCellValue)) {
            String typeName = value2 instanceof UnparsedValue && ((UnparsedValue)value2).getDomain() != null ? Objects.requireNonNull(((UnparsedValue)value2).getDomain()).simpleName() : (dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value2) : CouchbaseJdbcHelper.getTypeName((Object)value2));
            Integer type = dbms.is(Dbms.MONGO) ? (Integer)MongoJdbcHelper.TYPES_MAP.get(typeName) : (Integer)CouchbaseJdbcHelper.TYPES_MAP.get(typeName);
            return type != null ? type : 1111;
        }
        if (column2.type != 1111) {
            return column2.type;
        }
        int byType = JdbcUtil.guessJdbcTypeByName((String)column2.typeName);
        if (byType == -6 && column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (byType != 0 || column2.clazz == null) {
            return byType;
        }
        if (column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (column2.clazz.equals("java.lang.String")) {
            return 12;
        }
        if (column2.clazz.equals("java.lang.Integer")) {
            return 4;
        }
        if (column2.clazz.equals("java.lang.Double")) {
            return 8;
        }
        if (column2.clazz.equals("java.lang.Float")) {
            return 6;
        }
        if (column2.clazz.endsWith(".Date")) {
            return 91;
        }
        if (column2.clazz.endsWith(".Time")) {
            return 92;
        }
        if (column2.clazz.endsWith(".Timestamp")) {
            return 93;
        }
        if (column2.clazz.endsWith(".UUID")) {
            return 12;
        }
        return byType;
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, DataExtractor.Text extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            ExtractorsUtil.$$$reportNull$$$0(10);
        }
        return ExtractorsUtil.extract(out, dbms, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, extractor, rows, selectedColumns);
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, Dbms dbms, @NotNull ExtractionConfig config, List<DataConsumer.Column> allColumns, DataExtractor.Text extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            ExtractorsUtil.$$$reportNull$$$0(11);
        }
        if (config == null) {
            ExtractorsUtil.$$$reportNull$$$0(12);
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, dbms, allColumns, config, selectedColumns);
        e.addData(rows);
        e.complete();
        CharOut charOut = out;
        if (charOut == null) {
            ExtractorsUtil.$$$reportNull$$$0(13);
        }
        return charOut;
    }

    public static DataExtractor.Text getSingleValueExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            ExtractorsUtil.$$$reportNull$$$0(14);
        }
        return new DefaultValuesExtractor(converter){

            @Override
            protected boolean isStringLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
                if (dbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public DefaultValuesExtractor.DefaultExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, ExtractionConfig config, int ... selectedColumns) {
                return new DefaultValuesExtractor.DefaultExtraction(out, dbms, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, selectedColumns){

                    @Override
                    protected void appendData(List<DataConsumer.Row> rows) {
                        TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                        int[] selection = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
                        if (rows.isEmpty() || selection.length == 0) {
                            return;
                        }
                        int selectedColumn = selection[0];
                        DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                        if (column2 == null) {
                            return;
                        }
                        DataConsumer.Row row = rows.get(0);
                        this.myOutput.append(this.getValueLiteral(row, column2, this.myDbms, ObjectFormatter.Mode.DEFAULT));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/extractors/ExtractorsUtil$1", "isStringLiteral"));
            }
        };
    }

    static TIntObjectHashMap<DataConsumer.Column> getColumnNumsToColumnsMapping(@NotNull List<DataConsumer.Column> columns) {
        if (columns == null) {
            ExtractorsUtil.$$$reportNull$$$0(15);
        }
        TIntObjectHashMap m = new TIntObjectHashMap(columns.size());
        for (DataConsumer.Column column2 : columns) {
            m.put(column2.columnNum, (Object)column2);
        }
        return m;
    }

    static int[] getNonEmptySelection(@NotNull List<DataConsumer.Column> allColumns, int[] providedSelection) {
        if (allColumns == null) {
            ExtractorsUtil.$$$reportNull$$$0(16);
        }
        if (providedSelection.length != 0) {
            return providedSelection;
        }
        int[] selection = new int[allColumns.size()];
        for (int i2 = 0; i2 < allColumns.size(); ++i2) {
            selection[i2] = allColumns.get((int)i2).columnNum;
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNameForEditing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "guessDomainForEditing";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValueExtractor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNumsToColumnsMapping";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptySelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

