/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.util.CharOut;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultValuesExtractor
implements DataExtractor.Text {
    protected final ObjectFormatter myConverter;

    public DefaultValuesExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(0);
        }
        this.myConverter = converter;
    }

    public String getLineSeparator() {
        return "\n";
    }

    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, @NotNull ObjectFormatter.Mode mode) {
        String value2;
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(4);
        }
        String string = (value2 = this.getValueAsString(row, column2, dbms, mode)) == null ? this.getNullLiteral(row, column2) : this.getValueLiteral(dbms, value2, row, column2);
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, @NotNull ObjectFormatter.Mode mode) {
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(6);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(9);
        }
        return this.myConverter.getValueLiteral(column2.getValue(row), column2, dbms, mode);
    }

    public String getValueLiteral(@NotNull Dbms dbms, @NotNull String value2, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(11);
        }
        return this.isStringLiteral(dbms, row, column2) ? this.getStringValueLiteral(dbms, column2, value2) : value2;
    }

    protected abstract boolean isStringLiteral(@NotNull Dbms var1, @Nullable DataConsumer.Row var2, @Nullable DataConsumer.Column var3);

    @Override
    public abstract DataExtractor.Extraction startExtraction(CharOut var1, Dbms var2, List<DataConsumer.Column> var3, ExtractionConfig var4, int ... var5);

    public String getColumnName(DataConsumer.Column column2) {
        return column2.name;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "txt";
    }

    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column2) {
        return "NULL";
    }

    @NotNull
    public String getStringValueLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2, @NotNull String value2) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(13);
        }
        String string = value2;
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteral";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 5: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class DefaultExtraction
    implements DataExtractor.Extraction {
        protected final CharOut myOutput;
        protected List<DataConsumer.Column> myAllColumns;
        protected final int[] mySelectedColumnIndices;
        protected final Dbms myDbms;
        protected final ExtractionConfig myConfig;
        protected boolean myHeaderAppended;
        protected boolean myFooterAppended;

        public DefaultExtraction(CharOut output, Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            this.myOutput = output;
            this.myDbms = dbms;
            this.myConfig = config;
            this.myAllColumns = allColumns;
            this.mySelectedColumnIndices = selectedColumnIndices;
        }

        @Override
        public void updateColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                DefaultExtraction.$$$reportNull$$$0(0);
            }
            this.myAllColumns = Arrays.asList(columns);
        }

        @Override
        public void addData(List<DataConsumer.Row> rows) {
            if (!this.myHeaderAppended) {
                this.appendHeader(!rows.isEmpty());
                this.myHeaderAppended = true;
            }
            this.appendData(rows);
        }

        @Override
        public void complete() {
            if (!this.myHeaderAppended) {
                this.appendHeader(false);
                this.myHeaderAppended = true;
            }
            if (!this.myFooterAppended) {
                this.appendFooter();
                this.myFooterAppended = true;
            }
        }

        protected void appendHeader(boolean appendNewLine) {
        }

        protected void appendFooter() {
        }

        protected abstract void appendData(List<DataConsumer.Row> var1);

        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            return new DataConsumer.Column(0, "#", 12, "", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/extractors/DefaultValuesExtractor$DefaultExtraction", "updateColumns"));
        }
    }
}

