/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorStructureViewModel
implements StructureViewModel,
StructureViewModel.ElementInfoProvider {
    private final Project myProject;
    private final DataGrid myDataGrid;
    private final List<Object> myListeners;
    private final Disposable myDisposable;

    public TableEditorStructureViewModel(@NotNull TableEditorBase editor) {
        if (editor == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(0);
        }
        this(editor.getProject(), editor.getDataGrid());
    }

    public TableEditorStructureViewModel(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myDataGrid = dataGrid;
        this.myDataGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                for (Object listener2 : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener2 instanceof FileEditorPositionListener)) continue;
                    ((FileEditorPositionListener)listener2).onCurrentElementChanged();
                }
            }

            @Override
            public void onContentChanged(DataGrid dataGrid, @Nullable Object requestor) {
                for (Object listener2 : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener2 instanceof ModelListener)) continue;
                    ((ModelListener)listener2).onModelChanged();
                }
            }
        }, this.myDisposable);
    }

    @Nullable
    public Object getCurrentEditorElement() {
        ModelIndex<DataConsumer.Column> column2 = this.myDataGrid.getSelectionModel().getSelectedColumn();
        return column2.isValid(this.myDataGrid) ? DataGridPomTarget.wrapColumn(this.myProject, this.myDataGrid, column2) : null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener2);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(5);
        }
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(6);
        }
        this.myListeners.remove(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RootElement();
    }

    @NotNull
    public Grouper[] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(7);
        }
        return Grouper.EMPTY_ARRAY;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(8);
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(9);
        }
        return Filter.EMPTY_ARRAY;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public boolean shouldEnterElement(Object element2) {
        return false;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element2) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element2) {
        return element2 instanceof ColElement || element2 instanceof GenElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEditorPositionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorPositionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GenElement
    extends PsiTreeElementBase<DbElement>
    implements LocationPresentation,
    WeighedItem {
        private GenElement(DbElement element2) {
            super((PsiElement)element2);
        }

        public void navigate(boolean requestFocus) {
            DbElement element2 = (DbElement)this.getElement();
            if (element2 == null) {
                return;
            }
            DatabaseView.select((PsiElement)element2, requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                GenElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DbElement element2 = (DbElement)this.getElement();
            return element2 == null ? null : DbPresentation.getPresentableName((DasObject)element2, true);
        }

        public Icon getIcon(boolean open) {
            DbElement element2 = (DbElement)this.getElement();
            return element2 == null ? null : DbPresentationCore.getIcon((DasObject)element2);
        }

        public int getWeight() {
            DbElement element2 = (DbElement)this.getElement();
            return element2 == null ? 0 : DbPresentation.getWeight(element2, true);
        }

        public String getLocationString() {
            DbElement element2 = (DbElement)this.getElement();
            if (element2 == null) {
                return null;
            }
            return element2 instanceof DasTypedObject ? ((DasTypedObject)element2).getDataType().getSpecification() : "";
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$GenElement", "getChildrenBase"));
        }
    }

    private static final class ColElement
    extends PsiTreeElementBase<PsiElement>
    implements ColoredItemPresentation,
    LocationPresentation {
        private ColElement(PsiElement element2) {
            super(element2);
        }

        public void navigate(boolean requestFocus) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return;
            }
            target.navigate(requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                ColElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            DataConsumer.Column column2 = target != null ? target.getColumn() : null;
            return column2 != null ? column2.name : null;
        }

        public Icon getIcon(boolean open) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return DatabaseIcons.Col;
            }
            DasColumn dbColumn = DataGridUtil.getDatabaseColumn(target.dataGrid, target.getColumn());
            return dbColumn == null ? null : DbPresentationCore.getIcon((DasObject)dbColumn);
        }

        public String getLocationString() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return null;
            }
            DataGrid dataGrid = target.dataGrid;
            String sqlType = DataGridUtil.getSqlType(dataGrid, target.getColumn());
            Object result = StringUtil.isEmpty((String)sqlType) ? "" : sqlType + " ";
            RowSortOrder.Type sortOrder = dataGrid.getSortOrder(target.column);
            int thenBySortOrder = dataGrid.getThenBySortOrder(target.column);
            if (sortOrder != RowSortOrder.Type.UNSORTED && thenBySortOrder != 0) {
                char arrow;
                boolean isAscending = sortOrder == RowSortOrder.Type.ASC;
                char c2 = arrow = isAscending ? (char)'\u2191' : '\u2193';
                String ordering = StartupUiUtil.getLabelFont().canDisplay(arrow) ? String.valueOf(arrow) : (isAscending ? "A-" : "D-");
                result = (String)result + ordering + thenBySortOrder;
            }
            if (UISettings.getInstance().getShowInplaceComments()) {
                String comment;
                DasColumn dasColumn = DataGridUtil.getDatabaseColumn(dataGrid, target.getColumn());
                String string = comment = dasColumn == null ? null : dasColumn.getComment();
                if (comment != null) {
                    result = (String)result + "  " + DbNodeDescriptor.adjustCommentString(comment);
                }
            }
            return result;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            ModelIndex<DataConsumer.Column> column2 = target != null ? target.column : null;
            return column2 != null && !target.dataGrid.isColumnEnabled(column2) ? DatabaseColors.STRUCTURE_HIDDEN_COLUMN : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$ColElement", "getChildrenBase"));
        }
    }

    private class RootElement
    implements StructureViewTreeElement {
        private RootElement() {
        }

        public Object getValue() {
            return this;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new PresentationData();
        }

        @NotNull
        public TreeElement[] getChildren() {
            List columns2;
            GridModel model = TableEditorStructureViewModel.this.myDataGrid.getDataModel(DataAccessType.DATABASE_DATA);
            List columns = model.getColumnIndices().asList();
            if (!columns.isEmpty()) {
                TreeElement[] result = new TreeElement[columns.size()];
                for (int i2 = 0; i2 < result.length; ++i2) {
                    result[i2] = new ColElement(DataGridPomTarget.wrapColumn(TableEditorStructureViewModel.this.myProject, TableEditorStructureViewModel.this.myDataGrid, (ModelIndex)columns.get(i2)));
                }
                if (result == null) {
                    RootElement.$$$reportNull$$$0(0);
                }
                return result;
            }
            DasTable table = DataGridUtil.getDatabaseTable(TableEditorStructureViewModel.this.myDataGrid);
            List list = columns2 = table == null ? Collections.emptyList() : table.getDasChildren(ObjectKind.COLUMN).filter(DbElement.class).toList();
            if (!columns2.isEmpty()) {
                TreeElement[] result = new TreeElement[columns2.size()];
                for (int i3 = 0; i3 < result.length; ++i3) {
                    result[i3] = new GenElement((DbElement)columns2.get(i3));
                }
                if (result == null) {
                    RootElement.$$$reportNull$$$0(1);
                }
                return result;
            }
            if (EMPTY_ARRAY == null) {
                RootElement.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$RootElement", "getChildren"));
        }
    }
}

