/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorHelperCore {
    protected DatabaseEditorHelperCore() {
    }

    @Nullable
    public static SearchPath getSearchPath(@NotNull PsiFile psiFile) {
        SearchPath res2;
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(0);
        }
        return (res2 = (SearchPath)DatabaseDataKeysCore.SEARCH_PATH_KEY.get((UserDataHolder)psiFile)) != null ? res2 : DatabaseEditorHelperCore.initSearchPath(psiFile);
    }

    @Nullable
    public static SearchPath dbSrcSearchPath(@NotNull Project project, @Nullable VirtualFile vfile, boolean schema) {
        ObjectPath path;
        DbDataSource dataSource2;
        if (project == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(1);
        }
        String dataSourceId = vfile == null ? null : DbSrcUtilsCore.getDataSource(vfile);
        DbDataSource dbDataSource = dataSource2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource2 != null && (path = DbSrcUtilsCore.getFullPath(vfile.getPath())) != null) {
            ObjectKind spKind = DbImplUtilCore.getDatabaseDialect((DbElement)dataSource2).getSearchPathObjectKind();
            if (spKind == null) {
                return null;
            }
            ObjectPath spPath = path.findParent(spKind, false);
            if (spPath != null) {
                return SearchPath.of((ObjectPath)spPath);
            }
        }
        return null;
    }

    @Nullable
    public static SearchPath initSearchPath(@NotNull PsiFile psiFile) {
        JdbcConsoleCore console;
        DbDataSource forcedDataSource;
        if (psiFile == null) {
            DatabaseEditorHelperCore.$$$reportNull$$$0(2);
        }
        VirtualFile vfile = psiFile.getViewProvider().getVirtualFile();
        Project project = psiFile.getProject();
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            SearchPath path = DatabaseEditorHelperCore.dbSrcSearchPath(project, vfile, false);
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        if (vfile instanceof LightVirtualFile && ((LightVirtualFile)vfile).getOriginalFile() != null) {
            vfile = ((LightVirtualFile)vfile).getOriginalFile();
        }
        if (vfile instanceof VirtualFileWindow) {
            vfile = ((VirtualFileWindow)vfile).getDelegate();
        }
        DbDataSource dbDataSource = forcedDataSource = (console = JdbcConsoleProviderCore.getValidConsole(project, vfile)) != null ? DbImplUtilCore.getDbDataSource(project, console.getTarget()) : null;
        if (forcedDataSource != null) {
            SearchPath path = console.getSearchPath();
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            SearchPath path = (SearchPath)DatabaseDataKeysCore.SEARCH_PATH_KEY.get((UserDataHolder)vfile);
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelperCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dbSrcSearchPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initSearchPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

