/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatEditor;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.editor.TableFileEditor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CsvTableFileEditor
extends TableFileEditor
implements CsvFormatEditor {
    private final DataGrid myDataGrid;

    public CsvTableFileEditor(@NotNull Project project, @NotNull CsvTableDataFragmentFile file) {
        if (project == null) {
            CsvTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvTableFileEditor.$$$reportNull$$$0(1);
        }
        super(project, file.getOriginalFile());
        this.myDataGrid = this.createDataGrid(GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this));
        this.registerCsvFormatEditor();
        DataGridUtil.addGridHeaderComponent(this.myDataGrid, file.getOriginalFile());
    }

    public CsvTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvFormat format) {
        if (project == null) {
            CsvTableFileEditor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CsvTableFileEditor.$$$reportNull$$$0(3);
        }
        if (format == null) {
            CsvTableFileEditor.$$$reportNull$$$0(4);
        }
        super(project, file);
        this.myDataGrid = this.createDataGrid(GridDataHookUpManager.getInstance(project).getHookUp(file, format, (Disposable)this));
        this.registerCsvFormatEditor();
        DataGridUtil.addGridHeaderComponent(this.myDataGrid, file);
    }

    private void registerCsvFormatEditor() {
        DataProvider provider = DataManager.getDataProvider((JComponent)((Object)this.myDataGrid.getComponent()));
        DataManager.registerDataProvider((JComponent)((Object)this.myDataGrid.getComponent()), key -> CSV_FORMAT_EDITOR_KEY.is(key) ? this : (provider != null ? provider.getData(key) : null));
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            CsvTableFileEditor.$$$reportNull$$$0(5);
        }
        CsvDocumentDataHookUp hookup = this.getHookup();
        FileEditorState fileEditorState = CsvFormatResolver.getState(level, hookup);
        if (fileEditorState == null) {
            CsvTableFileEditor.$$$reportNull$$$0(6);
        }
        return fileEditorState;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        CsvFormat format;
        if (state == null) {
            CsvTableFileEditor.$$$reportNull$$$0(7);
        }
        if ((format = CsvFormatResolver.readCsvFormat(state)) != null && !format.equals(this.getHookup().getFormat())) {
            this.setFormat(format);
        }
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        DataGrid dataGrid = this.myDataGrid;
        if (dataGrid == null) {
            CsvTableFileEditor.$$$reportNull$$$0(8);
        }
        return dataGrid;
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            CsvTableFileEditor.$$$reportNull$$$0(9);
        }
        this.getHookup().setFormat(format, new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(this.myDataGrid, this.getHookup()));
    }

    @NotNull
    private CsvDocumentDataHookUp getHookup() {
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.myDataGrid.getDataHookup();
        if (csvDocumentDataHookUp == null) {
            CsvTableFileEditor.$$$reportNull$$$0(10);
        }
        return csvDocumentDataHookUp;
    }

    @Override
    public boolean firstRowIsHeader() {
        return this.getHookup().getFormat().headerRecord != null;
    }

    @Override
    public void setFirstRowIsHeader(boolean value2) {
        CsvFormat currentFormat = this.getHookup().getFormat();
        String withHeader = " " + DatabaseBundle.message((String)"csv.format.with.header", (Object[])new Object[0]);
        String withoutHeader = " " + DatabaseBundle.message((String)"csv.format.without.header", (Object[])new Object[0]);
        boolean isTemp = ContainerUtil.find(DatabaseSettings.getSettings().getCsvFormats(), f -> f.id.equals(currentFormat.id)) == null;
        Object newName = isTemp ? StringUtil.trimEnd((String)StringUtil.trimEnd((String)currentFormat.name, (String)withHeader), (String)withoutHeader) : currentFormat.name;
        newName = (String)newName + (value2 ? withHeader : withoutHeader);
        CsvFormat newFormat = new CsvFormat((String)newName, currentFormat.dataRecord, value2 ? currentFormat.dataRecord : null, currentFormat.rowNumbers);
        CsvFormat existingFormat = (CsvFormat)ContainerUtil.find(DatabaseSettings.getSettings().getCsvFormats(), f -> DatabaseSettings.formatsSimilar(f, newFormat));
        this.setFormat((CsvFormat)ObjectUtils.notNull((Object)existingFormat, (Object)newFormat));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/CsvTableFileEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/CsvTableFileEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

