/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.IdentityDataProducer;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dump.DumpRequest;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Out;
import com.intellij.database.util.SearchPath;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DumpHandler<T> {
    private static final Logger LOG = Logger.getInstance(DumpHandler.class);
    protected final Project myProject;
    protected final JBIterable<? extends T> mySources;
    protected final DumpSourceNameProvider<T> myNameProvider;
    protected final @NlsContexts.ProgressTitle String myTitle;
    private final DataExtractorFactory myFactory;
    private final ExtractionConfig myConfig;
    protected final ExtractionHelper myManager;
    private final ErrorHandler myHandler;
    private long myLength;
    private int myRowsCount;
    private int myProcessedCount;

    protected DumpHandler(@NotNull Project project, @NotNull JBIterable<? extends T> sources, @NotNull DumpSourceNameProvider<T> nameProvider, @NotNull ExtractionHelper manager, @NotNull String displayName, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (project == null) {
            DumpHandler.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            DumpHandler.$$$reportNull$$$0(1);
        }
        if (nameProvider == null) {
            DumpHandler.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            DumpHandler.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            DumpHandler.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            DumpHandler.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpHandler.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myManager = manager;
        this.mySources = sources;
        this.myNameProvider = nameProvider;
        this.myTitle = this.myManager.getTitle(displayName);
        this.myFactory = factory;
        this.myConfig = config;
        this.myHandler = new ErrorHandler();
    }

    @NotNull
    protected abstract Dbms getDbms(@NotNull T var1);

    protected abstract int getResultSetIndex(@NotNull T var1);

    @Nullable
    protected abstract ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull T var1);

    @Nullable
    protected abstract AsyncPromise<Void> run(@NotNull T var1, @NotNull DataExtractor var2, @NotNull Out var3, @NotNull DumpHandlerParameters var4);

    @Nullable
    protected abstract DasDataSource getDatabaseSystem();

    @Nullable
    protected abstract String getProducerName();

    @Nullable
    protected abstract String getSourceName(int var1);

    @Nullable
    protected DasTable getTable(@NotNull T source) {
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    protected ObjectFormatter getFormatter(@NotNull T source) {
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    protected NotNullFunction<DataExtractor, DataRequest> newSimpleRunner(@NotNull DataProducer producer, DataRequest.Owner owner, @NotNull Out output, @NotNull DumpHandlerParameters dumpParameters) {
        if (producer == null) {
            DumpHandler.$$$reportNull$$$0(9);
        }
        if (output == null) {
            DumpHandler.$$$reportNull$$$0(10);
        }
        if (dumpParameters == null) {
            DumpHandler.$$$reportNull$$$0(11);
        }
        NotNullFunction notNullFunction = extractor -> {
            DataRequest request = this.createDumpRequest(owner, (DataExtractor)extractor, output, null, dumpParameters);
            producer.processRequest(request);
            return request;
        };
        if (notNullFunction == null) {
            DumpHandler.$$$reportNull$$$0(12);
        }
        return notNullFunction;
    }

    protected final boolean isSingleSource() {
        return this.mySources.skip(1).isEmpty();
    }

    private void processError(@Nullable Throwable th) {
        this.myHandler.addError(null, th);
    }

    public void performDump(@Nullable Project project) {
        Task.Backgroundable task = this.buildTask(this.myFactory, project);
        if (task == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    public Task.Backgroundable buildTask(@NotNull DataExtractorFactory factory, @Nullable Project project) {
        if (factory == null) {
            DumpHandler.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final List pairs = this.mySources.map(s2 -> {
            Dbms dbms = this.getDbms(s2);
            int resultSetIndex = this.getResultSetIndex(s2);
            ModelIndexSet<DataConsumer.Column> selectedColumns = this.getSelectedColumns(s2);
            String queryText2 = this.myNameProvider.getQueryText(s2);
            String name = this.myNameProvider.getName(s2);
            DataExtractor extractor = factory.createExtractor(project, this.getDbms(s2), this.getFormatter(s2), this.getTable(s2));
            return extractor != null && queryText2 != null && name != null ? new Triple(s2, (Object)extractor, (Object)new DumpHandlerParameters(selectedColumns, dbms, queryText2, resultSetIndex, name)) : null;
        }).filter(p2 -> p2 != null).toList();
        if (pairs.isEmpty()) {
            return null;
        }
        return new Task.Backgroundable(this.myProject, this.myTitle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(DatabaseBundle.message((String)"progress.text.initializing.output", (Object[])new Object[0]));
                indicator.setIndeterminate(true);
                Out previousOutput = null;
                try {
                    for (Triple p2 : pairs) {
                        indicator.checkCanceled();
                        if (p2.getSecond() == null) continue;
                        previousOutput = DumpHandler.this.processSource(p2.getFirst(), (DataExtractor)p2.getSecond(), indicator, (DumpHandlerParameters)p2.getThird(), previousOutput);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    DumpHandler.this.dumpFinished(previousOutput);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/DumpHandler$1", "run"));
            }
        };
    }

    private void dumpFinished(@Nullable Out lastOutput) {
        try {
            DasDataSource system = this.getDatabaseSystem();
            DumpInfo info = new DumpInfo(system == null ? DatabaseBundle.message((String)"notification.title.data.dump", (Object[])new Object[0]) : system.getName(), this.myHandler.getSummary(), this.getSourceName(this.myProcessedCount), this.getProducerName(), this.myRowsCount, this.myProcessedCount);
            if (lastOutput != null && this.myManager.isSingleFileMode()) {
                lastOutput.close();
            }
            this.myManager.after(this.myProject, info);
        }
        catch (Exception e) {
            String message2 = e.getMessage();
            if (message2 == null) {
                LOG.warn((Throwable)e);
                return;
            }
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message((String)"notification.title.data.dump", (Object[])new Object[0]), message2, NotificationType.ERROR, null).notify(this.myProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Out processSource(@NotNull T source, @NotNull DataExtractor extractor, @NotNull ProgressIndicator indicator, @NotNull DumpHandlerParameters dumpParameters, @Nullable Out previousOutput) {
        Out output;
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(14);
        }
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            DumpHandler.$$$reportNull$$$0(16);
        }
        if (dumpParameters == null) {
            DumpHandler.$$$reportNull$$$0(17);
        }
        AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        try {
            output = this.refreshOut(dumpParameters.name, extractor, previousOutput);
        }
        catch (Exception e) {
            this.processError(e);
            return null;
        }
        indicator.setText(DatabaseBundle.message((String)"progress.text.running.query", (Object[])new Object[0]));
        AsyncPromise<Void> promise = this.run(source, extractor, output, dumpParameters);
        if (promise == null) {
            return output;
        }
        promise.onProcessed(o -> result.set((Object)true));
        try {
            result.get();
        }
        catch (Exception e) {
            this.processError(e);
        }
        finally {
            ++this.myProcessedCount;
            this.sourceDumped(extractor, output);
        }
        return output;
    }

    private Out refreshOut(@NotNull String name, @NotNull DataExtractor extractor, @Nullable Out previousOutput) throws Exception {
        if (name == null) {
            DumpHandler.$$$reportNull$$$0(18);
        }
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(19);
        }
        if (this.myManager.isSingleFileMode() && previousOutput != null) {
            if (previousOutput instanceof CharOut) {
                CharOut charOut = (CharOut)previousOutput;
                if (charOut.length() > this.myLength) {
                    charOut.append("\n");
                }
                this.myLength = charOut.length();
            }
            return previousOutput;
        }
        return this.myManager.createOut(name, extractor);
    }

    private void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out output) {
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(20);
        }
        if (output == null) {
            DumpHandler.$$$reportNull$$$0(21);
        }
        if (this.myManager.isSingleFileMode()) {
            return;
        }
        try {
            this.myManager.sourceDumped(extractor, output);
            output.close();
        }
        catch (Exception ex) {
            this.processError(ex);
        }
    }

    @NotNull
    DataRequest createDumpRequest(DataRequest.Owner owner, DataExtractor extractor, @NotNull Out output, @Nullable String name, @NotNull DumpHandlerParameters dumpParameters) {
        if (output == null) {
            DumpHandler.$$$reportNull$$$0(22);
        }
        if (dumpParameters == null) {
            DumpHandler.$$$reportNull$$$0(23);
        }
        DataRequest.Constraints constraints = DataRequest.newConstraints(0, -1, 0, dumpParameters.resultSetIndex, Integer.MAX_VALUE);
        return new MyRequest(owner, dumpParameters.queryText, constraints, dumpParameters.selectedColumns, extractor, dumpParameters.dbms, Objects.requireNonNull(output), name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 10: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpParameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newSimpleRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFormatter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSimpleRunner";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildTask";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSource";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refreshOut";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sourceDumped";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDumpRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DumpHandlerParameters {
        final ModelIndexSet<DataConsumer.Column> selectedColumns;
        final Dbms dbms;
        final String queryText;
        final int resultSetIndex;
        private final String name;

        private DumpHandlerParameters(@Nullable ModelIndexSet<DataConsumer.Column> selectedColumns, @NotNull Dbms dbms, @NotNull String queryText2, int resultSetIndex, @NotNull String name) {
            if (dbms == null) {
                DumpHandlerParameters.$$$reportNull$$$0(0);
            }
            if (queryText2 == null) {
                DumpHandlerParameters.$$$reportNull$$$0(1);
            }
            if (name == null) {
                DumpHandlerParameters.$$$reportNull$$$0(2);
            }
            this.selectedColumns = selectedColumns;
            this.dbms = dbms;
            this.queryText = queryText2;
            this.resultSetIndex = resultSetIndex;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "queryText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dump/DumpHandler$DumpHandlerParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DumpInfo {
        private final String myProducerName;
        private final @NlsContexts.NotificationContent String myErrorSummary;
        private final String mySourceName;
        private final @NlsContexts.NotificationTitle String myTitle;
        private final long myRowCount;
        private final int mySourcesCount;

        /*
         * WARNING - void declaration
         */
        DumpInfo(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String errorSummary, @Nullable String sourceName, @Nullable String producerName, long rowCount, int n) {
            void sourcesCount;
            if (title == null) {
                DumpInfo.$$$reportNull$$$0(0);
            }
            if (errorSummary == null) {
                DumpInfo.$$$reportNull$$$0(1);
            }
            this.mySourceName = sourceName;
            this.myTitle = title;
            this.myRowCount = rowCount;
            this.myProducerName = producerName;
            this.myErrorSummary = errorSummary;
            this.mySourcesCount = sourcesCount;
        }

        public long getRowCount() {
            return this.myRowCount;
        }

        @NlsContexts.NotificationContent
        @NotNull
        public String getErrorSummary() {
            String string = this.myErrorSummary;
            if (string == null) {
                DumpInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getProducerName() {
            return this.myProducerName;
        }

        @Nullable
        public String getSourceName() {
            return this.mySourceName;
        }

        public int getSourcesCount() {
            return this.mySourcesCount;
        }

        @NlsContexts.NotificationTitle
        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                DumpInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSummary";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$DumpInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$DumpInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorSummary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GridHandler
    extends DumpHandler<DataGrid> {
        public GridHandler(@NotNull Project project, @NotNull DataGrid target, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
            if (project == null) {
                GridHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                GridHandler.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                GridHandler.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                GridHandler.$$$reportNull$$$0(3);
            }
            if (config == null) {
                GridHandler.$$$reportNull$$$0(4);
            }
            super(project, JBIterable.of((Object)target), DumpSourceNameProvider.DataGridSourceNameProvider.INSTANCE, manager, target.getDisplayName(), factory, config);
        }

        @Override
        @NotNull
        protected Dbms getDbms(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(5);
            }
            Dbms dbms = DataGridUtil.getDbms(source);
            if (dbms == null) {
                GridHandler.$$$reportNull$$$0(6);
            }
            return dbms;
        }

        @Override
        @Nullable
        protected DasTable getTable(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(7);
            }
            return DataGridUtil.getDatabaseTable(source);
        }

        @Override
        @NotNull
        protected ObjectFormatter getFormatter(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(8);
            }
            ObjectFormatter objectFormatter = source.getObjectFormatter();
            if (objectFormatter == null) {
                GridHandler.$$$reportNull$$$0(9);
            }
            return objectFormatter;
        }

        @Override
        protected int getResultSetIndex(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(10);
            }
            return DataGridUtil.getResultSetIndex(source);
        }

        @Override
        @Nullable
        protected String getProducerName() {
            DataGrid item = (DataGrid)this.mySources.first();
            VirtualFile file = DataGridUtil.getVirtualFile(Objects.requireNonNull(item));
            return file != null ? file.getName() : DataGridUtil.getResultSetName(this.myProject, Objects.requireNonNull(item));
        }

        @Override
        @Nullable
        protected String getSourceName(int count) {
            return null;
        }

        @Override
        @Nullable
        protected DasDataSource getDatabaseSystem() {
            DataGrid item = (DataGrid)this.mySources.first();
            return DataGridUtil.getDatabaseSystem(item);
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DataGrid source) {
            ModelIndexSet<DataConsumer.Column> visibleColumns;
            if (source == null) {
                GridHandler.$$$reportNull$$$0(11);
            }
            return (visibleColumns = source.getVisibleColumns()).size() == source.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() ? null : visibleColumns;
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DataGrid source, @NotNull DataExtractor extractor, @NotNull Out output, @NotNull DumpHandlerParameters dumpParameters) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(12);
            }
            if (extractor == null) {
                GridHandler.$$$reportNull$$$0(13);
            }
            if (output == null) {
                GridHandler.$$$reportNull$$$0(14);
            }
            if (dumpParameters == null) {
                GridHandler.$$$reportNull$$$0(15);
            }
            DataProducer producer = GridHandler.getProducer(source, dumpParameters.resultSetIndex);
            DataRequest.Owner owner = GridHandler.getOwner(source);
            return producer != null ? ((DataRequest)((Object)this.newSimpleRunner(producer, owner, output, dumpParameters).fun((Object)extractor))).getPromise() : null;
        }

        @Nullable
        private static DataProducer getProducer(@NotNull DataGrid grid, int myResultSetIndex) {
            if (grid == null) {
                GridHandler.$$$reportNull$$$0(16);
            }
            GridPagingModel pageModel = grid.getDataHookup().getPageModel();
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(grid);
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            return pageModel.isFirstPage() && pageModel.isLastPage() && !GridHandler.hasTruncatedData(model.getColumns(), model.getRows()) ? new IdentityDataProducer(new DataConsumer.Composite(new DataConsumer[0]), model.getColumns(), new ArrayList<DataConsumer.Row>(model.getRows()), myResultSetIndex) : (hookUp != null ? hookUp.getMessageBus().getDataProducer() : null);
        }

        public static boolean hasTruncatedData(@NotNull List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
            if (columns == null) {
                GridHandler.$$$reportNull$$$0(17);
            }
            for (DataConsumer.Row row : rows) {
                for (DataConsumer.Column column2 : columns) {
                    Object value2 = column2.getValue(row);
                    if (!(value2 instanceof LobInfo) || !((LobInfo)value2).isTruncated()) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private static DataRequest.Owner getOwner(@NotNull DataGrid grid) {
            GridPagingModel pageModel;
            if (grid == null) {
                GridHandler.$$$reportNull$$$0(18);
            }
            DataRequest.Owner owner = (pageModel = grid.getDataHookup().getPageModel()).isFirstPage() && pageModel.isLastPage() || DataGridUtil.getDataBusHookUp(grid) == null ? DataRequest.newOwner() : DataGridUtil.getDataBusHookUp(grid);
            if (owner == null) {
                GridHandler.$$$reportNull$$$0(19);
            }
            return owner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 9: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 9: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 6: 
                case 9: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$GridHandler";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dumpParameters";
                    break;
                }
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$GridHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDbms";
                    break;
                }
                case 6: 
                case 9: 
                case 19: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFormatter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getProducer";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "hasTruncatedData";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getOwner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 9: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConsoleHandler
    extends DumpHandler<String> {
        private final JdbcConsole myConsole;

        public ConsoleHandler(@NotNull Project project, @NotNull JBIterable<String> target, @NotNull JdbcConsole console, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
            if (project == null) {
                ConsoleHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ConsoleHandler.$$$reportNull$$$0(1);
            }
            if (console == null) {
                ConsoleHandler.$$$reportNull$$$0(2);
            }
            if (manager == null) {
                ConsoleHandler.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                ConsoleHandler.$$$reportNull$$$0(4);
            }
            if (config == null) {
                ConsoleHandler.$$$reportNull$$$0(5);
            }
            super(project, target, DumpSourceNameProvider.ConsoleSourceNameProvider.INSTANCE, manager, console.getDisplayName(), factory, config);
            this.myConsole = console;
        }

        @Override
        @NotNull
        protected Dbms getDbms(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(6);
            }
            Dbms dbms = this.myConsole.getDataSource().getDbms();
            if (dbms == null) {
                ConsoleHandler.$$$reportNull$$$0(7);
            }
            return dbms;
        }

        @Override
        protected int getResultSetIndex(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(8);
            }
            return 1;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(9);
            }
            return null;
        }

        @Override
        @Nullable
        protected DasDataSource getDatabaseSystem() {
            return this.myConsole.getDataSource();
        }

        @Override
        @Nullable
        protected String getProducerName() {
            return null;
        }

        @Override
        @Nullable
        protected String getSourceName(int count) {
            return DatabaseBundle.message((String)"export.query.result", (Object[])new Object[]{count});
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull String source, @NotNull DataExtractor extractor, @NotNull Out output, @NotNull DumpHandlerParameters dumpParameters) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(10);
            }
            if (extractor == null) {
                ConsoleHandler.$$$reportNull$$$0(11);
            }
            if (output == null) {
                ConsoleHandler.$$$reportNull$$$0(12);
            }
            if (dumpParameters == null) {
                ConsoleHandler.$$$reportNull$$$0(13);
            }
            return ((DataRequest)((Object)this.newSimpleRunner(this.myConsole.getMessageBus().getDataProducer(), this.myConsole, output, dumpParameters).fun((Object)extractor))).getPromise();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$ConsoleHandler";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dumpParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$ConsoleHandler";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDbms";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DatabaseViewHandler
    extends DumpHandler<DbTable> {
        public DatabaseViewHandler(@NotNull Project project, @NotNull JBIterable<DbTable> target, @NotNull ExtractionHelper manager, @NotNull ExtractionConfig config, @NotNull DataExtractorFactory factory) {
            if (project == null) {
                DatabaseViewHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                DatabaseViewHandler.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                DatabaseViewHandler.$$$reportNull$$$0(2);
            }
            if (config == null) {
                DatabaseViewHandler.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                DatabaseViewHandler.$$$reportNull$$$0(4);
            }
            super(project, target, DumpSourceNameProvider.DbTablesSourceNameProvider.INSTANCE, manager, DatabaseViewHandler.getName(target), factory, config);
        }

        @NotNull
        private static String getName(@NotNull JBIterable<DbTable> target) {
            if (target == null) {
                DatabaseViewHandler.$$$reportNull$$$0(5);
            }
            return target.skip(1).isEmpty() ? Objects.requireNonNull((DbTable)target.first()).getName() : "tables";
        }

        @Override
        @NotNull
        protected Dbms getDbms(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(6);
            }
            Dbms dbms = source.getDataSource().getDbms();
            if (dbms == null) {
                DatabaseViewHandler.$$$reportNull$$$0(7);
            }
            return dbms;
        }

        @Override
        @Nullable
        protected DasTable getTable(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(8);
            }
            return source;
        }

        @Override
        protected int getResultSetIndex(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(9);
            }
            return 1;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(10);
            }
            return null;
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DbTable source, @NotNull DataExtractor extractor, @NotNull Out output, @NotNull DumpHandlerParameters dumpParameters) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(11);
            }
            if (extractor == null) {
                DatabaseViewHandler.$$$reportNull$$$0(12);
            }
            if (output == null) {
                DatabaseViewHandler.$$$reportNull$$$0(13);
            }
            if (dumpParameters == null) {
                DatabaseViewHandler.$$$reportNull$$$0(14);
            }
            return ((DataRequest)((Object)this.newEngineRunner(source, output, dumpParameters).fun((Object)extractor))).getPromise();
        }

        @Override
        @Nullable
        protected DasDataSource getDatabaseSystem() {
            JBIterable uniqueSources = this.mySources.transform(DbElement::getDataSource).unique();
            return uniqueSources.skip(1).isEmpty() ? (DasDataSource)Objects.requireNonNull((DbDataSource)uniqueSources.first()) : null;
        }

        @Override
        @Nullable
        protected String getProducerName() {
            return this.isSingleSource() ? Objects.requireNonNull((DbTable)this.mySources.first()).getName() : null;
        }

        @Override
        @Nullable
        protected String getSourceName(int count) {
            return DatabaseBundle.message((String)"export.table", (Object[])new Object[]{count});
        }

        @NotNull
        NotNullFunction<DataExtractor, DataRequest> newEngineRunner(@NotNull DbTable table, @NotNull Out output, @NotNull DumpHandlerParameters dumpParameters) {
            if (table == null) {
                DatabaseViewHandler.$$$reportNull$$$0(15);
            }
            if (output == null) {
                DatabaseViewHandler.$$$reportNull$$$0(16);
            }
            if (dumpParameters == null) {
                DatabaseViewHandler.$$$reportNull$$$0(17);
            }
            NotNullFunction notNullFunction = extractor -> {
                LocalDataSource dataSource2 = DbImplUtil.getLocalDataSource((DasDataSource)table.getDataSource());
                DasNamespace namespace = DbImplUtil.getSearchPathObjectForSwitch((DbElement)table);
                SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)namespace);
                DatabaseSessionManager.Facade facade = DatabaseSessionManager.facade(this.myProject, dataSource2, null, searchPath, false, null, DGDepartment.DATA_EXPORT);
                DatabaseSessionClient client = facade.client();
                DataRequest request = this.createDumpRequest(client, (DataExtractor)extractor, output, table.getName(), dumpParameters);
                request.getPromise().onProcessed(v -> Disposer.dispose((Disposable)client));
                client.getMessageBus().getDataProducer().processRequest(request);
                return request;
            };
            if (notNullFunction == null) {
                DatabaseViewHandler.$$$reportNull$$$0(18);
            }
            return notNullFunction;
        }

        @Override
        @NotNull
        DataRequest createDumpRequest(DataRequest.Owner owner, DataExtractor extractor, @NotNull Out output, @Nullable String name, final @NotNull DumpHandlerParameters dumpParameters) {
            if (output == null) {
                DatabaseViewHandler.$$$reportNull$$$0(19);
            }
            if (dumpParameters == null) {
                DatabaseViewHandler.$$$reportNull$$$0(20);
            }
            DataRequest.Constraints constraints = DataRequest.newConstraints(0, -1, 0, dumpParameters.resultSetIndex, Integer.MAX_VALUE);
            return new MyRequest(owner, dumpParameters.queryText, constraints, dumpParameters.selectedColumns, extractor, dumpParameters.dbms, Objects.requireNonNull(output), name){

                @Override
                public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (rows == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ObjectFormatter.convertRows(rows, Arrays.asList(this.myColumns), dumpParameters.dbms);
                    super.addRows(context, rows);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "rows";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler$1";
                    objectArray[2] = "addRows";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 13: 
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 14: 
                case 17: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dumpParameters";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newEngineRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDbms";
                    break;
                }
                case 7: 
                case 18: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "newEngineRunner";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "createDumpRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class MyRequest
    extends DumpRequest {
        protected MyRequest(@NotNull DataRequest.Owner owner, @NotNull String query, @Nullable DataRequest.Constraints constraints, @NotNull ModelIndexSet<DataConsumer.Column> columns, @NotNull DataExtractor extractor, @NotNull Dbms dbms, @Nullable Out output, String name) {
            if (owner == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (extractor == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            if (dbms == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            if (output == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            super(owner, query, constraints, columns, extractor, dbms, output, name, DumpHandler.this.myConfig);
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
            if (context == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
            if (rows == null) {
                MyRequest.$$$reportNull$$$0(7);
            }
            super.addRows(context, rows);
            DumpHandler.this.myRowsCount += rows.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dump/DumpHandler$MyRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

