/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseDialects {
    protected DatabaseDialects() {
    }

    @NotNull
    public static DatabaseDialectEx getGenericDialect() {
        DatabaseDialectEx databaseDialectEx = Objects.requireNonNull(DatabaseDialects.findByDbms(Dbms.UNKNOWN));
        if (databaseDialectEx == null) {
            DatabaseDialects.$$$reportNull$$$0(0);
        }
        return databaseDialectEx;
    }

    public static boolean isGenericDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DatabaseDialects.$$$reportNull$$$0(1);
        }
        return DatabaseDialects.getGenericDialect().getClass().isAssignableFrom(dialect.getClass());
    }

    @Nullable
    public static DatabaseDialectEx findByDbms(@Nullable Dbms dbms) {
        return dbms == null ? null : (DatabaseDialectEx)DatabaseDialect.EP.forDbms(dbms);
    }

    @TestOnly
    @NotNull
    public static Collection<DatabaseDialectEx> getSupportedDialects() {
        Collection collection = JBIterable.from((Iterable)DatabaseDialect.EP.allExtensions()).map(b2 -> (DatabaseDialectEx)b2.getInstance()).addAllTo(new TreeSet<DatabaseDialectEx>(Comparator.comparing(d2 -> d2.getDbms())));
        if (collection == null) {
            DatabaseDialects.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DatabaseDialects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DatabaseDialects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDialects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isGenericDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

