/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import icons.DatabaseIcons;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramProvider
extends DiagramProvider<DbElement>
implements DumbAware {
    public static final String ID = "DATABASE";
    static final DiagramCategory VIRTUAL_FOREIGN_KEYS = new DiagramCategory(DatabaseBundle.message((String)"category.name.virtual.foreign.keys", (Object[])new Object[0]), DatabaseIcons.BlueKey, true, true);
    static final DiagramCategory COMMENTS = new DiagramCategory(DatabaseBundle.message((String)"category.name.comments", (Object[])new Object[0]), AllIcons.General.Balloon, false);
    private final EmptyDiagramVisibilityManager myVisibilityManager = new EmptyDiagramVisibilityManager();
    private final DbDiagramElementManager myElementManager = new DbDiagramElementManager();
    private final DiagramNodeContentManager myCategoryManager = this.createNodeContentManager();
    private final DiagramVfsResolver<DbElement> myVfsResolver = new DiagramVfsResolver<DbElement>(){

        public String getQualifiedName(@Nullable DbElement element2) {
            return element2 == null ? null : element2.getDataSource().getUniqueId() + (String)(element2 instanceof DbDataSource ? "" : "." + element2.getKind().name() + ":" + QNameUtil.getQualifiedName(element2));
        }

        public DbElement resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
            if (fqn == null) {
                1.$$$reportNull$$$0(0);
            }
            if (project == null) {
                1.$$$reportNull$$$0(1);
            }
            int idx = fqn.indexOf(46);
            DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(idx == -1 ? fqn : fqn.substring(0, idx));
            if (dataSource2 == null || idx == -1) {
                return dataSource2;
            }
            String typedQName = fqn.substring(idx + 1);
            String qname = typedQName.substring(typedQName.indexOf(58) + 1);
            for (DasObject object : QNameUtil.findByQName(dataSource2.getModel(), qname, (Function<? super DasObject, String>)DasUtil.TO_NAME)) {
                if (!typedQName.startsWith(object.getKind().name() + ":")) continue;
                return DbImplUtil.findElement(dataSource2, object);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/diagram/DbDiagramProvider$1";
            objectArray[2] = "resolveElementByFQN";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DiagramRelationshipManager<DbElement> myRelationshipManager = new DiagramRelationshipManager<DbElement>(){

        @Nullable
        public DiagramRelationshipInfo getDependencyInfo(DbElement e1, DbElement e2, DiagramCategory category) {
            return null;
        }

        public DiagramCategory @NotNull [] getContentCategories() {
            if (DiagramCategory.EMPTY_ARRAY == null) {
                2.$$$reportNull$$$0(0);
            }
            return DiagramCategory.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diagram/DbDiagramProvider$2", "getContentCategories"));
        }
    };
    private final DiagramExtras<DbElement> myExtras = new DiagramExtras<DbElement>(){
        private final DiagramDnDProvider<DbElement> DND_PROVIDER = new DiagramDnDProvider<DbElement>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return DbDiagramElementManager.isAcceptedAsNodeImpl(o);
            }

            public DbElement[] wrapToModelObject(Object o, Project project) {
                return new DbElement[]{(DbElement)o};
            }
        };

        public DiagramElementsProvider<DbElement> @NotNull [] getElementsProviders() {
            if (DiagramElementsProvider.EMPTY_ARRAY == null) {
                3.$$$reportNull$$$0(0);
            }
            return DiagramElementsProvider.EMPTY_ARRAY;
        }

        public DiagramDnDProvider<DbElement> getDnDProvider() {
            return this.DND_PROVIDER;
        }

        @Nullable
        public Object getData(@NotNull String dataId, List<DiagramNode<DbElement>> nodes, DiagramBuilder builder) {
            if (dataId == null) {
                3.$$$reportNull$$$0(1);
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "reference.persistencediagram";
            }
            return super.getData(dataId, nodes, builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsProviders";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public DbDiagramProvider() {
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return ID;
    }

    @NotNull
    public DiagramVisibilityManager createVisibilityManager() {
        EmptyDiagramVisibilityManager emptyDiagramVisibilityManager = this.myVisibilityManager;
        if (emptyDiagramVisibilityManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(0);
        }
        return emptyDiagramVisibilityManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = this.myCategoryManager;
        if (diagramNodeContentManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(1);
        }
        return diagramNodeContentManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new AbstractDiagramNodeContentManager(){
            private final DiagramCategory COLUMNS = new DiagramCategory(DatabaseBundle.message((String)"category.name.columns", (Object[])new Object[0]), DatabaseIcons.Col, true);
            private final DiagramCategory ID_COLUMNS = new DiagramCategory(DatabaseBundle.message((String)"category.name.key.columns", (Object[])new Object[0]), DatabaseIcons.ColGoldKey, true);
            private final DiagramCategory[] CATEGORIES = new DiagramCategory[]{this.ID_COLUMNS, this.COLUMNS, VIRTUAL_FOREIGN_KEYS, COMMENTS};

            public DiagramCategory @NotNull [] getContentCategories() {
                if (this.CATEGORIES == null) {
                    4.$$$reportNull$$$0(0);
                }
                return this.CATEGORIES;
            }

            public boolean isInCategory(@Nullable Object element2, @NotNull DiagramCategory category) {
                if (category == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (this.COLUMNS.equals((Object)category)) {
                    return element2 instanceof DbColumn && !DasUtil.isPrimary((DasColumn)((DbColumn)element2));
                }
                if (this.ID_COLUMNS.equals((Object)category)) {
                    return element2 instanceof DbColumn && DasUtil.isPrimary((DasColumn)((DbColumn)element2));
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentCategories";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isInCategory";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public DiagramElementManager<DbElement> getElementManager() {
        DbDiagramElementManager dbDiagramElementManager = this.myElementManager;
        if (dbDiagramElementManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(2);
        }
        return dbDiagramElementManager;
    }

    @NotNull
    public DiagramVfsResolver<DbElement> getVfsResolver() {
        DiagramVfsResolver<DbElement> diagramVfsResolver = this.myVfsResolver;
        if (diagramVfsResolver == null) {
            DbDiagramProvider.$$$reportNull$$$0(3);
        }
        return diagramVfsResolver;
    }

    @NotNull
    public DiagramRelationshipManager<DbElement> getRelationshipManager() {
        DiagramRelationshipManager<DbElement> diagramRelationshipManager = this.myRelationshipManager;
        if (diagramRelationshipManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramRelationshipManager;
    }

    @NotNull
    public DiagramDataModel<DbElement> createDataModel(@NotNull Project project, @Nullable DbElement element2, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            DbDiagramProvider.$$$reportNull$$$0(5);
        }
        if (presentationModel == null) {
            DbDiagramProvider.$$$reportNull$$$0(6);
        }
        return new DbDiagramDataModel(project, element2, this);
    }

    @NotNull
    public DiagramExtras<DbElement> getExtras() {
        DiagramExtras<DbElement> diagramExtras = this.myExtras;
        if (diagramExtras == null) {
            DbDiagramProvider.$$$reportNull$$$0(7);
        }
        return diagramExtras;
    }

    @NotNull
    public String getActionName(boolean isPopup) {
        String string = DatabaseBundle.message((String)"database.uml.action.name", (Object[])new Object[0]);
        if (string == null) {
            DbDiagramProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = DatabaseBundle.message((String)"database.schema.diagram", (Object[])new Object[0]);
        if (string == null) {
            DbDiagramProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibilityManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationshipManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

