/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.diagram.DbDiagramProvider;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramElementManager
extends AbstractDiagramElementManager<DbElement> {
    @Nullable
    public DbElement findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(0);
        }
        return (DbElement)DatabaseView.getSelectedElements(context, (Condition<? super DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup)).first();
    }

    @NotNull
    public Collection<DbElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(1);
        }
        Set set = DatabaseView.getSelectedElements(context, (Condition<? super DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup)).filter(this::isAcceptableAsNode).toSet();
        if (set == null) {
            DbDiagramElementManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isAcceptableAsNode(@Nullable Object element2) {
        return DbDiagramElementManager.isAcceptedAsNodeImpl(element2);
    }

    public static boolean isAcceptedAsNodeImpl(Object element2) {
        if (!(element2 instanceof DbElement)) {
            return false;
        }
        return element2 instanceof DbTable && DbImplUtilCore.isDataTable((DasTable)((DbTable)element2)) || element2 instanceof DasNamespace || element2 instanceof DbDataSource;
    }

    public Object @NotNull [] getNodeItems(@NotNull DbElement parent2) {
        if (parent2 == null) {
            DbDiagramElementManager.$$$reportNull$$$0(3);
        }
        if (!parent2.isValid()) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                DbDiagramElementManager.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        SmartList result = new SmartList();
        for (DbElement element2 : parent2.getDasChildren(null)) {
            if (element2 instanceof DbTableKey) continue;
            result.add(element2);
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
        if (objectArray == null) {
            DbDiagramElementManager.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element2, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DbDiagramElementManager.$$$reportNull$$$0(6);
        }
        return element2 instanceof DbElement ? ((DbElement)element2).getIcon() : super.getItemIcon(element2, presentation);
    }

    public boolean canCollapse(DbElement element2) {
        return false;
    }

    public boolean isContainerFor(DbElement parent2, DbElement child) {
        return child.getParent() == parent2;
    }

    public String getElementTitle(DbElement element2) {
        return element2.getName();
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element2, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DbDiagramElementManager.$$$reportNull$$$0(7);
        }
        if (element2 instanceof DbElement) {
            SimpleColoredText text2 = new SimpleColoredText(((DbElement)element2).getName(), DEFAULT_TITLE_ATTR);
            String comment = ((DbElement)element2).getComment();
            if (builder.getDataModel().getNodeContentManager().isCategoryEnabled(DbDiagramProvider.COMMENTS) && !StringUtil.isEmptyOrSpaces((String)comment)) {
                text2.append(" " + comment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            return text2;
        }
        return null;
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element2) {
        if (element2 instanceof DbColumn) {
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
            String typeName = dialect.getTypeName(((DbColumn)element2).getDataType());
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(DbElement element2) {
        if (!element2.isValid()) {
            return null;
        }
        String comment = element2.getComment();
        if (StringUtil.isNotEmpty((String)comment)) {
            return "<html><pre>" + StringUtil.escapeXmlEntities((String)DbNodeDescriptor.adjustCommentString(comment)) + "</pre>";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

