/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsStorage
implements Iterable<Integer> {
    private static final double MULTIPLIER = 1.5;
    private final double myMultiplier;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final RowsCounter myModifiedRowsCounter;
    private final RowsCounter myRowsWithUnparsedValuesCounter;
    private MutationData[][] myValues;
    private int myMaxRows;
    private int myRows;
    private int myMaxColumns;
    private int myColumns;

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(0);
        }
        this(model, rows, columns, 1.5);
    }

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns, double multiplier) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(1);
        }
        this.myMultiplier = multiplier;
        this.myRows = rows;
        this.myColumns = columns;
        this.myMaxRows = this.getIncreasedValue(rows);
        this.myMaxColumns = this.getIncreasedValue(columns);
        this.myModel = model;
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModifiedRowsCounter = new ModifiedRowsCounter();
        this.myRowsWithUnparsedValuesCounter = new RowsWithUnparsedValuesCounter();
    }

    public void set(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable CellMutation value2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(2);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(3);
        }
        if (!this.isValid(row, column2)) {
            return;
        }
        int rowIdx = row.asInteger();
        int colIdx = column2.asInteger();
        if (rowIdx >= this.myMaxRows || colIdx >= this.myMaxColumns) {
            this.reallocate(Math.max(rowIdx, this.myMaxRows), Math.max(colIdx, this.myMaxColumns));
        }
        this.increase(rowIdx, colIdx);
        if (this.myValues[rowIdx] == null) {
            this.myValues[rowIdx] = new MutationData[this.myMaxColumns];
        }
        this.countModifications(value2, rowIdx, colIdx);
        this.myValues[rowIdx][colIdx] = value2 == null ? null : new MutationData(value2.getValue());
    }

    public void shiftUp(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(4);
        }
        int idx = row.asInteger();
        System.arraycopy(this.myValues, idx + 1, this.myValues, idx, this.myRows - 1 - idx);
        this.myValues[this.myRows - 1] = null;
        this.myModifiedRowsCounter.shiftUp(row);
        this.myRowsWithUnparsedValuesCounter.shiftUp(row);
    }

    public int rowCount() {
        return this.myRows;
    }

    public int columnCount() {
        return this.myColumns;
    }

    public int @NotNull [] getAffectedRows() {
        int[] nArray = this.myModifiedRowsCounter.toArray();
        if (nArray == null) {
            MutationsStorage.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public void delete(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            MutationsStorage.$$$reportNull$$$0(6);
        }
        this.delete(rows.asList());
    }

    public void delete(@NotNull List<ModelIndex<DataConsumer.Row>> rows) {
        if (rows == null) {
            MutationsStorage.$$$reportNull$$$0(7);
        }
        rows.forEach(this::delete);
    }

    public void delete(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            MutationsStorage.$$$reportNull$$$0(8);
        }
        if (!this.isValid(rowIdx)) {
            return;
        }
        int i2 = rowIdx.asInteger();
        this.myModifiedRowsCounter.delete(rowIdx);
        this.myRowsWithUnparsedValuesCounter.delete(rowIdx);
        if (i2 < this.myRows) {
            this.myValues[i2] = null;
        }
    }

    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(9);
        }
        return this.isValid(row) && this.isModified(row.asInteger());
    }

    @Nullable
    public MutationData get(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(11);
        }
        int rowIdx = row.asInteger();
        int colIdx = column2.asInteger();
        return !this.isValid(row, column2) || rowIdx >= this.myRows || colIdx >= this.myColumns || this.myValues[rowIdx] == null ? null : this.myValues[rowIdx][colIdx];
    }

    public boolean isModified() {
        return !this.myModifiedRowsCounter.isEmpty();
    }

    public void clear() {
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModifiedRowsCounter.clear();
        this.myRowsWithUnparsedValuesCounter.clear();
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row) {
        return this.isValid(row, null);
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row, @Nullable ModelIndex<DataConsumer.Column> column2) {
        return !(row != null && !row.isValid(this.myModel) || column2 != null && !column2.isValid(this.myModel));
    }

    private void increase(int rows, int columns) {
        this.myRows = rows >= this.myRows ? rows + 1 : this.myRows;
        this.myColumns = columns >= this.myColumns ? columns + 1 : this.myColumns;
    }

    private boolean isModified(int row) {
        return this.myModifiedRowsCounter.contains(row);
    }

    private void countModifications(@Nullable CellMutation value2, int rowIdx, int colIdx) {
        this.myModifiedRowsCounter.countModifications(value2, this.myValues[rowIdx][colIdx], rowIdx);
        this.myRowsWithUnparsedValuesCounter.countModifications(value2, this.myValues[rowIdx][colIdx], rowIdx);
    }

    private void reallocate(int rows, int columns) {
        this.myMaxRows = rows >= this.myMaxRows ? this.getIncreasedValue(rows) : this.myMaxRows;
        this.myMaxColumns = columns >= this.myMaxColumns ? this.getIncreasedValue(columns) : this.myMaxColumns;
        this.increase(rows, columns);
        this.myValues = MutationsStorage.copy(this.myValues, this.myMaxRows, this.myMaxColumns);
        this.myModifiedRowsCounter.reallocate();
        this.myRowsWithUnparsedValuesCounter.reallocate();
    }

    @Override
    public Iterator<Integer> iterator() {
        return Arrays.stream(this.myModifiedRowsCounter.toArray()).iterator();
    }

    public boolean hasUnparsedValues() {
        return !this.myRowsWithUnparsedValuesCounter.isEmpty();
    }

    public boolean hasUnparsedValues(ModelIndex<DataConsumer.Row> row) {
        return this.myRowsWithUnparsedValuesCounter.contains(row.asInteger());
    }

    @NotNull
    private static MutationData[][] copy(@NotNull MutationData[][] from, int rows, int columns) {
        if (from == null) {
            MutationsStorage.$$$reportNull$$$0(12);
        }
        MutationData[][] newArray = new MutationData[rows][];
        for (int i2 = 0; i2 < from.length; ++i2) {
            if (from[i2] == null) continue;
            newArray[i2] = new MutationData[columns];
            System.arraycopy(from[i2], 0, newArray[i2], 0, from[i2].length);
        }
        if (newArray == null) {
            MutationsStorage.$$$reportNull$$$0(13);
        }
        return newArray;
    }

    private int getIncreasedValue(int value2) {
        return (int)Math.round((double)value2 * this.myMultiplier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedRows";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shiftUp";
                break;
            }
            case 5: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RowsWithUnparsedValuesCounter
    extends RowsCounter {
        private RowsWithUnparsedValuesCounter() {
        }

        @Override
        protected int countModifications(@Nullable CellMutation value2, @Nullable MutationData oldValue) {
            return this.unwrap(value2) instanceof UnparsedValue && !(this.unwrap(oldValue) instanceof UnparsedValue) ? 1 : (this.unwrap(oldValue) instanceof UnparsedValue && !(this.unwrap(value2) instanceof UnparsedValue) ? -1 : 0);
        }

        @Nullable
        private Object unwrap(@Nullable CellMutation value2) {
            return value2 == null ? null : value2.getValue();
        }

        @Nullable
        private Object unwrap(@Nullable MutationData value2) {
            return value2 == null ? null : value2.getValue();
        }
    }

    private class ModifiedRowsCounter
    extends RowsCounter {
        private ModifiedRowsCounter() {
        }

        @Override
        protected int countModifications(@Nullable CellMutation value2, @Nullable MutationData oldValue) {
            return value2 != null && oldValue == null ? 1 : (oldValue != null && value2 == null ? -1 : 0);
        }
    }

    private abstract class RowsCounter {
        private final TIntHashSet myRowsSet;
        private int[] myCount;

        RowsCounter() {
            this.myCount = new int[MutationsStorage.this.myMaxRows];
            this.myRowsSet = new TIntHashSet();
        }

        void shiftUp(@NotNull ModelIndex<DataConsumer.Row> row) {
            int[] oldModifiedRows;
            if (row == null) {
                RowsCounter.$$$reportNull$$$0(0);
            }
            int idx = row.asInteger();
            System.arraycopy(this.myCount, idx + 1, this.myCount, idx, MutationsStorage.this.myRows - 1 - idx);
            this.myCount[MutationsStorage.this.myRows - 1] = 0;
            this.myRowsSet.remove(idx);
            TIntHashSet newRowsSet = new TIntHashSet();
            for (int oldRowIdx : oldModifiedRows = this.myRowsSet.toArray()) {
                if (oldRowIdx > idx) {
                    newRowsSet.add(oldRowIdx - 1);
                    continue;
                }
                newRowsSet.add(oldRowIdx);
            }
            this.myRowsSet.clear();
            this.myRowsSet.addAll(newRowsSet.toArray());
        }

        void delete(ModelIndex<DataConsumer.Row> idx) {
            int i2 = idx.asInteger();
            if (i2 < MutationsStorage.this.myRows) {
                this.myCount[i2] = 0;
            }
            this.myRowsSet.remove(i2);
        }

        public boolean isEmpty() {
            return this.myRowsSet.isEmpty();
        }

        public void clear() {
            this.myCount = new int[MutationsStorage.this.myMaxRows];
            this.myRowsSet.clear();
        }

        public boolean contains(int row) {
            return this.myRowsSet.contains(row);
        }

        public void countModifications(@Nullable CellMutation value2, @Nullable MutationData oldValue, int rowIdx) {
            int n = rowIdx;
            this.myCount[n] = this.myCount[n] + this.countModifications(value2, oldValue);
            if (this.myCount[rowIdx] > 0) {
                this.myRowsSet.add(rowIdx);
                return;
            }
            this.myRowsSet.remove(rowIdx);
        }

        protected abstract int countModifications(@Nullable CellMutation var1, @Nullable MutationData var2);

        public void reallocate() {
            int[] myNewCount = new int[MutationsStorage.this.myMaxRows];
            System.arraycopy(this.myCount, 0, myNewCount, 0, this.myCount.length);
            this.myCount = myNewCount;
        }

        public int @NotNull [] toArray() {
            int[] nArray = this.myRowsSet.toArray();
            if (nArray == null) {
                RowsCounter.$$$reportNull$$$0(1);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/MutationsStorage$RowsCounter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage$RowsCounter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "shiftUp";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

