/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.util.DbImplUtil;
import org.jetbrains.annotations.NotNull;

abstract class GridPagingModelImpl<Row, Column>
implements GridPagingModel<Row, Column> {
    protected final GridModel<Row, Column> myModel;

    protected GridPagingModelImpl(GridModel<Row, Column> model) {
        this.myModel = model;
    }

    @Override
    @NotNull
    public ModelIndex<Row> findRow(int rowDataIdx) {
        int modelRowIdx = rowDataIdx >= this.getPageStart() && rowDataIdx <= this.getPageEnd() ? rowDataIdx - this.getPageStart() : -1;
        ModelIndex<Row> modelIndex = ModelIndex.forRow(this.myModel, modelRowIdx);
        if (modelIndex == null) {
            GridPagingModelImpl.$$$reportNull$$$0(0);
        }
        return modelIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPagingModelImpl", "findRow"));
    }

    public static class MultiPage<Row, Column>
    extends GridPagingModelImpl<Row, Column> {
        private int myPageSize = -2;
        private int myPageStart = 1;
        private int myPageEnd;
        private long myTotalRowCount;
        private boolean myTotalRowCountIsPrecise;
        private boolean myTotalRowCountUpdateable;

        protected MultiPage(GridModel<Row, Column> model) {
            super(model);
        }

        @Override
        public boolean isFirstPage() {
            return this.myPageStart == 1;
        }

        @Override
        public boolean isLastPage() {
            return this.myPageEnd == -1 || (long)this.myPageEnd >= this.myTotalRowCount;
        }

        @Override
        public void setPageSize(int pageSize) {
            this.myPageSize = pageSize;
        }

        @Override
        public int getPageSize() {
            return this.myPageSize == -2 ? DbImplUtil.getPageSize() : this.myPageSize;
        }

        @Override
        public boolean pageSizeSet() {
            return this.myPageSize != -2;
        }

        @Override
        public long getTotalRowCount() {
            return this.myTotalRowCount;
        }

        @Override
        public boolean isTotalRowCountPrecise() {
            return this.myTotalRowCountIsPrecise;
        }

        @Override
        public boolean isTotalRowCountUpdateable() {
            return this.myTotalRowCountUpdateable;
        }

        @Override
        public int getPageStart() {
            return this.myPageStart;
        }

        @Override
        public int getPageEnd() {
            return this.myPageEnd;
        }

        void setPageStart(int pageStart) {
            this.myPageStart = pageStart;
        }

        void setPageEnd(int pageEnd) {
            this.myPageEnd = pageEnd;
        }

        void setTotalRowCount(long totalRowCount, boolean precise) {
            this.myTotalRowCount = totalRowCount;
            this.myTotalRowCountIsPrecise = precise;
        }

        void setTotalRowCountUpdateable(boolean updateable) {
            this.myTotalRowCountUpdateable = updateable;
        }
    }

    public static class SinglePage<Row, Column>
    extends GridPagingModelImpl<Row, Column> {
        protected SinglePage(GridModel<Row, Column> model) {
            super(model);
        }

        @Override
        public boolean isFirstPage() {
            return true;
        }

        @Override
        public boolean isLastPage() {
            return true;
        }

        @Override
        public void setPageSize(int pageSize) {
        }

        @Override
        public int getPageSize() {
            return -1;
        }

        @Override
        public boolean pageSizeSet() {
            return false;
        }

        @Override
        public long getTotalRowCount() {
            return this.myModel.getRowCount();
        }

        @Override
        public boolean isTotalRowCountPrecise() {
            return true;
        }

        @Override
        public boolean isTotalRowCountUpdateable() {
            return false;
        }

        @Override
        public int getPageStart() {
            return 1;
        }

        @Override
        public int getPageEnd() {
            return this.myModel.getRowCount();
        }
    }
}

