/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridMutator<Row, Column> {
    public boolean isUpdateSafe(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2, @Nullable Object var3);

    public boolean hasPendingChanges();

    public boolean hasUnparsedValues();

    public boolean isUpdateImmediately();

    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> var1, @NotNull ModelIndexSet<Row> var2, @NotNull ModelIndexSet<Column> var3, @Nullable Object var4, boolean var5);

    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> var1, @NotNull List<CellMutation> var2, boolean var3);

    public static interface ColumnsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteColumns(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Column> var2);

        public void insertColumn(@NotNull GridRequestSource<Row, Column> var1);

        public void cloneColumn(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndex<Column> var2);
    }

    public static interface DatabaseMutator<Row, Column>
    extends RowsMutator<Row, Column> {
        public void submit(@NotNull GridRequestSource<Row, Column> var1, boolean var2);

        @NotNull
        public String getPendingChanges();

        @Nullable
        public MutationType getMutationType(@NotNull ModelIndex<Row> var1);

        public boolean hasUnparsedValues(@NotNull ModelIndex<Row> var1);

        @Nullable
        public MutationData getMutation(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

        @Nullable
        public MutationType getMutationType(@NotNull ModelIndex<Row> var1, @NotNull ModelIndex<Column> var2);

        public boolean isFailed();

        public boolean hasMutatedRows(@NotNull ModelIndexSet<DataConsumer.Row> var1, @NotNull ModelIndexSet<DataConsumer.Column> var2);

        public void revert(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Row> var2, @NotNull ModelIndexSet<Column> var3);
    }

    public static interface RowsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteRows(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Row> var2);

        public void insertRow(@NotNull GridRequestSource<Row, Column> var1);

        public void cloneRow(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndex<Row> var2);

        public boolean isDeletedRow(@NotNull ModelIndex<Row> var1);

        public boolean isDeletedRows(@NotNull ModelIndexSet<Row> var1);

        public boolean isInsertedRow(@NotNull ModelIndex<Row> var1);

        @Nullable
        public ModelIndex<Row> getLastInsertedRow();

        @NotNull
        public ModelIndexSet<Row> getAffectedRows();
    }
}

